/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.HttpRequests;
import org.eclipse.jdt.annotation.Nullable;

public final class ResourceInfo
implements EntityInfo {
    private long contentLength = -1L;
    private long lastModified = -1L;
    private @Nullable String lastModifiedHttp = null;
    private @Nullable String mimeType = null;
    private @Nullable String name = null;
    private @Nullable String weakETag = null;
    private @Nullable String strongETag = null;

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long length) {
        this.contentLength = length;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long modified) {
        this.lastModified = modified;
        this.lastModifiedHttp = HttpRequests.toLastModified((long)modified);
    }

    public @Nullable String getLastModifiedHttp() {
        return this.lastModifiedHttp;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public @Nullable String getETag() {
        if (this.strongETag != null) {
            return this.strongETag;
        }
        if (this.weakETag == null) {
            long length = this.getContentLength();
            long modified = this.getLastModified();
            if (length >= 0L || modified >= 0L) {
                this.weakETag = "W/\"" + length + "-" + modified + "\"";
            }
        }
        return this.weakETag;
    }

    public void setETag(String eTag) {
        this.strongETag = eTag;
    }

    public String toString() {
        return "[name=" + this.name + ", length" + this.contentLength + ", lastmodified" + this.lastModified + ", mime" + this.mimeType + ", etag" + this.getETag() + "]";
    }
}

