/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.publish.PublishJobDetails;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.LoggerFactory;

public final class PublishJobs {
    private static final Map<String, PublishJobDetails> CURRENT_JOBS = new ConcurrentHashMap<String, PublishJobDetails>();

    private PublishJobs() {
    }

    public static boolean hasJobs() {
        return !CURRENT_JOBS.isEmpty();
    }

    public static boolean hasJob(String jobid) {
        return CURRENT_JOBS.containsKey(jobid);
    }

    public static void removeJob(String jobid) {
        if (jobid == null) {
            return;
        }
        CURRENT_JOBS.remove(jobid);
    }

    public static void synchroniseJob(PublishJobDetails job) {
        if (job == null) {
            return;
        }
        if (job.isCompleted()) {
            CURRENT_JOBS.remove(job.id());
        } else {
            CURRENT_JOBS.put(job.id(), job);
        }
    }

    public static String getCurrentJobsAsXML(@Nullable String groupname) {
        XMLStringWriter jobsxml = new XMLStringWriter(XML.NamespaceAware.No);
        jobsxml.openElement("jobs");
        for (String id : CURRENT_JOBS.keySet()) {
            PublishJobDetails jd = CURRENT_JOBS.get(id);
            if (groupname != null && !groupname.equals(jd.getGroup())) continue;
            try {
                jd.toXML((XMLWriter)jobsxml);
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(PublishJobs.class).error("Failed to write job as XML: ", (Throwable)ex);
            }
        }
        jobsxml.closeElement();
        return jobsxml.toString();
    }

    public static void printCurrentJobs(@Nullable String groupname, UniversalPrinter out) {
        out.startCollection("jobs");
        for (String id : CURRENT_JOBS.keySet()) {
            PublishJobDetails jd = CURRENT_JOBS.get(id);
            if (groupname != null && !groupname.equals(jd.getGroup())) continue;
            jd.print((OutputPrinter)out);
        }
        out.endCollection();
    }

    public static String getJobAsXML(String jobid) {
        if (jobid == null) {
            return null;
        }
        PublishJobDetails jd = CURRENT_JOBS.get(jobid);
        if (jd == null) {
            return "<job />";
        }
        XMLStringWriter jobasxml = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            jd.toXML((XMLWriter)jobasxml);
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(PublishJobs.class).error("Failed to write job as XML: ", (Throwable)ex);
        }
        return jobasxml.toString();
    }

    public static PublishJobDetails getJob(String jobid) {
        return CURRENT_JOBS.get(jobid);
    }
}

