/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml.mediator;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.StructureBuilder;
import com.pageseeder.base.url.URLCreator;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.xml.FatalErrorHandler;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.URI;
import com.pageseeder.load.edits.ContentPart;
import com.pageseeder.load.edits.Fragment;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class DocumentContentLoader
extends StructureBuilder {
    private static final String XML_WRITING_FAILED = "Failed to write XML output: ";
    private static final String METADATA_FRAGMENT = "default";
    private static SAXParserFactory factory;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private final List<ContentPart> contents = new ArrayList<ContentPart>();
    private final List<String> lockedSections = new ArrayList<String>();
    private final Map<String, Fragment> fragments = new ConcurrentHashMap<String, Fragment>();
    private final StringBuilder tempCharacters = new StringBuilder();
    private Writer writer = new StringWriter();
    private XMLWriter xml = new XMLWriterNSImpl(this.writer, false);
    private boolean buildStructure = false;
    private Writer comparisonWriter = new StringWriter();
    private XMLWriter comparisonXml = new XMLWriterNSImpl(this.comparisonWriter, false);
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private Fragment currentFragment = null;
    private String currentSectionId = null;
    private final com.pageseeder.url.URLCreator urlCreator;
    private final URI currentUri;
    private final Database database;
    private String currentLocatorFragment = null;
    private String noteTitle = null;
    private String noteContent = null;
    private String noteLabels = null;
    private boolean storeText = false;
    private boolean inDocumentInfo = false;
    private boolean whiteSpaceSignificant = false;
    private boolean ignoreUriIdOnXRefCreate = false;
    private boolean createNewFragments = false;

    public DocumentContentLoader(URI uri, Database db, com.pageseeder.url.URLCreator urlCreator) {
        this.currentUri = uri;
        this.urlCreator = urlCreator;
        this.database = db;
    }

    void setBuildStructure() {
        this.buildStructure = true;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        this.xml.setPrefixMapping(uri, prefix);
        this.comparisonXml.setPrefixMapping(uri, prefix);
    }

    public void endPrefixMapping(String prefix) {
        this.namespaces.remove(prefix);
    }

    /*
     * WARNING - void declaration
     */
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean isFragment = PSMLContentUtils.isFragmentElement((String)localName);
        if ("compareto".equals(localName) || "compare".equals(localName)) {
            this.inCompare = true;
        }
        if (this.inCompare) {
            return;
        }
        boolean stripMediaFragment = false;
        if (this.inMediaFragment == 0) {
            if ("locator".equals(localName)) {
                String locFragment = atts.getValue("fragment");
                if (locFragment != null) {
                    this.currentLocatorFragment = this.getFragmentIDs().getOrDefault(locFragment.toLowerCase(), locFragment);
                    Fragment fragment = new Fragment(this.currentLocatorFragment, "application/vnd.pageseeder.psml+xml");
                    fragment.setDeleted(true);
                    fragment.setEditXLinkID(atts.getValue("editid"));
                    this.fragments.put(this.currentLocatorFragment, fragment);
                } else {
                    this.currentLocatorFragment = null;
                }
            } else if ("labels".equals(localName) || this.noteTitle != null && "content".equals(localName)) {
                this.storeText = true;
                this.tempCharacters.setLength(0);
            } else if ("note".equals(localName)) {
                this.noteTitle = atts.getValue("title");
            } else if (isFragment && !"true".equals(atts.getValue("deleted"))) {
                String frag = atts.getValue("id");
                if (frag != null) {
                    String labels;
                    String string = this.getFragmentIDs().getOrDefault(frag.toLowerCase(), frag);
                    this.currentFragment = this.fragments.get(string);
                    if (this.currentFragment == null) {
                        this.currentFragment = new Fragment(string, "application/vnd.pageseeder.psml+xml");
                        this.fragments.put(string, this.currentFragment);
                    } else {
                        this.currentFragment.setDeleted(false);
                    }
                    this.currentFragment.setSectionId(this.currentSectionId);
                    String mediatype = atts.getValue("mediatype");
                    if (mediatype != null) {
                        this.currentFragment.setContentType(mediatype);
                    }
                    if ((labels = atts.getValue("labels")) != null) {
                        this.currentFragment.setLabels(labels);
                    }
                    this.resetWriters();
                    stripMediaFragment = PSMLContentUtils.isMediaFragmentElement((String)localName);
                }
            } else if ("section".equals(localName)) {
                this.currentSectionId = atts.getValue("id");
                if ("false".equals(atts.getValue("overwrite"))) {
                    this.lockedSections.add(this.currentSectionId);
                }
            } else if ("fragments".equals(localName)) {
                this.currentSectionId = "fragments";
                if ("false".equals(atts.getValue("overwrite"))) {
                    this.lockedSections.add(this.currentSectionId);
                    this.createNewFragments = true;
                }
                for (Map.Entry entry : this.fragments.entrySet()) {
                    Fragment frag;
                    if (((String)entry.getKey()).equals(METADATA_FRAGMENT) || (frag = (Fragment)entry.getValue()).sectionId() != null) continue;
                    frag.setSectionId(this.currentSectionId);
                }
            } else if ("documentinfo".equals(localName)) {
                this.inDocumentInfo = true;
            } else if (this.inDocumentInfo && "uri".equals(localName)) {
                String scheme = atts.getValue("scheme");
                String string = atts.getValue("host");
                String port = atts.getValue("port");
                if (scheme != null && string != null && port != null) {
                    this.ignoreUriIdOnXRefCreate = !scheme.equals(this.currentUri.getScheme()) || !string.equals(this.currentUri.getHost().getName()) || !port.equals(String.valueOf(this.currentUri.getPort()));
                }
            } else if ("properties".equals(localName)) {
                String fragid = METADATA_FRAGMENT;
                this.currentFragment = new Fragment(fragid, "application/vnd.pageseeder.psml+xml");
                this.fragments.put(fragid, this.currentFragment);
                this.resetWriters();
            } else if ("metadata".equals(localName)) {
                this.currentLocatorFragment = METADATA_FRAGMENT;
            }
        }
        if (this.currentFragment != null) {
            if (this.inMediaFragment == 0 && ("xref".equalsIgnoreCase(localName) || "blockxref".equalsIgnoreCase(localName) || "image".equalsIgnoreCase(localName) || "link".equalsIgnoreCase(localName))) {
                XRef xr = new XRef(this.currentUri, this.currentFragment.getFragment(), atts, localName, false, this.ignoreUriIdOnXRefCreate);
                try {
                    this.xml.writeText("");
                    String string = this.tempCharacters.toString();
                    if (!string.trim().isEmpty() || this.whiteSpaceSignificant) {
                        this.comparisonXml.writeText(string);
                    }
                    this.tempCharacters.setLength(0);
                    this.comparisonXml.writeText("");
                }
                catch (IOException iOException) {
                    this.errors.add(XML_WRITING_FAILED + iOException.getMessage());
                }
                this.contents.add(new ContentPart(this.writer.toString(), this.comparisonWriter.toString()));
                this.contents.add(new ContentPart(xr));
                this.resetWriters();
            } else {
                try {
                    String s;
                    if (!stripMediaFragment) {
                        this.xml.openElement(uri == null || uri.isEmpty() ? null : uri, localName, true);
                    }
                    if (!(s = this.tempCharacters.toString()).trim().isEmpty() || this.whiteSpaceSignificant) {
                        this.comparisonXml.writeText(s);
                    }
                    this.tempCharacters.setLength(0);
                    if (!stripMediaFragment) {
                        void var8_17;
                        this.comparisonXml.openElement(uri == null || uri.isEmpty() ? null : uri, localName, true);
                        boolean bl = false;
                        while (var8_17 < atts.getLength()) {
                            String auri = atts.getURI((int)var8_17);
                            if (auri != null && auri.length() == 0) {
                                auri = null;
                            }
                            String name = atts.getLocalName((int)var8_17);
                            String value = atts.getValue((int)var8_17);
                            if (!isFragment || !"labels".equals(name)) {
                                if (isFragment && "id".equalsIgnoreCase(name)) {
                                    value = this.getFragmentIDs().getOrDefault(value.toLowerCase(), value);
                                }
                                this.xml.attribute(auri, name, value);
                                this.comparisonXml.attribute(auri, name, value);
                            }
                            ++var8_17;
                        }
                    }
                }
                catch (IOException ioe) {
                    this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
                }
            }
        }
        if (this.buildStructure) {
            super.startElement(uri, localName, qName, atts);
        } else if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
            ++this.inMediaFragment;
        }
        if (this.inMediaFragment == 0 && ("heading".equals(localName) || "para".equals(localName) || "preformat".equals(localName))) {
            this.whiteSpaceSignificant = true;
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.buildStructure) {
            super.endElement(uri, localName, name);
        } else if (PSMLContentUtils.isMediaFragmentElement((String)localName)) {
            --this.inMediaFragment;
        }
        if ("compareto".equals(localName) || "compare".equals(localName)) {
            this.inCompare = false;
            return;
        }
        if (this.inCompare) {
            return;
        }
        if (this.inMediaFragment == 0) {
            if ("section".equals(localName) || "fragments".equals(localName)) {
                this.currentSectionId = null;
            }
            if (this.currentLocatorFragment != null && this.noteTitle != null) {
                switch (localName) {
                    case "labels": {
                        this.noteLabels = this.tempCharacters.toString();
                        break;
                    }
                    case "content": {
                        this.noteContent = this.tempCharacters.toString();
                        break;
                    }
                    case "note": {
                        Fragment f = this.fragments.get(this.currentLocatorFragment);
                        f.addNote(this.noteTitle, this.noteContent, this.noteLabels);
                        this.noteTitle = null;
                    }
                }
            } else if (this.currentLocatorFragment != null && "labels".equals(localName)) {
                Fragment f = this.fragments.get(this.currentLocatorFragment);
                f.setLabels(this.tempCharacters.toString());
            } else if ("locator".equals(localName)) {
                this.currentLocatorFragment = null;
            } else if ("documentinfo".equals(localName)) {
                this.inDocumentInfo = false;
            } else if ("metadata".equals(localName)) {
                this.currentLocatorFragment = null;
            }
        }
        if (this.currentFragment != null) {
            if (this.inMediaFragment == 0 && ("xref".equalsIgnoreCase(localName) || "blockxref".equalsIgnoreCase(localName) || "image".equalsIgnoreCase(localName) || "link".equalsIgnoreCase(localName))) {
                ContentPart xref;
                String xrefText = this.writer.toString();
                if (xrefText.length() > 0 && (xref = this.contents.get(this.contents.size() - 1)).hasXRef()) {
                    String title;
                    XRef xr = xref.getXRef();
                    xr.setContent(xrefText);
                    if ("manual".equals(xr.getDisplay()) && ((title = xr.getTitle()) == null || title.isEmpty())) {
                        xr.setTitle(XMLHelpers.xmlToText((String)xrefText));
                    }
                }
                this.resetWriters();
            } else {
                try {
                    String s;
                    if (!PSMLContentUtils.isMediaFragmentElement((String)localName)) {
                        this.xml.writeXML("</" + name + ">");
                    }
                    if (!(s = this.tempCharacters.toString()).trim().isEmpty() || this.whiteSpaceSignificant) {
                        this.comparisonXml.writeText(s);
                    }
                    this.tempCharacters.setLength(0);
                    if (!PSMLContentUtils.isMediaFragmentElement((String)localName)) {
                        this.comparisonXml.writeXML("</" + name + ">");
                    }
                }
                catch (IOException ioe) {
                    this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
                }
            }
        }
        if ((PSMLContentUtils.isFragmentElement((String)localName) || "properties".equals(localName)) && this.inMediaFragment == 0 && this.currentFragment != null) {
            try {
                this.writer.close();
                this.comparisonWriter.close();
                this.contents.add(new ContentPart(this.writer.toString(), this.comparisonWriter.toString()));
            }
            catch (IOException ioe) {
                this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
            }
            this.setCurrentContents();
            this.contents.clear();
            this.currentFragment = null;
        }
        this.tempCharacters.setLength(0);
        if (this.inMediaFragment == 0 && ("heading".equals(localName) || "para".equals(localName) || "preformat".equals(localName))) {
            this.whiteSpaceSignificant = false;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buildStructure) {
            super.characters(ch, start, length);
        }
        if (this.currentFragment != null) {
            try {
                String s = new String(ch, start, length);
                this.tempCharacters.append(s);
                this.xml.writeText(s);
            }
            catch (IOException ioe) {
                this.errors.add(XML_WRITING_FAILED + ioe.getMessage());
            }
        } else if (this.storeText) {
            this.tempCharacters.append(ch, start, length);
        }
    }

    public void endDocument() {
        this.contents.clear();
    }

    public Collection<String> getFragments() {
        return this.fragments.keySet();
    }

    public Fragment getFragment(String fragment) {
        return this.fragments.get(fragment);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean allowsOverwrite(Fragment fragment) {
        return fragment == null || !this.lockedSections.contains(fragment.sectionId());
    }

    public boolean canCreateNewFragments() {
        return this.createNewFragments;
    }

    private void setCurrentContents() {
        boolean empty = true;
        for (ContentPart part : this.contents) {
            if (part.hasXRef()) {
                if (this.urlCreator != null) {
                    String basePath = this.currentUri.getPath();
                    basePath = basePath.substring(0, basePath.lastIndexOf(47));
                    part.getXRef().retrieveTarget(this.database, this.currentUri.getScheme(), this.currentUri.getHost().getName(), this.currentUri.getPort(), basePath, (URLCreator)this.urlCreator);
                    String warning = part.getXRef().getWarning();
                    if (warning != null) {
                        this.warnings.add(warning);
                    }
                    if (part.getXRef().wasModified()) {
                        this.currentFragment.setHasModifiedXRefs(true);
                    }
                    this.currentFragment.addXref(part.getXRef());
                }
                empty = false;
                continue;
            }
            if (part.toString().length() <= 0) continue;
            empty = false;
        }
        if (empty && METADATA_FRAGMENT.equals(this.currentFragment.getFragment())) {
            this.fragments.remove(METADATA_FRAGMENT);
        } else {
            this.currentFragment.addContents(this.contents);
        }
    }

    private void resetWriters() {
        this.writer = new StringWriter();
        this.xml = new XMLWriterNSImpl(this.writer, false);
        for (String prefix : this.namespaces.keySet()) {
            this.xml.setPrefixMapping(this.namespaces.get(prefix), prefix);
        }
        this.comparisonWriter = new StringWriter();
        this.comparisonXml = new XMLWriterNSImpl(this.comparisonWriter, false);
        for (String prefix : this.namespaces.keySet()) {
            this.comparisonXml.setPrefixMapping(this.namespaces.get(prefix), prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream xmlContents) throws SAXException, IOException {
        XMLReader reader;
        try {
            if (factory == null) {
                DocumentContentLoader.initFactory();
            }
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Failed to create an XML Reader", ex);
        }
        reader.setContentHandler((ContentHandler)((Object)this));
        reader.setErrorHandler((ErrorHandler)new FatalErrorHandler());
        try {
            reader.parse(new InputSource(xmlContents));
        }
        finally {
            xmlContents.close();
        }
    }

    private static void initFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory f = XMLHelpers.safeSAXParserFactory();
        f.setValidating(false);
        f.setNamespaceAware(true);
        factory = f;
    }
}

