/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.DocumentTracker;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(group=true, uri=true)
@Output(types={OutputType.XML})
public class TrackDocumentContent
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackDocumentContent.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        long compareid = req.getParameter((Parameter)StandardParameters.compareid, -2L);
        long versionid = req.getParameter((Parameter)StandardParameters.versionid, -2L);
        if (uri.getExternal().booleanValue() || !"application/vnd.pageseeder.psml+xml".equals(uri.getType())) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URLs and non-PSML documents can not be tracked");
            return;
        }
        if (versionid >= 0L && compareid > versionid) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The parameter versionid cannot be less than compareid");
            return;
        }
        Publication publication = null;
        int position = 1;
        boolean usePublication = "true".equals(req.getParameter((Parameter)StandardParameters.publication));
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        if (publicationid == null) {
            publicationid = req.getHttpServletRequest().getParameter("publicationid");
        }
        String positionStr = req.getParameter((Parameter)StandardParameters.position);
        String version = XLinkRule.getVersionName((Database)db, (URI)uri, (Long)versionid, publication);
        if (usePublication) {
            if (!"".equals(publicationid)) {
                UserDetails userdetails = req.getMember() == null ? SecurityUtils.getDefaultUserDetails() : new UserDetailsManager().get(req.getDatabase(), req.getMember().getId());
                publication = Publications.getDefaultPublication((Database)db, (URI)uri, (UserDetails)userdetails, (Group)group, (String)version, (String)publicationid);
                position = Publications.getDefaultPosition((Database)db, (URI)uri, (Publication)publication, (String)version, (int)position, (String)positionStr);
            } else {
                publication = Publications.blank((URI)uri, (Group)group);
            }
        }
        try {
            DocumentTracker tracker = new DocumentTracker(uri, group, db, req.getTransaction(), "true".equals(req.getParameter((Parameter)StandardParameters.original)));
            tracker.setLimitIds(compareid, versionid);
            XMLStringWriter psmlwriter = new XMLStringWriter(XML.NamespaceAware.Yes);
            tracker.track((XMLWriter)psmlwriter);
            String psml = psmlwriter.toString();
            if (publication != null) {
                try {
                    String cversion = XLinkRule.getVersionName((Database)db, (URI)uri, (Long)compareid, (Publication)publication);
                    InputStream ins = DocumentContentResolver.adjustContent((Database)db, (Publication)publication, (int)position, (URI)uri, (Group)group, (String)psml, (boolean)false, (String)cversion, (boolean)false, null, (boolean)true, null, null);
                    psml = IOUtils.toString((InputStream)ins, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to adjust content for URIID {} compareID {}", new Object[]{uri.getId(), compareid, ex});
                }
                try {
                    InputStream ins = DocumentContentResolver.adjustContent((Database)db, (Publication)publication, (int)position, (URI)uri, (Group)group, (String)psml, (boolean)false, (String)version, (boolean)false, null, (boolean)false, null, null);
                    psml = IOUtils.toString((InputStream)ins, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to adjust content for URIID {} versionID {}", new Object[]{uri.getId(), versionid, ex});
                }
            }
            XMLWriter xml = res.getXMLWriter();
            xml.writeXML(psml);
        }
        catch (URIException | DatabaseException | IOException ex) {
            LOGGER.error("Failed to track content changes for document {}", (Object)uri.getId(), (Object)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to track content changes");
        }
    }
}

