/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.utils.ContentMatcher;
import com.pageseeder.utils.MatchOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.jdt.annotation.Nullable;

public final class PSMLContentMatcher {
    private final String term;
    private List<String> lockedStatuses = Collections.emptyList();
    MatchOptions options = MatchOptions.exactMatch();

    public PSMLContentMatcher(String term) {
        this.term = term;
    }

    public void setOptions(MatchOptions options) {
        this.options = options;
    }

    public List<PSMLContentMatch> listMatches(Database db, Group group, URI uri) throws URIException, IOException {
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setPSMLFormat(true);
        try (InputStream content = resolver.getContent(db);){
            List<PSMLContentMatch> list = this.listMatches(content, uri.getId());
            return list;
        }
    }

    public void loadLockStatuses(Database db, Group group) {
        try {
            Properties properties = GroupProperties.get((Database)db, (Group)group);
            String statuses = properties.getProperty("documentStatusLocked", "");
            this.lockedStatuses = Arrays.stream(statuses.split(",")).collect(Collectors.toList());
        }
        catch (QueryFailedException | IOException ex) {
            this.lockedStatuses = Collections.emptyList();
        }
    }

    public List<PSMLContentMatch> listMatches(InputStream content, long uriid) {
        ArrayList<PSMLContentMatch> matches = new ArrayList<PSMLContentMatch>();
        this.collectMatches(content, uriid, matches);
        return matches;
    }

    private void collectMatches(InputStream content, long uriid, List<PSMLContentMatch> matches) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isNamespaceAware", true);
        ContentMatcher matcher = new ContentMatcher(this.term, this.options);
        try {
            XMLEventReader xml = factory.createXMLEventReader(content);
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            HashMap<String, String> lastModified = new HashMap<String, String>();
            boolean inFragment = false;
            boolean readonlyDocument = false;
            boolean readonlySection = false;
            String fragmentId = null;
            while (xml.hasNext()) {
                XMLEvent event = xml.nextEvent();
                if (event.isStartElement()) {
                    StartElement start = event.asStartElement();
                    if (this.isElement(start.getName(), "locator")) {
                        String fragment = PSMLContentMatcher.getAttribute(start, "fragment");
                        String modified = PSMLContentMatcher.getAttribute(start, "modified");
                        lastModified.put(fragment, modified);
                    } else if (this.isElement(start.getName(), "fragment")) {
                        inFragment = true;
                        fragmentId = PSMLContentMatcher.getAttribute(event.asStartElement(), "id");
                    } else if (this.isElement(start.getName(), "section")) {
                        readonlySection = "false".equals(PSMLContentMatcher.getAttribute(event.asStartElement(), "edit"));
                    } else if (this.isElement(start.getName(), "document")) {
                        String status = PSMLContentMatcher.getAttribute(event.asStartElement(), "status");
                        boolean isLocked = status != null && this.lockedStatuses.contains(status);
                        boolean isReadonly = "false".equals(PSMLContentMatcher.getAttribute(event.asStartElement(), "edit"));
                        readonlyDocument = isReadonly || isLocked;
                    }
                } else if (event.isEndElement()) {
                    if (this.isElement(event.asEndElement().getName(), "fragment")) {
                        inFragment = false;
                        events.add(event);
                        PSMLContentMatch match = this.processFragment(events, matcher, uriid, fragmentId);
                        if (match != null) {
                            match.setModified((String)lastModified.get(fragmentId));
                            if (readonlyDocument || readonlySection) {
                                match.setEditable(false);
                            }
                            matches.add(match);
                        }
                        events.clear();
                    } else if (this.isElement(event.asEndElement().getName(), "section")) {
                        readonlySection = false;
                    }
                }
                if (!inFragment) continue;
                events.add(event);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private static PSMLBlock getBlock(QName name, PSMLBlock current) {
        if ("block".equals(name.getLocalPart())) {
            return PSMLBlock.BLOCK;
        }
        if ("para".equals(name.getLocalPart())) {
            return PSMLBlock.PARA;
        }
        if ("cell".equals(name.getLocalPart())) {
            return PSMLBlock.CELL;
        }
        if ("heading".equals(name.getLocalPart())) {
            return PSMLBlock.HEADING;
        }
        if ("item".equals(name.getLocalPart())) {
            return PSMLBlock.LIST_ITEM;
        }
        if ("value".equals(name.getLocalPart())) {
            return PSMLBlock.VALUE;
        }
        return current;
    }

    private boolean isElement(QName name, String localName) {
        return localName.equals(name.getLocalPart());
    }

    private static PSMLBlock getBlock(QName name) {
        return PSMLContentMatcher.getBlock(name, null);
    }

    private static @Nullable String getAttribute(StartElement element, String localName) {
        Attribute attribute = element.getAttributeByName(new QName(localName));
        return attribute != null ? attribute.getValue() : null;
    }

    private @Nullable PSMLContentMatch processFragment(List<XMLEvent> events, ContentMatcher matcher, long uriid, String fragment) throws XMLStreamException {
        ArrayList<String> extracts = new ArrayList<String>();
        List<ContentMatcher.MatchLocation> locations = this.findLocations(events, matcher, extracts);
        if (!locations.isEmpty()) {
            String content = this.mark(events, locations);
            return new PSMLContentMatch(uriid, fragment, content, locations.size(), extracts);
        }
        return null;
    }

    private List<ContentMatcher.MatchLocation> findLocations(List<XMLEvent> events, ContentMatcher matcher, List<String> extracts) {
        PSMLBlock current = null;
        StringBuilder buffer = new StringBuilder();
        ArrayList<ContentMatcher.MatchLocation> locations = new ArrayList<ContentMatcher.MatchLocation>();
        int offset = 0;
        for (XMLEvent event : events) {
            EndElement end;
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                current = PSMLContentMatcher.getBlock(start.getName(), current);
                continue;
            }
            if (event.isCharacters()) {
                String text = event.asCharacters().getData();
                if (current != null) {
                    buffer.append(text);
                    continue;
                }
                offset += text.length();
                continue;
            }
            if (!event.isEndElement() || current != PSMLContentMatcher.getBlock((end = event.asEndElement()).getName())) continue;
            String text = buffer.toString();
            current = null;
            buffer.setLength(0);
            if (matcher.hasMatch(text)) {
                ContentMatcher.MatchResult result = matcher.getResult(text, 100);
                for (ContentMatcher.MatchLocation location : result.locations()) {
                    locations.add(location.offset(offset));
                }
                extracts.add(result.extract());
            }
            offset += text.length();
        }
        return locations;
    }

    private String mark(List<XMLEvent> events, List<ContentMatcher.MatchLocation> locations) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        StringWriter out = new StringWriter();
        XMLStreamWriter xml = factory.createXMLStreamWriter(out);
        int offset = 0;
        ArrayDeque<StartElement> context = new ArrayDeque<StartElement>();
        for (XMLEvent event : events) {
            if (event.isCharacters()) {
                String text = event.asCharacters().getData();
                int upto = 0;
                for (ContentMatcher.MatchLocation location : locations) {
                    boolean isXref;
                    if (!location.inRange(text, offset)) continue;
                    ContentMatcher.MatchLocation local = location.offset(-offset);
                    if (local.getStart() > upto) {
                        xml.writeCharacters(text.substring(upto, local.getStart()));
                    }
                    xml.writeStartElement("mark");
                    String mark = local.substring(text);
                    boolean bl = isXref = context.peek() != null && ((StartElement)context.peek()).getName().getLocalPart().equals("xref");
                    if (mark.length() < local.length() || isXref) {
                        xml.writeAttribute("partial", "true");
                    }
                    xml.writeCharacters(mark);
                    xml.writeEndElement();
                    upto = local.getEnd();
                }
                if (upto < text.length()) {
                    xml.writeCharacters(text.substring(upto));
                }
                offset += text.length();
                continue;
            }
            if (event.isStartElement()) {
                StartElement start = event.asStartElement();
                context.push(start);
                xml.writeStartElement(start.getName().getLocalPart());
                Iterator<Attribute> i = start.getAttributes();
                while (i.hasNext()) {
                    Attribute attribute = i.next();
                    xml.writeAttribute(attribute.getName().getLocalPart(), attribute.getValue());
                }
                continue;
            }
            if (!event.isEndElement()) continue;
            context.pop();
            xml.writeEndElement();
        }
        xml.flush();
        return out.toString();
    }

    public static final class PSMLContentMatch {
        private final long uriid;
        private final String fragment;
        private final String content;
        private final List<String> extracts;
        private final int count;
        private String modified;
        private boolean editable = true;

        public PSMLContentMatch(long uriid, String fragment, String content, int count, List<String> extracts) {
            this.uriid = uriid;
            this.fragment = fragment;
            this.content = content;
            this.count = count;
            this.extracts = extracts;
        }

        public void setModified(String modified) {
            this.modified = modified;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        public String getModified() {
            return this.modified;
        }

        public long getUriid() {
            return this.uriid;
        }

        public String getFragment() {
            return this.fragment;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public @Nullable String getExtract() {
            return !this.extracts.isEmpty() ? this.extracts.get(0) : null;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "PSMLContentMatch{" + this.uriid + ":" + this.fragment + "(" + this.getCount() + ")=" + this.content + "}";
        }
    }

    private static enum PSMLBlock {
        BLOCK,
        PARA,
        CELL,
        VALUE,
        PROPERTY,
        HEADING,
        LIST_ITEM;

    }
}

