/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(uri=true, group=true, member=true, parameters={"fragment"})
public final class MoveFragment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveFragment.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new AddEditXLinksCheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String newContent;
        URI uri = req.getURI();
        assert (uri != null);
        if (!URIRule.isPSML((URI)uri) || uri.isExternal()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "URI must be an internal PSML document");
            return;
        }
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String section = req.getParameter((Parameter)StandardParameters.section);
        String beforefragment = req.getParameter((Parameter)StandardParameters.beforefragment);
        String afterfragment = req.getParameter((Parameter)StandardParameters.afterfragment);
        if (section == null && beforefragment == null && afterfragment == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing parameter: one of 'section', 'beforefragment' or 'afterfragment' is required");
            return;
        }
        Member author = req.getMember();
        Database db = req.getDatabase();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        assert (fragment != null && author != null);
        if (afterfragment != null || beforefragment != null) {
            String frag;
            String string = frag = afterfragment == null ? beforefragment : afterfragment;
            if (!URIRule.hasFragment((URI)uri, (Group)group, (String)frag, (Database)req.getDatabase())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + frag);
                return;
            }
        }
        Structure.MoveDetails moveDetails = new Structure.MoveDetails(fragment, section, afterfragment, beforefragment);
        try {
            XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
            if (PSML.structureClash(structure, req.getParameter((Parameter)StandardParameters.lastmodified), res)) {
                return;
            }
            Structure.MoveResult move = Structure.moveFragment(structure, moveDetails, uri, group, author, db);
            if (move != Structure.MoveResult.SUCCESS) {
                Object msg = "";
                if (move == Structure.MoveResult.FRAG_NOT_FOUND || move == Structure.MoveResult.FRAG_AND_TARGET_NOT_FOUND) {
                    msg = (String)msg + "fragment not found with ID " + fragment;
                }
                if (move == Structure.MoveResult.FRAG_AND_TARGET_NOT_FOUND) {
                    msg = (String)msg + " and ";
                }
                if (move == Structure.MoveResult.TARGET_NOT_FOUND || move == Structure.MoveResult.FRAG_AND_TARGET_NOT_FOUND) {
                    msg = afterfragment != null ? (String)msg + "target fragment not found with ID " + afterfragment : (beforefragment != null ? (String)msg + "target fragment not found with ID " + beforefragment : (String)msg + "section not found with ID " + section);
                }
                res.setError(GeneratorStatus.BAD_REQUEST, (String)msg);
                return;
            }
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to update URI structure XLink", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to update URI's structure: " + ex.getMessage());
            return;
        }
        uri.setLastModified(new Date());
        req.getTransaction().commitAndStart();
        Publications.updateURI((URI)uri);
        ChangesManager.getInstance().modifyURI(db, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("fragment-move");
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setFragment(fragment);
        resolver.setFragmentInfo(true);
        try {
            newContent = IOUtils.toString((InputStream)resolver.getContent(req.getDatabase()), (Charset)StandardCharsets.UTF_8);
        }
        catch (URIException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
            return;
        }
        newContent = newContent == null || newContent.isEmpty() ? "<document-fragment/>" : newContent.replaceAll("<\\?xml(.*?)>", "");
        xml.writeXML(newContent);
        xml.closeElement();
    }
}

