/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.common.util.Strings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterNSImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class IncomingContentHandler
extends DefaultHandler {
    private static final String ID_ATTRIBUTE = "id";
    private static final String LABELS_ATTRIBUTE = "labels";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String MEDIATYPE_ATTRIBUTE = "mediatype";
    private XMLWriter xml = null;
    private final Writer out;
    private final String newFragment;
    private final String fragType;
    private String loadedFragType;
    private String loadedMediaType = null;
    private String rootElement = null;
    private boolean mediaFragmentStripped = false;
    private boolean fragmentFound = false;
    private boolean metadataFound = false;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private int inMediaFragment = 0;

    IncomingContentHandler(Writer output, String newfrag, String type) {
        this.out = output;
        this.newFragment = newfrag;
        this.loadedFragType = this.fragType = type;
    }

    public boolean isMetadata() {
        return this.metadataFound;
    }

    String getRootElement() {
        return this.rootElement;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        if (this.xml != null) {
            this.xml.setPrefixMapping(uri, prefix);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.namespaces.remove(prefix);
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
        boolean isFragment;
        if (this.rootElement == null) {
            this.rootElement = lName;
        }
        boolean bl = isFragment = PSMLContentUtils.isFragmentElement((String)lName) && this.inMediaFragment == 0;
        if (isFragment) {
            this.fragmentFound = true;
        }
        if ("properties".equals(lName) && !this.fragmentFound) {
            this.metadataFound = true;
        }
        if (PSMLContentUtils.isMediaFragmentElement((String)lName) && this.inMediaFragment == 0) {
            if (this.loadedFragType == null) {
                this.loadedFragType = atts.getValue(TYPE_ATTRIBUTE);
            }
            this.loadedMediaType = atts.getValue(MEDIATYPE_ATTRIBUTE);
            this.mediaFragmentStripped = true;
        } else {
            if (this.xml == null) {
                this.xml = new XMLWriterNSImpl(this.out);
                for (Map.Entry<String, String> ns : this.namespaces.entrySet()) {
                    this.xml.setPrefixMapping(ns.getValue(), ns.getKey());
                }
            }
            try {
                this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, lName, true);
                if (isFragment) {
                    this.xml.attribute(ID_ATTRIBUTE, this.newFragment);
                    if (this.fragType != null) {
                        this.xml.attribute(TYPE_ATTRIBUTE, this.fragType);
                    }
                }
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (isFragment && (ID_ATTRIBUTE.equals(atts.getLocalName(i)) || LABELS_ATTRIBUTE.equals(atts.getLocalName(i)) || this.fragType != null && TYPE_ATTRIBUTE.equals(atts.getLocalName(i)))) continue;
                    this.xml.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
        }
        if (PSMLContentUtils.isMediaFragmentElement((String)lName)) {
            ++this.inMediaFragment;
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        if (PSMLContentUtils.isMediaFragmentElement((String)lName)) {
            --this.inMediaFragment;
        }
        if (!(this.mediaFragmentStripped && this.inMediaFragment <= 0 || this.xml == null)) {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to close element " + lName, ex);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.xml != null) {
                this.xml.writeText(ch, start, length);
            } else {
                this.out.write(ch, start, length);
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    String getLoadedFragType() {
        return this.loadedFragType;
    }

    String getLoadedMediaType() {
        return this.loadedMediaType;
    }

    public boolean wasMediaFragmentStripped() {
        return this.mediaFragmentStripped;
    }
}

