/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.document.PropertiesFragmentHandler;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.url.URLFiles;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.DocumentTemplateHandler;
import com.pageseeder.psml.PSML;
import com.pageseeder.uri.URIErrorID;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

@Requires(group=true, uri=true, member=true, parameters={"fragment"})
public final class GetFragment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFragment.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Object content;
        Group group;
        Database db = req.getDatabase();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        URI uri = req.getURI();
        if (!URIRule.hasFragment((URI)uri, (Group)(group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri)), (String)fragment, (Database)db)) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setFragment(fragment);
        resolver.setFragmentInfo(true);
        resolver.setPSMLFormat(true);
        if (req.getParameter((Parameter)StandardParameters.transclude, false)) {
            UserDetails userdetails = new UserDetailsManager().get(db, req.getMember().getId(), false);
            resolver.setTransclude(userdetails);
            String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
            if (!Strings.isEmpty((String)publicationid)) {
                int position = (int)req.getParameter((Parameter)StandardParameters.position, 1L);
                Publication publication = Publications.findValidURIPublication((Database)db, (String)publicationid, (boolean)true, (URI)uri);
                if (publication != null) {
                    resolver.setPublication(publication, position, null, true);
                }
            } else if ("true".equals(req.getParameter((Parameter)StandardParameters.publication))) {
                resolver.setPublication(Publications.blank((URI)uri, (Group)group), 1, null, true);
            }
        }
        if (req.getParameter((Parameter)StandardParameters.includedraft, false)) {
            resolver.includeDraftContent(req.getMember().getId());
        }
        if ("true".equals(req.getParameter((Parameter)StandardParameters.newproperties))) {
            PropertiesFragmentHandler handler = new PropertiesFragmentHandler();
            try {
                XMLHelpers.parse((InputStream)resolver.getContent(db), (ContentHandler)handler);
            }
            catch (FoundationException ex) {
                if (resolver.getStatus() == URIFetcherStatus.NOT_FOUND) {
                    res.setError(GeneratorStatus.NOT_FOUND, ex.getMessage());
                    return;
                }
                LOGGER.error("Failed to parse fragment", (Throwable)ex);
                throw new IOException("Failed to parse fragment: " + ex.getMessage(), ex);
            }
            content = handler.getBeforeXML();
            if ("properties-fragment".equals(handler.getFragmentElement()) || "properties".equals(handler.getFragmentElement())) {
                File template;
                File file = uri.getExternal() != false ? URLFiles.findURLTemplate((String)URIRule.getStyleConfig((URI)uri)) : (template = URIRule.isPSML((URI)uri) ? PSMLFiles.findDocumentTemplate((String)group.getOwnerDirectory(), (String)URIRule.getStyleConfig((URI)uri)) : PSMLFiles.findExtensionMediaTemplate((String)group.getOwnerDirectory(), (String)PSML.getFileExtension(uri)));
                if (template != null) {
                    try {
                        DocumentTemplateHandler handler2 = new DocumentTemplateHandler(handler.getFragmentElement(), handler.getFragmentType(), handler.getPropertyNames(), false);
                        XMLHelpers.parse((InputStream)new FileInputStream(template), (ContentHandler)handler2);
                        content = (String)content + handler2.getPropertyXML();
                    }
                    catch (FoundationException ex) {
                        LOGGER.error("Failed to parse fragment", (Throwable)ex);
                        throw new IOException("Failed to parse fragment: " + ex.getMessage(), ex);
                    }
                }
            }
            content = (String)content + handler.getAfterXML();
        } else {
            try {
                content = IOUtils.toString((InputStream)resolver.getContent(db), (Charset)StandardCharsets.UTF_8);
            }
            catch (URIException ex) {
                if (resolver.getStatus() == URIFetcherStatus.NOT_FOUND) {
                    res.setError(GeneratorStatus.NOT_FOUND, ex.getMessage());
                } else {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                }
                return;
            }
        }
        content = content == null || ((String)content).isEmpty() ? "<document-fragment/>" : ((String)content).replaceAll("<\\?xml(.*?)>", "");
        if (!"default".equals(fragment) && !((String)content).contains("<locator")) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.writeXML((String)content);
    }
}

