/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.PSMLContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import com.pageseeder.xref.XRefMediator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(database=true, group=true, member=true, uri=true, parameters={"filename"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class DuplicateDocument
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateDocument.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!"psml".equals(URIRule.getStyleFormat((URI)req.getURI()))) {
            return new ForbiddenCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup(), req.getURI()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        URI turi;
        String[] groupnames;
        Database db = req.getDatabase();
        URI original = req.getURI();
        Group group = req.getGroup();
        Member member = req.getMember();
        String filename = req.getParameter((Parameter)StandardParameters.filename);
        String documentid = req.getParameter((Parameter)StandardParameters.docid);
        String title = req.getParameter((Parameter)StandardParameters.title);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String notify = req.getParameter((Parameter)StandardParameters.notify, "silent");
        String labels = req.getParameter((Parameter)StandardParameters.labels);
        String groups = req.getParameter((Parameter)StandardParameters.notification_groups, group.getName());
        Object message = req.getParameter((Parameter)StandardParameters.notification_content);
        String subject = req.getParameter((Parameter)StandardParameters.notification_subject);
        String msglabels = req.getParameter((Parameter)StandardParameters.notification_labels);
        String original_docid = req.getParameter((Parameter)StandardParameters.original_docid);
        boolean variation = req.getParameter((Parameter)StandardParameters.variation, true);
        if (!URIUtils.checkLabels(res, labels)) {
            return;
        }
        if (!filename.isEmpty() && filename.charAt(0) == '.') {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.ILLEGAL_FILENAME, "Filename cannot start with a dot '.'");
            return;
        }
        UserDetailsManager user_manager = new UserDetailsManager();
        UserDetails userdetails = user_manager.get(db, req.getAuthenticatedMember().getId());
        ArrayList<Group> notify_groups = new ArrayList<Group>();
        for (String groupname : groupnames = groups.split(",")) {
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)groupname);
            if (grp == null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Invalid group name: " + groupname);
                return;
            }
            if (!GroupRule.userHasAccess((Group)grp, (UserDetails)userdetails)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "You do not have access to group: " + groupname);
                return;
            }
            notify_groups.add(grp);
        }
        boolean original_updated = false;
        if (Strings.isEmpty((String)original.getDocID()) && !Strings.isEmpty((String)original_docid)) {
            URI turi2 = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)original.getHost().getName(), (String)original_docid);
            if (turi2 != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.DOCUMENT_ID_EXISTING, "The document id " + original_docid + " is already being used (" + turi2.getDecodedPath() + ").");
                return;
            }
            original.setDocID(original_docid);
            URIRule.addURIHistoryXLink((URI)original, (Member)member, (Database)db);
            original.setLastModified(new Date());
            original_updated = true;
        }
        Group editgroup = GroupRule.getEditGroup((Database)db, (Group)group, (URI)original);
        CreatedFile cfile = this.createPSMLFile(original, editgroup, filename, title == null ? filename : title, documentid, variation, db, member);
        if (cfile.status != GeneratorStatus.OK) {
            res.setError(cfile.status, cfile.message);
            return;
        }
        if (!Strings.isEmpty((String)cfile.documentid) && (turi = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)original.getHost().getName(), (String)cfile.documentid)) != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.DOCUMENT_ID_EXISTING, "The document id " + cfile.documentid + " is already being used (" + turi.getDecodedPath() + ").");
            return;
        }
        turi = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)original.getScheme(), (String)original.getHost().getName(), (Integer)original.getPort(), (String)cfile.path);
        if (turi != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EXISTING_URL, "The URI already exists.");
            return;
        }
        try {
            String[] labelsArray = Strings.isEmpty((String)labels) ? null : labels.split(",");
            turi = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabels((Database)db, null, (String)original.getScheme(), (String)original.getHost().getName(), (Integer)original.getPort(), (String)cfile.path, (String)cfile.behavior, (String)description, (String)cfile.title, (String)Medias.getMediaType((File)cfile.file), (String[])labelsArray, (boolean)true);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to create URI in DB", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create URI in DB: " + ex.getMessage());
        }
        if (turi == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "No group URI for path: " + cfile.path);
            return;
        }
        if (!Strings.isEmpty((String)cfile.documentid)) {
            if (!URIRule.isValidDocumentID((String)cfile.documentid)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.INVALID_DOCUMENT_ID);
                return;
            }
            turi.setDocID(cfile.documentid);
        }
        String[] msgLabelsArray = Strings.isEmpty((String)msglabels) ? null : msglabels.split(",");
        URIRule.addURIHistoryXLink((URI)turi, (Member)member, (Date)turi.getDateCreated(), null, (String)"creation", (String[])msgLabelsArray, null, null, (byte[])cfile.content, (Database)db);
        XRefMediator mediator = new XRefMediator(editgroup, turi, member, turi.getDateCreated(), db);
        mediator.setCreateEdit(true);
        mediator.setFailOnFirstError(false);
        mediator.setBuildStructure(true);
        try {
            mediator.mediateNewDocument(new ByteArrayInputStream(cfile.content));
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create XRefs", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create XRefs: " + ex.getMessage());
            return;
        }
        try {
            Structure.createStructureXLink(mediator.getStructureXML(), turi, editgroup, member, turi.getDateCreated(), "Document Create", db);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create structure in DB", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create structure in DB: " + ex.getMessage());
            return;
        }
        if (subject == null) {
            String string = subject = title == null || "".equals(title) ? "Document Created" : title;
        }
        if (message == null) {
            message = "A new document has been created";
        }
        message = description != null && description.length() > 0 ? (String)message + " with the following description:\n\n" + description : (String)message + ".";
        try {
            if ("normal".equals(notify) || "announce".equals(notify)) {
                for (Group grp : notify_groups) {
                    Emails.sendNewURI((Database)db, (Member)member, (String)subject, (String)message, (String)"File Creation", (String[])msgLabelsArray, Collections.singleton(turi), (Group)grp, (boolean)"announce".equals(notify), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to create notification", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create notification: " + ex.getMessage());
            return;
        }
        req.getTransaction().commitAndStart();
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch("Duplicating document " + turi.getDecodedPath());
        changes.startBatch(db, batch);
        changes.createURI(db, batch, turi, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)turi.getId()));
        PSML.indexXRefSourceTargetURIsWithBatch(db, turi, batch);
        if (original_updated) {
            changes.modifyURI(db, batch, original, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)original.getId()));
        }
        changes.completeBatch(db, batch);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("document-creation");
        if (cfile.originalFileName != null) {
            out.field("renamed", true);
            out.field("original-name", cfile.originalFileName);
        }
        out.writeURI(turi);
        out.endObject();
        out.flush();
    }

    private CreatedFile createPSMLFile(URI original, Group group, String userFilename, String title, String docid, boolean variation, Database db, Member mem) throws IOException {
        InputStream in;
        CreatedFile cf = new CreatedFile();
        cf.documentid = docid;
        cf.title = title;
        String dadURIPath = original.getPath().substring(0, original.getPath().lastIndexOf(47));
        String dadFilePath = URIRule.getRealPath((String)Settings.getContextPath(), (String)dadURIPath);
        Object filename = RuleUtils.replaceNonFilenameChars((String)userFilename);
        if (!((String)filename).endsWith(".psml")) {
            filename = (String)filename + ".psml";
        }
        cf.file = new File(dadFilePath, (String)filename);
        File dir = cf.file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return new CreatedFile("Failed to create parent directory: " + Files.path((File)new File(Settings.getDocumentPath()), (File)dir), GeneratorStatus.SERVER_ERROR);
        }
        if (!dir.isDirectory()) {
            return new CreatedFile("Parent is not a directory: " + Files.path((File)new File(Settings.getDocumentPath()), (File)dir), GeneratorStatus.SERVER_ERROR);
        }
        if (cf.file.exists()) {
            return new CreatedFile("The file " + cf.file.getName() + " already exists.", GeneratorStatus.BAD_REQUEST);
        }
        cf.path = dadURIPath + "/" + URLCoder.encode((String)filename);
        PSMLContentResolver resolver = new PSMLContentResolver(db, original, group.getName());
        try {
            in = resolver.getContent();
        }
        catch (URIException ex) {
            return new CreatedFile("Failed to load original content: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR);
        }
        DuplicatePSMLHandler handler = new DuplicatePSMLHandler(cf.path, variation ? original.getDocID() : null);
        try {
            XMLHelpers.parse((InputStream)in, (ContentHandler)handler);
        }
        catch (FoundationException ex) {
            return new CreatedFile("Failed to parse original XML to create content: " + ex.getMessage(), GeneratorStatus.SERVER_ERROR);
        }
        String contents = handler.getContent();
        cf.content = contents.getBytes(StandardCharsets.UTF_8);
        String doctype = handler.getDocumentType() == null || "default".equals(handler.getDocumentType()) ? "" : handler.getDocumentType();
        cf.behavior = "psml-" + doctype + "-";
        return cf;
    }

    private static final class DuplicatePSMLHandler
    extends DefaultHandler {
        private final String internalPath;
        private final @Nullable String originalDocID;
        private String uriid = null;
        private String documentType = null;
        private XMLWriter output = new XMLStringWriter(XML.NamespaceAware.Yes, false);
        private boolean ignore = false;
        private boolean firstSection = false;
        private boolean docIDHandled = false;
        private boolean inMetadataFragment = false;

        public DuplicatePSMLHandler(String path, String docid) {
            this.internalPath = path;
            this.originalDocID = docid;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.output.setPrefixMapping(uri, prefix);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("document".equals(localName)) {
                this.uriid = atts.getValue("id");
                this.documentType = atts.getValue("type");
            } else if ("documentinfo".equals(localName) || "notes".equals(localName) || "compare".equals(localName)) {
                this.ignore = true;
            } else if ("metadata".equals(localName)) {
                this.inMetadataFragment = true;
            } else if ("section".equals(localName)) {
                if (this.firstSection && !this.docIDHandled && this.originalDocID != null) {
                    try {
                        this.output.openElement("metadata");
                        this.output.openElement("properties");
                        this.output.openElement("property");
                        this.output.attribute("name", "original-docid");
                        this.output.attribute("title", "Document ID of original");
                        this.output.attribute("value", this.originalDocID);
                        this.output.closeElement();
                        this.output.closeElement();
                        this.output.closeElement();
                    }
                    catch (IOException ex) {
                        throw new SAXException("Failed to create metadata fragment", ex);
                    }
                }
                this.firstSection = false;
            }
            if (!this.ignore) {
                boolean isLocator = "locator".equals(localName);
                boolean isXRef = "xref".equals(localName) || "blockxref".equals(localName);
                boolean isInternalXRef = isXRef && this.uriid.equals(atts.getValue("uriid"));
                try {
                    this.output.openElement(Strings.isEmpty((String)uri) ? null : uri, localName, false);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String name = atts.getLocalName(i);
                        boolean ignoreAttribute = false;
                        if (isXRef) {
                            if ("id".equals(name)) {
                                ignoreAttribute = true;
                            } else if (isInternalXRef && "href".equals(name)) {
                                this.output.attribute(name, this.internalPath);
                                ignoreAttribute = true;
                            } else if (isInternalXRef) {
                                ignoreAttribute = "uriid".equals(name) || "docid".equals(name);
                            }
                        } else {
                            boolean bl = ignoreAttribute = isLocator && !"fragment".equals(name) && !"modified".equals(name) || "document".equals(localName) && "id".equals(name);
                        }
                        if (!ignoreAttribute) {
                            this.output.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                        }
                        if (!this.inMetadataFragment || !"property".equals(localName) || !"original-docid".equals(atts.getValue("name"))) continue;
                        this.docIDHandled = true;
                    }
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to open element " + localName, ex);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (("metadata".equals(localName) || "properties".equals(localName)) && this.inMetadataFragment && !this.docIDHandled && this.originalDocID != null) {
                try {
                    if ("metadata".equals(localName)) {
                        this.output.openElement("properties");
                    }
                    this.output.openElement("property");
                    this.output.attribute("name", "original-docid");
                    this.output.attribute("title", "Document ID of original");
                    this.output.attribute("value", this.originalDocID);
                    this.output.closeElement();
                    if ("metadata".equals(localName)) {
                        this.output.closeElement();
                    }
                    this.docIDHandled = true;
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to create original-docid property", ex);
                }
            }
            if (!this.ignore) {
                try {
                    this.output.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close element " + localName, ex);
                }
            }
            if ("documentinfo".equals(localName) || "notes".equals(localName) || "compare".equals(localName)) {
                this.ignore = false;
            } else if ("metadata".equals(localName)) {
                this.inMetadataFragment = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.ignore) {
                try {
                    this.output.writeText(ch, start, length);
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write content", ex);
                }
            }
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public String getContent() {
            return this.output.toString();
        }
    }

    private static final class CreatedFile {
        private String path = null;
        private String behavior = null;
        private String title = null;
        private String documentid = null;
        private byte[] content = null;
        private File file = null;
        private String originalFileName = null;
        private String message = null;
        private GeneratorStatus status = GeneratorStatus.OK;

        public CreatedFile() {
        }

        public CreatedFile(String err, GeneratorStatus s) {
            this.message = err;
            this.status = s;
        }
    }
}

