/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.UnsubscribeToken;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.DeleteFailedException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.group.Groups;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.membership.Memberships;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

@Requires(database=true, parameters={"token"})
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class Unsubscribe
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group;
        Database db = req.getDatabase();
        try {
            group = Groups.getGroup(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load group from DB");
            return;
        }
        if (group == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
            return;
        }
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        Notification notification = Notification.forType((String)req.getParameter((Parameter)StandardParameters.notification));
        boolean deregister = req.getParameter((Parameter)StandardParameters.deregister, false);
        assert (tokenString != null);
        UnsubscribeToken token = UnsubscribeToken.parse((String)tokenString, (Long)group.getId());
        if (token == null) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)"Invalid unsubscribe token for group {}", (Object[])new Object[]{group.getName()});
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID, "Token is invalid");
            return;
        }
        if (token.hasExpired()) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)"Expired unsubscribe token for group {} and email {}", (Object[])new Object[]{group.getName(), token.email()});
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_EXPIRED, "Token has expired");
            return;
        }
        String email = token.email();
        Member mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
        if (mem == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.INVALID_EMAIL);
            return;
        }
        List<Membership> memberships = this.getMemberships(db, group, mem);
        if (notification != null || deregister) {
            for (Membership membership : memberships) {
                Group g = membership.getGroup();
                Unsubscribe.updateMembership(db, g, mem, notification, deregister);
            }
            req.getTransaction().commit();
            for (Membership membership : memberships) {
                MemberForGroup mfg;
                Long mfgid = membership.getMemberForGroupID();
                if (mfgid == null || (mfg = DatabaseQuery.getMemberForGroupById((Database)db, (Long)mfgid)) == null) continue;
                ChangesManager.getInstance().modifyMembership(db, mfg);
            }
            memberships = this.getMemberships(db, group, mem);
        }
        if (deregister) {
            UserDetailsManager userManager = new UserDetailsManager();
            userManager.remove(mem.getId());
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("unsubscribe");
        out.field("email", email);
        out.startCollection("memberships", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Membership membership : memberships) {
            out.writeMembership(membership, UniversalPrinter.MembershipFormatOption.GROUP_ONLY, null, MemberDetailsConfig.Visibility.MEMBER, db);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    public List<Membership> getMemberships(Database db, Group group, Member member) throws QueryFailedException {
        ArrayList<Membership> memberships = new ArrayList<Membership>();
        Membership membership = MemberForGroupRule.getMembership((Group)group, (Member)member, (boolean)true, (boolean)false, (Database)db);
        if (membership != null) {
            memberships.add(membership);
            Collection subgroups = membership.getSubgroups();
            for (GroupForGroup subgroup : subgroups) {
                Group sg = subgroup.getMemberGroup();
                Membership subMembership = MemberForGroupRule.getMembership((Group)sg, (Member)member, (boolean)false, (boolean)false, (Database)db);
                if (subMembership == null) continue;
                memberships.add(subMembership);
            }
        }
        return memberships;
    }

    private static void updateMembership(Database db, Group group, Member mem, @Nullable Notification notification, boolean deregister) throws DeleteFailedException {
        MemberForGroup mfg = Memberships.getMemberForGroup(mem, group);
        if (mfg != null) {
            if (deregister) {
                if (mfg.getModerator() != null) {
                    Memberships.removeAsModerator(mfg, db);
                }
                mfg.setEditor(Boolean.FALSE);
                mfg.setEditorFlags("d");
            } else if (notification != null) {
                mfg.setNotification(notification.type());
            }
        }
    }
}

