/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.membership.Memberships;
import java.io.IOException;
import java.util.Date;
import java.util.List;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class CreateMembership
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group != null && "admin".equals(group.getName())) {
            return new AdminSystemCheck();
        }
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Notification notify;
        Role psrole;
        long nbMembers;
        String maxMembers;
        String firstName = req.getParameter((Parameter)StandardParameters.firstname, "Member");
        String timestamp = Long.toString(new Date().getTime());
        String surname = req.getParameter((Parameter)StandardParameters.surname, timestamp.substring(timestamp.length() - 4));
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        String username = req.getParameter((Parameter)StandardParameters.member_username, "");
        String notification = req.getParameter((Parameter)StandardParameters.notification);
        String role = req.getParameter((Parameter)StandardParameters.role);
        boolean listed = req.getParameter((Parameter)StandardParameters.listed, false);
        boolean sendNewMemberNotification = req.getParameter((Parameter)StandardParameters.welcome_email, true);
        boolean createPersonalGroup = req.getParameter((Parameter)StandardParameters.personal_group, false);
        boolean autoActivate = req.getParameter((Parameter)StandardParameters.auto_activate, false);
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null);
        boolean admin = "admin".equals(group.getName());
        if (!Members.checkNames(firstName, surname, res)) {
            return;
        }
        if (!Members.checkEmailUsername(email, username, null, admin, req.getDatabase(), res)) {
            return;
        }
        if (username.isEmpty()) {
            username = email;
        }
        if (password != null && !Members.checkPassword(password, admin, res)) {
            return;
        }
        if (username.equals(password)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_CREDENTIALS);
            return;
        }
        if (GroupRule.isPersonalGroup((String)group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_IN_PERSONAL_GROUP);
            return;
        }
        Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
        if (mem == null && !email.isEmpty()) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
        }
        if (mem != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS);
            return;
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        if (!"unlimited".equals(maxMembers = GlobalSettings.getString((String)"members", (String)"unlimited")) && (nbMembers = DatabaseQuery.getNumberMembers((Database)db).longValue()) >= (long)Integer.parseInt(maxMembers)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MORE_MEMBERS);
            return;
        }
        Object memflags = "";
        if (password == null) {
            password = "admin".equals(group.getName()) ? RuleUtils.generatePassword((int)12) : RuleUtils.generatePassword();
            memflags = (String)memflags + "p";
        }
        if ((psrole = Role.forAttribute((String)role)) == null) {
            psrole = Role.forTitle((String)role);
        }
        if (role == null) {
            psrole = group.hasFlag('t') ? Role.CONTRIBUTOR : Role.REVIEWER;
        } else if (psrole == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.ILLEGAL_ROLE);
            return;
        }
        mem = Member.create((Database)db);
        Date now = new Date();
        mem.setCreated(now);
        mem.setFirstName(firstName);
        mem.setSurname(surname);
        mem.setEmail(email);
        mem.setUsername(username);
        try {
            mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
        }
        catch (FoundationException e) {
            throw new GeneratorException((Throwable)e);
        }
        if (!autoActivate) {
            memflags = (String)memflags + "u";
        } else {
            mem.setActivated(now);
        }
        mem.setSubmitPref((String)memflags);
        mem = mem.insert(db);
        if (createPersonalGroup) {
            Group members = GroupRule.getMemberProject((Database)db);
            GroupRule.createMemberPersonalGroup((Database)db, (Member)mem, (Group)GroupRule.createMemberPersonalProject((Database)db, (Member)mem, (Group)members), null);
        }
        if ((notify = Notification.forType((String)notification)) == null) {
            String flags = group.getFlags();
            notify = Notification.forFlags((String)flags);
        }
        MemberForGroup mfg = MemberForGroup.create((Database)db);
        mfg.setNotification(notify.type());
        mfg.setListed(Boolean.valueOf(listed));
        mfg.setMember(mem);
        String editorFlags = psrole.getFlags();
        if (editorFlags != null) {
            mfg.setEditorFlags(editorFlags);
        }
        mfg.setEditor(Boolean.valueOf(psrole.isEditor()));
        if (psrole == Role.MODERATOR || psrole == Role.MODERATOR_AND_APPROVER) {
            MemberForGroup moderator = Memberships.findModerator(group, db);
            if (moderator != null && !moderator.getId().equals(mfg.getId())) {
                Memberships.removeAsModerator(moderator, db);
            }
            if (mfg.getModerator() == null) {
                Memberships.setAsModerator(mfg, db);
            }
        }
        group.addMembersForGroup(mfg);
        if (config != null) {
            List fields = MemberGroupDetailsRule.toFieldValues((GeneratorRequest)req);
            MemberGroupDetails mgd = MemberGroupDetailsRule.updateDetails((Database)db, (Member)mem, (List)fields, (Group)group, (MemberForGroup)mfg, (boolean)true);
            mfg.setMemberGroupDetails(mgd);
        }
        boolean acceptInvitationRequired = GroupRule.acceptInvitationRequired((Database)db, (Group)group);
        if (req.getParameter((Parameter)StandardParameters.invitation) != null) {
            acceptInvitationRequired = req.getParameter((Parameter)StandardParameters.invitation, acceptInvitationRequired);
        }
        if (acceptInvitationRequired) {
            mfg.setEditorFlags(Flags.add((String)Flags.add((String)mfg.getEditorFlags(), (char)'d'), (char)'n'));
        }
        mfg.insert(db);
        boolean welcomeEmailFailed = false;
        if (sendNewMemberNotification) {
            try {
                Member creator = req.getAuthenticatedMember();
                Emails.sendNewMembershipMember((Database)db, (MemberForGroup)mfg, (Member)creator, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            }
            catch (EmailException ex) {
                welcomeEmailFailed = true;
                req.getLogger((Object)this).error("Failed to send new member email", (Throwable)ex);
            }
        }
        req.getTransaction().commit();
        ChangesManager.getInstance().createMember(db, mem);
        ChangesManager.getInstance().createMembership(db, mfg);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-creation");
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MANAGER, db);
        out.endObject();
        out.flush();
    }
}

