/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.Date;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class Register
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (GlobalSettings.getString((String)"publicEnable", (String)"").contains("self-register")) {
            return new NoCheck();
        }
        return new ForbiddenCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        long nbMembers;
        String first_name = req.getParameter((Parameter)StandardParameters.firstname, "");
        String surname = req.getParameter((Parameter)StandardParameters.surname, "");
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String password = req.getParameter((Parameter)StandardParameters.member_password, "");
        String username = req.getParameter((Parameter)StandardParameters.member_username, "");
        Database db = req.getDatabase();
        if (first_name.isEmpty() || surname.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.FIRSTNAME_SURNAME_REQUIRED);
            return;
        }
        if (!Members.checkNames(first_name, surname, res)) {
            return;
        }
        if (email.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.EMAIL_REQUIRED);
            return;
        }
        if (!Members.checkEmailUsername(email, username, null, false, req.getDatabase(), res)) {
            return;
        }
        if (username.isEmpty()) {
            username = email;
        }
        if (password.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.PASSWORD_REQUIRED);
            return;
        }
        if (!Members.checkPassword(password, false, res)) {
            return;
        }
        if (username.equals(password)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_CREDENTIALS);
            return;
        }
        Member mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
        if (mem == null && !"No Email".equals(email)) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
        }
        if (mem != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS);
            return;
        }
        String max_mem = GlobalSettings.getString((String)"members", (String)"unlimited");
        if (!"unlimited".equals(max_mem) && (nbMembers = DatabaseQuery.getNumberMembers((Database)db).longValue()) >= (long)Integer.parseInt(max_mem)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MORE_MEMBERS);
            return;
        }
        mem = Member.create((Database)db);
        mem.setCreated(new Date());
        mem.setFirstName(first_name);
        mem.setSurname(surname);
        mem.setEmail(email);
        mem.setUsername(username);
        try {
            mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
        }
        catch (FoundationException e) {
            throw new GeneratorException((Throwable)e);
        }
        mem.setSubmitPref("u");
        mem = mem.insert(db);
        boolean welcomeEmailFailed = false;
        try {
            Emails.sendNewMember((Database)db, (Member)mem, (Group)req.getGroup(), null, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
        }
        catch (EmailException ex) {
            welcomeEmailFailed = true;
            req.getLogger((Object)this).error("Failed to write new member email", (Throwable)ex);
        }
        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Registered new member {} ({})", (Object[])new Object[]{mem.getUsername(), mem.getId()});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-creation");
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMember(mem, true);
        out.endObject();
        out.flush();
    }
}

