/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.util.Images;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.DeleteFailedException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.display.CustomImage;
import com.pageseeder.display.DefaultProfilePicture;
import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProfilePictureServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePictureServlet.class);
    private static final long serialVersionUID = 20251111L;
    private static final String CACHE_NAME = "profile-pictures";
    private static final String SERVER_TIMING_HEADER = "Server-Timing";
    private static final SafeCacheWrapper<Long, WebImage> CACHE = SafeCacheWrapper.getInstance((String)"profile-pictures");

    public String getServletInfo() {
        return "Handles member profile picture.";
    }

    public static void clearCache() {
        try {
            CACHE.removeAll();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to clear whole cache", (Throwable)ex);
        }
    }

    public static void clearCache(Long memberId) {
        try {
            CACHE.remove((Serializable)memberId);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to clear cache for member {}", (Object)memberId, (Object)ex);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        wr.ensureUtf8Request();
        Long memberId = wr.getLongParameter(StandardParameters.member_id.getName(), false, Long.valueOf(-1L));
        assert (memberId != null);
        try {
            if (memberId == -1L) {
                String name = wr.getParameter(StandardParameters.name.getName());
                DefaultProfilePicture image = DefaultProfilePicture.forName(name);
                res.setStatus(200);
                image.write(res);
                return;
            }
            long start = System.currentTimeMillis();
            WebImage image = ProfilePictureServlet.getQuietly(memberId);
            if (image != null && !"no-cache".equals(req.getHeader("Cache-Control"))) {
                res.setHeader(SERVER_TIMING_HEADER, "cache;desc=hit;dur=" + (System.currentTimeMillis() - start));
                image.write(req, res);
                return;
            }
            this.writePictureForMember(req, res, wr, memberId, start);
        }
        catch (IOException ex) {
            wr.sendError(500, "Unable to write image");
        }
    }

    private void writePictureForMember(HttpServletRequest req, HttpServletResponse res, WebRequest wr, Long memberId, long start) throws IOException {
        try (Database db = wr.getDatabase();){
            if (db == null) {
                return;
            }
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            if (member == null) {
                DefaultProfilePicture image = DefaultProfilePicture.forMemberId(memberId);
                res.setStatus(200);
                res.setHeader(SERVER_TIMING_HEADER, "cache;desc=miss,db;dur=" + (System.currentTimeMillis() - start));
                image.write(res);
                return;
            }
            WebImage image = this.fetchImage(member, db);
            if (image == null) {
                image = DefaultProfilePicture.forMember(member);
            }
            CACHE.put((Serializable)member.getId(), (Serializable)image);
            res.setStatus(200);
            res.setHeader(SERVER_TIMING_HEADER, "cache;desc=miss,db;dur=" + (System.currentTimeMillis() - start));
            image.write(req, res);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Unable to query DB for data member XLink", (Throwable)ex);
            DefaultProfilePicture image = DefaultProfilePicture.forName("E");
            res.setStatus(502);
            image.write(res);
        }
    }

    private @Nullable CustomImage fetchImage(Member member, Database db) throws QueryFailedException, DeleteFailedException {
        XLink memberData;
        List memberDataList = DatabaseQuery.getXLinkMemberDataByTypeList((Database)db, (Long)member.getId(), (String)"public-picture");
        XLink xLink = memberData = !memberDataList.isEmpty() ? (XLink)memberDataList.get(0) : null;
        if (memberDataList.size() > 1) {
            for (int i = 1; i < memberDataList.size(); ++i) {
                XLink xl = (XLink)memberDataList.get(i);
                for (Content c : xl.getContentsCol()) {
                    c.delete(db);
                }
                xl.delete(db);
            }
        }
        if (memberData == null) {
            return null;
        }
        Collection contents = memberData.getContentsCol();
        if (contents.isEmpty()) {
            return null;
        }
        Content content = (Content)contents.iterator().next();
        String mediatype = content.getType();
        byte[] data = content.getBinaryData();
        if (data != null) {
            if (mediatype == null) {
                mediatype = Images.guessImageMimeType((byte[])data);
            }
            if (mediatype == null) {
                LOGGER.warn("Unable to determine media type for profile picture of member {}", (Object)member.getId());
                return null;
            }
            long lastModified = ProfilePictureServlet.lastModified(memberData);
            return new CustomImage(data, mediatype, lastModified);
        }
        return null;
    }

    private static long lastModified(XLink memberData) {
        Date date = memberData.getModifiedDate();
        if (date == null) {
            date = memberData.getDate();
        }
        return date.getTime() / 1000L * 1000L;
    }

    private static @Nullable WebImage getQuietly(Long memberId) {
        try {
            return (WebImage)CACHE.get((Serializable)memberId);
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to retrieve image from cache for member {}", (Object)memberId, (Object)ex);
            return null;
        }
    }
}

