/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI(value=PublicAPI.Support.EXPERIMENTAL)
public final class ListMemberData
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        try {
            Member member = Members.getMember(req);
            return new ViewMemberCheck(member);
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Member member = Members.getMember(req);
        if (member == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        Database db = req.getDatabase();
        List xlinks = DatabaseQuery.getXLinkMemberDataList((Database)db, (Long)member.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startCollection("memberdatalist");
        for (XLink xlink : xlinks) {
            out.writeMemberData(xlink);
        }
        out.endCollection();
        out.flush();
    }
}

