/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.ArrayList;

@Requires(database=true, parameters={"data"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class ImportMembers
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        String data = req.getParameter((Parameter)StandardParameters.data);
        boolean createPersonal = req.getParameter((Parameter)StandardParameters.createpersonal, false);
        assert (data != null);
        ArrayList<Members.MemberDetails> created = new ArrayList<Members.MemberDetails>();
        ArrayList<Members.MemberDetails> existing = new ArrayList<Members.MemberDetails>();
        ArrayList<Members.MemberDetails> failed = new ArrayList<Members.MemberDetails>();
        try {
            Members.importMembers(db, tr, data, createPersonal, null, null, null, false, created, existing, failed);
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.OTHER, (String)"Imported members: {} created, {} existing, {} failed", (Object[])new Object[]{created.size(), existing.size(), failed.size()});
        }
        catch (Exception ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("members-import");
        out.startCollection("imports", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Members.MemberDetails md : created) {
            md.toUniversal(out, "created");
        }
        for (Members.MemberDetails md : existing) {
            md.toUniversal(out, "existing");
        }
        for (Members.MemberDetails md : failed) {
            md.toUniversal(out, "error");
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

