/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.edits;

import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.util.Medias;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.Nullable;

public final class BackupFileURIFetcher
implements URIFetcher {
    private final URIFetcherStatus status;
    private @Nullable String statusMessage = null;
    private final File uriFile;
    private @Nullable InputStream uriIS = null;

    public BackupFileURIFetcher(File toLoad) {
        this.uriFile = toLoad;
        if (!this.uriFile.exists() || !this.uriFile.isFile()) {
            this.status = URIFetcherStatus.NOT_FOUND;
            this.statusMessage = "The path " + this.uriFile.getAbsolutePath() + " could not be found on this web server";
            return;
        }
        this.status = URIFetcherStatus.SUCCESS;
    }

    public void close() throws IOException {
        if (this.uriIS != null) {
            this.uriIS.close();
        }
    }

    public boolean getCachedAccess() {
        return false;
    }

    public InputStream getContent() throws FileNotFoundException {
        if (this.uriIS == null) {
            this.uriIS = new FileInputStream(this.uriFile);
        }
        return this.uriIS;
    }

    public File getFile() {
        return this.uriFile;
    }

    public long getContentLength() {
        return this.uriFile.length();
    }

    public String getContentType() {
        String filename = this.uriFile.getName();
        if (filename.endsWith(".bak")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        String ext = "";
        int i = filename.lastIndexOf(46);
        if (i != -1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        return Medias.getMediaType((String)ext);
    }

    public long getLastModified() {
        return this.uriFile.lastModified();
    }

    public URIFetcherStatus getStatus() {
        return this.status;
    }

    public @Nullable String getStatusMessage() {
        return this.statusMessage;
    }

    public @Nullable String getURIString() {
        return null;
    }
}

