/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.xml.Schematron;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.schematron.SchematronException;
import org.pageseeder.schematron.SchematronResult;
import org.pageseeder.schematron.Validator;
import org.pageseeder.schematron.svrl.SVRL;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.SAXException;

public final class ValidatePSML
implements LoadingThreadAction {
    public static final String VALIDATION_FAILED = "com.pageseeder.load.validation_failed";
    private final LoadingThread parent;
    private @Nullable TemplateFiles resources = null;
    private int total = 0;
    private int alreadyDone = 0;
    private boolean cancelled = false;
    private boolean errorsAreWarnings = false;
    private final Map<String, Validator> validators = new HashMap<String, Validator>();

    ValidatePSML(LoadingThread dad) {
        this.parent = dad;
    }

    @Override
    public String name() {
        return "Validate";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.alreadyDone);
        out.field("total", (long)this.total);
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void setErrorsAsWarnings(boolean warnings) {
        this.errorsAreWarnings = warnings;
    }

    public void run(@Nullable Collection<IncomingFile> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        this.total = files.size();
        if (this.resources == null) {
            Template kit = new Template(this.parent.getGroupOwner() == null ? "default" : this.parent.getGroupOwner());
            this.resources = new TemplateFiles(kit);
        }
        boolean error = false;
        boolean onlyOne = files.size() == 1;
        for (IncomingFile file : files) {
            ++this.alreadyDone;
            if (!"xml".equalsIgnoreCase(file.getExtension()) && !"psml".equalsIgnoreCase(file.getExtension())) continue;
            boolean success = this.validate(file, onlyOne);
            if (!error) {
                boolean bl = error = !success;
            }
            if (!this.cancelled) continue;
            return;
        }
        if (!onlyOne && error && !this.errorsAreWarnings) {
            this.parent.fail("Validation failed, see process logs for more details");
        }
    }

    private boolean validate(IncomingFile toValidate, boolean failIfError) {
        if (this.cancelled) {
            return true;
        }
        boolean validated = false;
        if (toValidate.getPath().toLowerCase().endsWith(".psml")) {
            String level = toValidate.getAttribute("level");
            if (toValidate.isMetadataPSML() && !"metadata".equals(level)) {
                if (failIfError && !this.errorsAreWarnings) {
                    this.parent.fail("Only PSML files with level \"metadata\" are allowed in the META-INF folder, " + toValidate.getPath() + " has level \"" + level + "\"");
                } else {
                    this.parent.updateStatus(this.errorsAreWarnings ? ProcessStage.Status.WARNING : ProcessStage.Status.ERROR, "Only PSML files with level \"metadata\" are allowed in the META-INF folder, " + toValidate.getPath() + " has level \"" + level + "\"");
                }
                return false;
            }
            if (!toValidate.isMetadataPSML() && !"portable".equals(level)) {
                if (failIfError && !this.errorsAreWarnings) {
                    this.parent.fail("Only PSML files with level \"portable\" are allowed, " + toValidate.getPath() + " has level \"" + level + "\"");
                } else {
                    this.parent.updateStatus(this.errorsAreWarnings ? ProcessStage.Status.WARNING : ProcessStage.Status.ERROR, "Only PSML files with level \"portable\" are allowed, " + toValidate.getPath() + " has level \"" + level + "\"");
                }
                return false;
            }
            ValidationResult result = this.validateWithSchema("psml-portable", toValidate);
            if (result.hasErrors()) {
                Collection<String> errors = result.errors();
                assert (errors != null);
                for (String e : errors) {
                    this.parent.updateStatus(this.errorsAreWarnings ? ProcessStage.Status.WARNING : ProcessStage.Status.ERROR, "Schema error found for " + toValidate.getPath() + ": " + e);
                }
                if (failIfError && !this.errorsAreWarnings) {
                    this.parent.fail("File " + toValidate.getPath() + " is invalid (" + errors.size() + (errors.size() == 1 ? " schema error" : " schema errors") + " found)");
                }
                if (toValidate.isMetadataPSML()) {
                    toValidate.setAttribute(VALIDATION_FAILED, "true");
                }
                return false;
            }
            validated = result.isValidated();
            if (this.cancelled) {
                return true;
            }
            result = this.validateWithSchematron("psml-portable", toValidate);
            if (result.hasErrors()) {
                Collection<String> errors = result.errors();
                assert (errors != null);
                for (String e : errors) {
                    this.parent.updateStatus(this.errorsAreWarnings ? ProcessStage.Status.WARNING : ProcessStage.Status.ERROR, "Schematron error found for " + toValidate.getPath() + ": " + e);
                }
                if (failIfError && !this.errorsAreWarnings) {
                    this.parent.fail("File " + toValidate.getPath() + " is invalid (" + errors.size() + (errors.size() == 1 ? " schematron error" : " schematron errors") + " found)");
                }
                if (toValidate.isMetadataPSML()) {
                    toValidate.setAttribute(VALIDATION_FAILED, "true");
                }
                return false;
            }
            boolean bl = validated = validated || result.isValidated();
            if (this.cancelled) {
                return true;
            }
        }
        if (!validated) {
            ValidationResult result = this.validateWellFormed(toValidate);
            if (result.hasErrors()) {
                Collection<String> errors = result.errors();
                assert (errors != null);
                for (String e : errors) {
                    this.parent.updateStatus(this.errorsAreWarnings ? ProcessStage.Status.WARNING : ProcessStage.Status.ERROR, "Error found for " + toValidate.getPath() + ": " + e);
                }
                if (failIfError && !this.errorsAreWarnings) {
                    this.parent.fail("File " + toValidate.getPath() + " is invalid (" + errors.size() + (errors.size() == 1 ? " error" : " errors") + " found)");
                }
                if (toValidate.isMetadataPSML()) {
                    toValidate.setAttribute(VALIDATION_FAILED, "true");
                }
                return false;
            }
            validated = result.isValidated();
        }
        if (validated) {
            this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "File " + toValidate.getFile().getName() + " is valid.");
        } else {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "File " + toValidate.getFile().getName() + " was not validated because no schema could be found.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateWithSchema(String schemaName, IncomingFile original) {
        String schemaPath = "ps://com/pageseeder/load/" + schemaName + ".xsd";
        FileInputStream reader = null;
        String error = null;
        try {
            reader = new FileInputStream(original.getFile());
            ValidationResult validationResult = new ValidationResult(true, XMLHelpers.validateXmlFileWithSchemaReturnErrors((InputStream)reader, (String)schemaPath, null));
            return validationResult;
        }
        catch (SAXException ex) {
            error = "Error when validating file: " + ex.getMessage();
        }
        catch (IOException ex) {
            error = "Error when reading file: " + ex.getMessage();
        }
        finally {
            block17: {
                try {
                    if (reader != null) {
                        ((InputStream)reader).close();
                    }
                }
                catch (IOException ex) {
                    if (error != null) break block17;
                    error = "Error when closing stream of file: " + ex.getMessage();
                }
            }
        }
        return new ValidationResult(false, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateWithSchematron(String schematronName, IncomingFile original) {
        String error = null;
        InputStream reader = null;
        InputStream schematronStream = null;
        try {
            String key = "/com/pageseeder/load/" + schematronName + ".sch";
            schematronStream = ValidatePSML.class.getResourceAsStream(key);
            Validator validator = this.loadSchematronValidator(key, schematronStream);
            if (validator == null) {
                ValidationResult validationResult = new ValidationResult(false, "Schematron validator cannot be created");
                return validationResult;
            }
            reader = new FileInputStream(original.getFile());
            Map<String, Integer> parameters = Collections.singletonMap("max-xrefs", GlobalSettings.getInt((String)"maxForwardXRefs", (int)3000));
            SchematronResult result = validator.validate((Source)new StreamSource(reader), parameters);
            List errors = SVRL.toMessageList((List)result.toSchematronOutput().getFailedAsserts());
            ValidationResult validationResult = new ValidationResult(true, errors);
            return validationResult;
        }
        catch (SchematronException ex) {
            error = "Error when validating file:, " + ex.getMessage();
        }
        catch (IOException ex) {
            error = "Error when reading file: " + ex.getMessage();
        }
        finally {
            block33: {
                block32: {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        if (error != null) break block32;
                        error = "Error when closing stream of file: " + ex.getMessage();
                    }
                }
                try {
                    if (schematronStream != null) {
                        schematronStream.close();
                    }
                }
                catch (IOException ex) {
                    if (error != null) break block33;
                    error = "Error when closing stream of schematron: " + ex.getMessage();
                }
            }
        }
        return new ValidationResult(false, error);
    }

    private @Nullable Validator loadSchematronValidator(String key, InputStream schema) {
        Validator validator = this.validators.get(key);
        if (validator == null) {
            try {
                validator = Schematron.newValidator((Source)new StreamSource(schema));
            }
            catch (SchematronException ex) {
                this.parent.updateStatus(ProcessStage.Status.ERROR, "Failed to load schematron schema " + key + ": " + ex.getMessage());
                return null;
            }
            this.validators.put(key, validator);
        }
        return validator;
    }

    private ValidationResult validateWellFormed(IncomingFile original) {
        ValidationResult validationResult;
        FileInputStream reader = new FileInputStream(original.getFile());
        try {
            validationResult = new ValidationResult(true, XMLHelpers.validateWellFormednessReturnErrors((InputStream)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException ex) {
                return new ValidationResult(false, "Error when validating file: " + ex.getMessage());
            }
        }
        ((InputStream)reader).close();
        return validationResult;
    }

    private static final class ValidationResult {
        private final boolean validated;
        private final @Nullable Collection<String> errors;

        ValidationResult(boolean validated, Collection<String> errors) {
            this.validated = validated;
            this.errors = errors;
        }

        ValidationResult(boolean validated, @Nullable String errors) {
            this.validated = validated;
            this.errors = errors == null || errors.isEmpty() ? null : Collections.singleton(errors);
        }

        boolean isValidated() {
            return this.validated;
        }

        @Nullable Collection<String> errors() {
            return this.errors;
        }

        boolean hasErrors() {
            return this.errors != null && !this.errors.isEmpty();
        }
    }
}

