/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.utils.PatternResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class LoadingZone {
    private static final String VALID_UPLOAD_ID = "[a-zA-Z0-9-]+";
    private static final int MAX_TOTAL_FILES = 1000;
    private static final int MAX_FILES_PER_FOLDER = 100;
    private static final int MAX_INDIVIDUAL_FILES = 20;
    public static final String ALL_MEDIATYPE = "all";
    private final File root;
    private final String groupName;
    private final String groupTemplate;
    private final @Nullable String uploadid;
    private final Long memberID;
    private int maxIndividualFiles = 20;
    private final Map<String, List<String>> mediaTypes = new HashMap<String, List<String>>();
    private final Map<String, IncomingFile> files = new HashMap<String, IncomingFile>();
    private final Map<String, IncomingFile> metadatafiles = new HashMap<String, IncomingFile>();

    public LoadingZone(String groupname, String grouptemplate, Long memberid, String uploadid) {
        this.groupName = groupname;
        this.groupTemplate = grouptemplate;
        File documentsPath = new File(Settings.getDocumentPath());
        this.memberID = memberid;
        String path = groupname.replace('-', '/') + File.separator + ".upload" + File.separator + memberid;
        this.uploadid = uploadid;
        if (this.uploadid != null) {
            path = path + "." + this.uploadid;
        }
        this.root = new File(documentsPath, path);
        this.root.mkdirs();
    }

    public void setMaxIndividualFiles(int max) {
        this.maxIndividualFiles = max;
    }

    public File baseDirectory() {
        return this.root;
    }

    public @Nullable String uploadID() {
        return this.uploadid;
    }

    public String groupTemplate() {
        return this.groupTemplate;
    }

    public String groupName() {
        return this.groupName;
    }

    public IncomingFile newFile(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        if (this.files.containsKey(path)) {
            return this.files.get(path);
        }
        String newpath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)path);
        IncomingFile inc = new IncomingFile(new File(this.root, newpath), path, this);
        this.addIncomingFile(inc, false);
        return inc;
    }

    public IncomingFile existingFile(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        if (this.files.containsKey(path)) {
            return this.files.get(path);
        }
        IncomingFile inc = new IncomingFile(new File(this.root, path), null, this);
        this.addIncomingFile(inc, false);
        return inc;
    }

    public void addIncomingFile(IncomingFile incoming) {
        this.addIncomingFile(incoming, true);
    }

    public void addIncomingFile(IncomingFile incoming, boolean overwrite) {
        String path = incoming.getPath();
        if (incoming.isMetadataPSML()) {
            if (this.metadatafiles.containsKey(path) && !overwrite) {
                return;
            }
            this.metadatafiles.put(path, incoming);
        } else {
            if (this.files.containsKey(path) && !overwrite) {
                return;
            }
            this.files.put(path, incoming);
            String mediatype = incoming.getMediatype();
            List<String> paths = this.mediaTypes.get(mediatype);
            if (paths == null) {
                paths = new ArrayList<String>();
            }
            if (!paths.contains(path)) {
                paths.add(path);
            }
            this.mediaTypes.put(mediatype, paths);
        }
    }

    public void addMediaType(String mediaType, String @Nullable [] labels, @Nullable String usertitle, @Nullable String docid) {
        String utitle = PatternResolver.hasTokens(usertitle) ? usertitle : null;
        String did = PatternResolver.hasTokens(docid) ? docid : null;
        this.listAllFiles(this.root, mediaType, labels, utitle, did);
    }

    public boolean isEmpty() {
        return this.files.isEmpty() && this.metadatafiles.isEmpty();
    }

    public Collection<IncomingFile> getIncomingFiles(String mediaType) {
        if (ALL_MEDIATYPE.equals(mediaType)) {
            return this.getIncomingFiles();
        }
        List<String> paths = this.mediaTypes.get(mediaType);
        ArrayList<IncomingFile> thefiles = new ArrayList<IncomingFile>();
        for (String path : paths) {
            thefiles.add(this.files.get(path));
        }
        return thefiles;
    }

    public Collection<IncomingFile> getIncomingURLs() {
        return this.metadatafiles.values().stream().filter(incomingFile -> incomingFile.getAttribute("url") != null).collect(Collectors.toList());
    }

    public Collection<IncomingFile> getIncomingFiles() {
        return this.files.values();
    }

    public Collection<IncomingFile> getMetadataFiles() {
        return this.metadatafiles.values();
    }

    public @Nullable IncomingFile getCorrespondingMetadataFile(IncomingFile file) {
        String metadataPath = "META-INF/" + file.getPath() + ".psml";
        return this.metadatafiles.get(metadataPath);
    }

    public @Nullable IncomingFile getCorrespondingNonMetadataFile(IncomingFile metadata) {
        String path = metadata.getPath();
        if (!path.toLowerCase().startsWith("meta-inf/") || !path.toLowerCase().endsWith(".psml")) {
            return null;
        }
        return this.files.get(path.replaceAll("(^meta\\-inf/)|(^META\\-INF/)|(\\.psml$)|(\\.PSML$)", ""));
    }

    public void removeFile(IncomingFile file) {
        this.files.remove(file.getPath());
        this.metadatafiles.remove(file.getPath());
        List<String> paths = this.mediaTypes.get(file.getMediatype());
        if (paths != null) {
            paths.remove(file.getPath());
        }
    }

    public void clear() {
        this.mediaTypes.clear();
        this.files.clear();
        this.metadatafiles.clear();
    }

    public void loadExistingFiles() {
        this.listAllFiles(this.root, ALL_MEDIATYPE, null, null, null);
    }

    public UniversallyPrintable printable(boolean asTree, boolean media) {
        return new PrintableLoadingZone(this, asTree, media);
    }

    public static String buildUploadID(Long xlinkid) {
        return "PS-XLINK" + xlinkid;
    }

    public static String getUploadID(GeneratorRequest req, GeneratorResponse res) throws DatabaseException {
        String xlinkid;
        String uploadidParam = req.getParameter((Parameter)StandardParameters.uploadid);
        String uploadid = LoadingZone.getUploadID(uploadidParam, xlinkid = req.getParameter((Parameter)StandardParameters.xlinkid), req.getDatabase(), req.getMember());
        if (uploadid == null && (uploadidParam != null || xlinkid != null)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid uploadid or xlinkid");
            return "";
        }
        return uploadid;
    }

    public static boolean isValidUploadID(String id) {
        return id.matches(VALID_UPLOAD_ID) && id.length() <= 100 && !id.startsWith("PS-XLINK");
    }

    public static @Nullable String getUploadID(@Nullable String uploadid, @Nullable String xlinkid, Database db, Member mem) throws DatabaseException {
        if (uploadid != null) {
            if (LoadingZone.isValidUploadID(uploadid)) {
                return uploadid;
            }
            return null;
        }
        if (xlinkid != null) {
            XLink xl;
            Long xlid;
            try {
                xlid = Long.parseLong(xlinkid);
            }
            catch (NumberFormatException ex) {
                xlid = -1L;
            }
            if (xlid > 0L && XLinks.isComment((XLink)(xl = DatabaseQuery.getXLinkById((Database)db, (Long)xlid))) && XLinks.isDraft((XLink)xl) && mem.equals((Object)xl.getMember())) {
                return LoadingZone.buildUploadID(xl.getId());
            }
        }
        return null;
    }

    private void listAllFiles(File dir, @Nullable String mediaType, String @Nullable [] labels, @Nullable String title, @Nullable String docid) {
        File[] thefiles = dir.listFiles();
        if (thefiles != null) {
            for (File file : thefiles) {
                IncomingFile inc = new IncomingFile(file, null, this);
                if (file.isFile()) {
                    if (!ALL_MEDIATYPE.equals(mediaType) && (mediaType == null || !mediaType.equals(inc.getMediatype()))) continue;
                    if (labels != null) {
                        inc.setLabels(labels);
                    }
                    if (title != null) {
                        inc.setUsertitle(title);
                    }
                    if (docid != null) {
                        inc.setDocumentid(docid);
                    }
                }
                this.addIncomingFile(inc, false);
                if (!file.isDirectory()) continue;
                this.listAllFiles(file, mediaType, labels, title, docid);
            }
        }
    }

    private static final class PrintableLoadingZone
    implements UniversallyPrintable {
        private final LoadingZone zone;
        private final boolean asTree;
        private final boolean asMedia;

        PrintableLoadingZone(LoadingZone z, boolean tree, boolean media) {
            this.zone = z;
            this.asTree = tree;
            this.asMedia = media;
        }

        public void print(OutputPrinter output) {
            UniversalPrinter out = new UniversalPrinter(output);
            out.startObject("loadingzone");
            out.field("member", this.zone.memberID.toString());
            if (this.zone.uploadid != null) {
                out.field("uploadid", this.zone.uploadid);
            }
            int total = Files.countDescendantsFiles((File)this.zone.root);
            out.field("total-files", String.valueOf(total));
            out.startCollection("children", OutputPrinter.CollectionOption.JSON_ONLY);
            if (this.asTree) {
                for (File child : total > 1000 ? Files.childrenFolders((File)this.zone.root) : Files.children((File)this.zone.root)) {
                    try {
                        this.printTreeFile(out, Files.path((File)this.zone.root, (File)child), total > 1000);
                    }
                    catch (IOException ex) {
                        LoggerFactory.getLogger(LoadingZone.class).error("Failed to print loading zone file {}", (Object)child, (Object)ex);
                    }
                }
            } else if (this.zone.files.size() + this.zone.getIncomingURLs().size() > this.zone.maxIndividualFiles || this.asMedia) {
                String zipMediaType = Medias.getMediaType((String)"zip");
                List<String> zipPaths = this.zone.mediaTypes.get(zipMediaType);
                if (zipPaths != null) {
                    for (String path : zipPaths) {
                        out.write((UniversallyPrintable)this.zone.files.get(path));
                    }
                }
                for (String mtype : this.zone.mediaTypes.keySet()) {
                    if (mtype.equals(zipMediaType) || "folder".equals(mtype)) continue;
                    out.startObject("mediatype");
                    out.field("type", "mediatype", OutputPrinter.FieldOption.JSON_ONLY);
                    out.field("value", mtype);
                    List<String> paths = this.zone.mediaTypes.get(mtype);
                    out.field("files", (long)paths.size());
                    if (!paths.isEmpty()) {
                        out.write((UniversallyPrintable)this.zone.files.get(paths.get(0)));
                    }
                    out.endObject();
                }
                Collection<IncomingFile> urls = this.zone.getIncomingURLs();
                if (!urls.isEmpty()) {
                    out.startObject("mediatype");
                    out.field("type", "mediatype", OutputPrinter.FieldOption.JSON_ONLY);
                    out.field("value", "application/vnd.pageseeder.url+xml");
                    out.field("files", (long)urls.size());
                    out.write((UniversallyPrintable)urls.iterator().next());
                    out.endObject();
                }
            } else {
                for (IncomingFile incoming : this.zone.files.values()) {
                    if ("folder".equals(incoming.getMediatype())) continue;
                    out.write((UniversallyPrintable)incoming);
                }
                for (IncomingFile incoming : this.zone.getIncomingURLs()) {
                    out.write((UniversallyPrintable)incoming);
                }
            }
            out.endCollection();
            out.endObject();
        }

        private void printTreeFile(UniversalPrinter out, String path, boolean foldersOnly) {
            IncomingFile ifile = this.zone.existingFile(path);
            if (ifile == null) {
                return;
            }
            ifile.print((OutputPrinter)out, false);
            if (ifile.getFile().isDirectory()) {
                File dir = ifile.getFile();
                int children = Files.countChildrenFiles((File)dir);
                if (children > 100) {
                    out.field("files", (long)children);
                } else if (foldersOnly) {
                    out.field("files", (long)children);
                }
                int counter = 1;
                out.startCollection("children", OutputPrinter.CollectionOption.JSON_ONLY);
                for (File child : foldersOnly ? Files.childrenFolders((File)dir) : Files.children((File)dir)) {
                    this.printTreeFile(out, ifile.getPath() + "/" + child.getName(), foldersOnly);
                    if (counter++ < 100) continue;
                    break;
                }
                out.endCollection();
            }
            out.endObject();
        }
    }
}

