/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.Group;
import com.pageseeder.load.AddWorkflow;
import com.pageseeder.load.AntScript;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.PreviewThread;
import com.pageseeder.load.SendNotification;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class LoadingThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadingThreadFactory.class);
    private static final String DTD_DECLARATION_1_0 = "<!DOCTYPE upload-request PUBLIC \"-//PageSeeder//DTD::Upload Request 1.0//EN\" \"upload-request-1.0.dtd\" >";
    private static final String DTD_DECLARATION_2_0 = "<!DOCTYPE upload-request PUBLIC \"-//PageSeeder//DTD::Upload Request 2.0//EN\" \"upload-request-2.0.dtd\" >";
    private static final String DTD_DECLARATION_3_0 = "<!DOCTYPE upload-request PUBLIC \"-//PageSeeder//DTD::Upload Request 3.0//EN\" \"upload-request-3.0.dtd\" >";
    private static final LoadEntityResolver ENTITY_RESOLVER = new LoadEntityResolver();
    private static @Nullable SAXParserFactory factory = null;
    private static final LoadingThreadErrorHandler ERROR_HANDLER = new LoadingThreadErrorHandler();

    private LoadingThreadFactory() {
    }

    private static void initFactory() throws ParserConfigurationException, SAXException {
        if (factory != null) {
            return;
        }
        SAXParserFactory f = XMLHelpers.safeSAXParserFactory();
        f.setValidating(true);
        try {
            f.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException ex) {
            LOGGER.error("Failed to create SAX parser factory", (Throwable)ex);
        }
        factory = f;
    }

    public static LoadingThread createDefault(String username, boolean isContributor, Group group, LoadingZone loadingZone) {
        LoadingThread thread = new LoadingThread(username, isContributor, group, loadingZone);
        thread.setDefaults();
        return thread;
    }

    public static LoadingThread createDefault(String username, boolean isContributor, Long groupid, String groupname, LoadingZone loadingZone) {
        LoadingThread thread = new LoadingThread(username, isContributor, groupid, groupname, loadingZone);
        thread.setDefaults();
        return thread;
    }

    public static LoadingThread createFromXMLRequest(InputStream stream, String username, boolean isContributor, Group group, String jsessionid, String token, LoadingZone loadingZone) throws IOException, SAXException {
        XMLReader parser;
        LoadingThread thread = new LoadingThread(username, isContributor, group, loadingZone);
        try {
            LoadingThreadFactory.initFactory();
            parser = factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Failed to create SAX parser", (Throwable)ex);
            throw new UnforeseenException((Throwable)ex);
        }
        parser.setContentHandler(new Handler(thread, loadingZone, isContributor, jsessionid, token));
        parser.setEntityResolver(ENTITY_RESOLVER);
        parser.setErrorHandler(ERROR_HANDLER);
        String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        parser.parse(new InputSource(new StringReader(LoadingThreadFactory.getDTDDeclaration(content) + content)));
        return thread;
    }

    public static PreviewThread createPreviewFromXMLRequest(InputStream stream, String username, Group group, String jsessionid, String token, LoadingZone loadingZone) throws IOException, SAXException {
        XMLReader parser;
        PreviewThread thread = new PreviewThread(username, group, loadingZone);
        try {
            LoadingThreadFactory.initFactory();
            parser = factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Failed to create SAX parser", (Throwable)ex);
            throw new UnforeseenException((Throwable)ex);
        }
        Handler handler = new Handler(thread, loadingZone, false, jsessionid, token);
        parser.setContentHandler(handler);
        parser.setEntityResolver(ENTITY_RESOLVER);
        parser.setErrorHandler(ERROR_HANDLER);
        String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        parser.parse(new InputSource(new StringReader(LoadingThreadFactory.getDTDDeclaration(content) + content)));
        return thread;
    }

    private static String getDTDDeclaration(String content) {
        boolean isNot2;
        boolean isNot3 = !content.contains("<upload-request version=\"3.0\"") && !content.contains("<upload-request version='3.0'");
        boolean bl = isNot2 = !content.contains("<upload-request version=\"2.0\"") && !content.contains("<upload-request version='2.0'");
        if (isNot2 && isNot3) {
            return DTD_DECLARATION_1_0;
        }
        if (isNot3) {
            return DTD_DECLARATION_2_0;
        }
        return DTD_DECLARATION_3_0;
    }

    private static final class AntScriptDetails {
        private final String project;
        private final String doctype;
        private final String target;
        private final @Nullable Long delay;
        private final Map<String, String> params = new HashMap<String, String>();

        public AntScriptDetails(String project, String doctype, String target, @Nullable String delayBetweenChecks) {
            Long d;
            this.project = project;
            this.doctype = doctype;
            this.target = target;
            if (delayBetweenChecks != null) {
                try {
                    d = Long.valueOf(delayBetweenChecks);
                }
                catch (NumberFormatException e) {
                    d = null;
                }
            } else {
                d = null;
            }
            this.delay = d;
        }

        private AntScript toAntScript(ProcessThread thread, String jsessionid, String token, IncomingFile file) {
            AntScript ascript = new AntScript(thread, this.project, this.doctype, this.target, jsessionid, token, file);
            if (this.delay != null) {
                ascript.setStatusCheckDelay(this.delay);
            }
            for (String name : this.params.keySet()) {
                ascript.addParam(name, this.params.get(name));
            }
            return ascript;
        }
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String FILE_ELEMENT = "file";
        private static final String MEDIATYPE_ELEMENT = "mediatype";
        private static final String TITLE_ATTRIBUTE = "title";
        private static final String DOCID_ATTRIBUTE = "docid";
        private static final String LABELS_ATTRIBUTE = "labels";
        private static final String FILENAME_ATTRIBUTE = "filename";
        private static final String DESCRIPTION_ATTRIBUTE = "description";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String ACTION_ELEMENT = "action";
        private static final String TARGET_ATTRIBUTE = "target";
        private static final String PROJECT_ATTRIBUTE = "project";
        private static final String DOCTYPE_ATTRIBUTE = "doctype";
        private static final String DELAY_ATTRIBUTE = "delay";
        private static final String PARAM_ELEMENT = "param";
        private static final String NAME_ATTRIBUTE = "name";
        private static final String VALUE_ATTRIBUTE = "value";
        private static final String CREATEXREFS_ELEMENT = "createxrefs";
        private static final String INDEX_ELEMENT = "index";
        private static final String VALIDATE_ELEMENT = "validate";
        private static final String OVERWRITE_ELEMENT = "overwrite";
        private static final String INCLUDE_PROPERTIES_ATTRIBUTE = "include-properties";
        private static final String SUMMARY_ATTRIBUTE = "summary";
        private static final String WORKFLOW_ELEMENT = "workflow";
        private static final String WORKFLOW_STATUS_ATTRIBUTE = "status";
        private static final String WORKFLOW_PRIORITY_ATTRIBUTE = "priority";
        private static final String WORKFLOW_ASSIGNTO_ATTRIBUTE = "assignto";
        private static final String WORKFLOW_DUEDATE_ATTRIBUTE = "duedate";
        private static final String WORKFLOW_LABELS_ATTRIBUTE = "labels";
        private static final String WORKFLOW_NOTIFICATION_ATTRIBUTE = "notification";
        private static final String MESSAGE_ELEMENT = "message";
        private static final String MESSAGE_SUBJECT_ATTRIBUTE = "subject";
        private static final String MESSAGE_LABELS_ATTRIBUTE = "labels";
        private static final String MESSAGE_NOTIFICATION_ATTRIBUTE = "notification";
        private static final String NOTIFICATION_ELEMENT = "notification";
        private static final String NOTIFICATION_SUBJECT_ATTRIBUTE = "subject";
        private static final String NOTIFICATION_BROADCAST_ATTRIBUTE = "broadcast";
        private static final String NOTIFICATION_BROADCASTALL_ATTRIBUTE = "broadcastall";
        private static final String NOTIFICATION_BROADCASTAPPROVERS_ATTRIBUTE = "broadcastapprovers";
        private static final String NOTIFICATION_LABELS_ATTRIBUTE = "labels";
        private static final String NOTIFICATION_STATUS_ATTRIBUTE = "status";
        private final @Nullable LoadingThread thread;
        private final @Nullable PreviewThread previewthread;
        private final String jsessionid;
        private final String userToken;
        private final boolean isContributor;
        private final LoadingZone zone;
        private transient @Nullable IncomingFile currentFile = null;
        private transient @Nullable AntScriptDetails currentScript = null;
        private transient @Nullable SendNotification currentNotificationSender = null;
        private transient @Nullable AddWorkflow workflow = null;
        private transient @Nullable String currentElement = null;
        private transient @Nullable String currentMediaType = null;
        private transient boolean overwriteSummary = false;
        private final StringBuilder currentText = new StringBuilder();

        public Handler(LoadingThread thread, LoadingZone zone, boolean contributor, String jsessionid, String token) {
            this.thread = thread;
            this.zone = zone;
            this.previewthread = null;
            this.isContributor = contributor;
            this.jsessionid = jsessionid;
            this.userToken = token;
        }

        public Handler(PreviewThread thread, LoadingZone zone, boolean contributor, String jsessionid, String token) {
            this.thread = null;
            this.zone = zone;
            this.previewthread = thread;
            this.isContributor = contributor;
            this.jsessionid = jsessionid;
            this.userToken = token;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.currentElement = qName;
            if (FILE_ELEMENT.equals(qName)) {
                String labels;
                IncomingFile actualFile;
                String path = atts.getValue(PATH_ATTRIBUTE);
                if (path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                if (!(actualFile = this.zone.existingFile(path)).exists()) {
                    return;
                }
                this.currentFile = actualFile;
                if (atts.getValue(DOCID_ATTRIBUTE) != null) {
                    this.currentFile.setDocumentid(atts.getValue(DOCID_ATTRIBUTE));
                }
                if (atts.getValue(TITLE_ATTRIBUTE) != null) {
                    this.currentFile.setUsertitle(atts.getValue(TITLE_ATTRIBUTE));
                }
                if (atts.getValue(DESCRIPTION_ATTRIBUTE) != null) {
                    this.currentFile.setDescription(atts.getValue(DESCRIPTION_ATTRIBUTE));
                }
                if (atts.getValue(FILENAME_ATTRIBUTE) != null) {
                    this.currentFile.setFilename(atts.getValue(FILENAME_ATTRIBUTE));
                }
                if ((labels = atts.getValue("labels")) != null) {
                    this.currentFile.setLabels(Strings.split((String)labels, (char)','));
                }
            } else if (MEDIATYPE_ELEMENT.equals(qName) && this.thread != null) {
                this.currentMediaType = atts.getValue(VALUE_ATTRIBUTE);
                if (this.currentMediaType == null) {
                    return;
                }
                String[] labels = null;
                if (atts.getValue("labels") != null) {
                    labels = Strings.split((String)atts.getValue("labels"), (char)',');
                }
                this.zone.addMediaType(this.currentMediaType, labels, atts.getValue(TITLE_ATTRIBUTE), atts.getValue(DOCID_ATTRIBUTE));
            } else if (ACTION_ELEMENT.equals(qName)) {
                String actionProject = atts.getValue(PROJECT_ATTRIBUTE);
                String actionTarget = atts.getValue(TARGET_ATTRIBUTE);
                if (actionProject != null && actionTarget != null) {
                    this.currentScript = new AntScriptDetails(actionProject, atts.getValue(DOCTYPE_ATTRIBUTE), actionTarget, atts.getValue(DELAY_ATTRIBUTE));
                }
            } else if (PARAM_ELEMENT.equals(qName) && this.currentScript != null) {
                String name = atts.getValue(NAME_ATTRIBUTE);
                String val = atts.getValue(VALUE_ATTRIBUTE);
                if (name != null && val != null) {
                    this.currentScript.params.put(name, val);
                }
            } else if (WORKFLOW_ELEMENT.equals(qName)) {
                String status = atts.getValue("status");
                if (status != null && !status.isEmpty()) {
                    this.workflow = new AddWorkflow(this.thread);
                    this.workflow.setStatus(status);
                    this.workflow.setPriority(atts.getValue(WORKFLOW_PRIORITY_ATTRIBUTE));
                    String assign = atts.getValue(WORKFLOW_ASSIGNTO_ATTRIBUTE);
                    if ("".equals(assign)) {
                        this.workflow.setAssignTo(0L);
                    } else if (assign != null) {
                        if (Strings.isDigits((String)assign)) {
                            this.workflow.setAssignTo(Long.parseLong(assign));
                        } else {
                            LOGGER.warn("Ignoring invalid assignto {}", (Object)assign);
                        }
                    }
                    String due = atts.getValue(WORKFLOW_DUEDATE_ATTRIBUTE);
                    if ("".equals(due)) {
                        this.workflow.setDueDate(new Date(0L));
                    } else if (due != null) {
                        try {
                            this.workflow.setDueDate(XLinkRule.parseDueDate((String)due));
                        }
                        catch (ParseException ex) {
                            LOGGER.warn("Ignoring invalid due date {}: {}", (Object)due, (Object)ex.getMessage());
                        }
                    }
                    this.workflow.setNotification(Notify.fromString((String)atts.getValue("notification")));
                    String labels = atts.getValue("labels");
                    if (labels != null) {
                        this.workflow.setLabels(Strings.split((String)labels, (char)','));
                    }
                }
            } else if (MESSAGE_ELEMENT.equals(qName)) {
                this.currentNotificationSender = new SendNotification(this.thread);
                this.currentNotificationSender.setSubject(atts.getValue("subject"));
                this.currentNotificationSender.setNotify(atts.getValue("notification"));
                String labels = atts.getValue("labels");
                if (labels != null) {
                    this.currentNotificationSender.setLabels(Strings.split((String)labels, (char)','));
                }
            } else if ("notification".equals(qName)) {
                this.currentNotificationSender = new SendNotification(this.thread);
                this.currentNotificationSender.setStatus(atts.getValue("status"));
                this.currentNotificationSender.setSubject(atts.getValue("subject"));
                this.currentNotificationSender.setNotify(atts.getValue(NOTIFICATION_BROADCAST_ATTRIBUTE));
                Boolean.parseBoolean(atts.getValue(NOTIFICATION_BROADCASTAPPROVERS_ATTRIBUTE));
                String labels = atts.getValue("labels");
                if (labels != null) {
                    this.currentNotificationSender.setLabels(Strings.split((String)labels, (char)','));
                }
            } else if (OVERWRITE_ELEMENT.equals(qName)) {
                this.thread.setOverwriteExistingProperties("true".equals(atts.getValue(INCLUDE_PROPERTIES_ATTRIBUTE)));
                this.overwriteSummary = "true".equals(atts.getValue(SUMMARY_ATTRIBUTE));
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (INDEX_ELEMENT.equals(this.currentElement) || CREATEXREFS_ELEMENT.equals(this.currentElement) || OVERWRITE_ELEMENT.equals(this.currentElement) || VALIDATE_ELEMENT.equals(this.currentElement) || MESSAGE_ELEMENT.equals(this.currentElement) || "notification".equals(this.currentElement) || WORKFLOW_ELEMENT.equals(this.currentElement)) {
                this.currentText.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ACTION_ELEMENT.equals(qName) && this.currentScript != null && this.thread != null && this.currentMediaType != null) {
                for (IncomingFile file : this.zone.getIncomingFiles(this.currentMediaType)) {
                    this.thread.addAntScript(this.currentScript.toAntScript(this.thread, this.jsessionid, this.userToken, file));
                }
                this.currentScript = null;
            } else if (ACTION_ELEMENT.equals(qName) && this.currentScript != null && this.thread != null) {
                this.thread.addAntScript(this.currentScript.toAntScript(this.thread, this.jsessionid, this.userToken, this.currentFile));
                this.currentScript = null;
            } else if (ACTION_ELEMENT.equals(qName) && this.currentScript != null && this.previewthread != null && this.currentFile != null) {
                this.previewthread.setAntScript(this.currentScript.toAntScript(this.previewthread, this.jsessionid, this.userToken, this.currentFile));
                this.currentScript = null;
            } else if (FILE_ELEMENT.equals(qName) && this.currentFile != null && this.thread != null) {
                this.zone.addIncomingFile(this.currentFile);
            } else if (MEDIATYPE_ELEMENT.equals(qName) && this.currentMediaType != null) {
                this.currentMediaType = null;
            } else if (INDEX_ELEMENT.equals(qName) && this.thread != null) {
                this.thread.setIndex(Boolean.parseBoolean(this.currentText.toString()));
                this.currentText.setLength(0);
            } else if (CREATEXREFS_ELEMENT.equals(qName) && this.thread != null) {
                this.thread.setCreateXRefs(Boolean.parseBoolean(this.currentText.toString()));
                this.currentText.setLength(0);
            } else if (OVERWRITE_ELEMENT.equals(qName) && this.thread != null) {
                boolean overwite = Boolean.parseBoolean(this.currentText.toString());
                this.thread.setOverwrite(overwite && this.overwriteSummary ? LoadingThread.OverwriteBehavior.SUMMARY_ALWAYS : (overwite ? LoadingThread.OverwriteBehavior.OVERWRITE : (this.overwriteSummary ? LoadingThread.OverwriteBehavior.SUMMARY_IF_NEEDED : LoadingThread.OverwriteBehavior.FAIL)));
                this.currentText.setLength(0);
            } else if (VALIDATE_ELEMENT.equals(qName) && this.thread != null) {
                this.thread.setValidateSchematron(Boolean.parseBoolean(this.currentText.toString()));
                this.currentText.setLength(0);
            } else if (WORKFLOW_ELEMENT.equals(qName) && this.workflow != null && this.thread != null) {
                if (this.currentText.length() > 0) {
                    this.workflow.setDescription(this.currentText.toString());
                }
                this.thread.setWorkflow(this.workflow);
                this.currentText.setLength(0);
            } else if (MESSAGE_ELEMENT.equals(qName) && this.currentNotificationSender != null && this.thread != null) {
                if (this.currentText.length() > 0) {
                    this.currentNotificationSender.setMessage(this.currentText.toString());
                }
                this.thread.setNotificationSender(this.currentNotificationSender);
                this.currentText.setLength(0);
            } else if ("notification".equals(qName) && this.currentNotificationSender != null && this.thread != null) {
                if (this.currentText.length() > 0) {
                    this.currentNotificationSender.setMessage(this.currentText.toString());
                }
                this.thread.setNotificationSender(this.currentNotificationSender);
                this.currentText.setLength(0);
            }
        }
    }

    private static class LoadingThreadErrorHandler
    implements ErrorHandler {
        private LoadingThreadErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    private static final class LoadEntityResolver
    implements EntityResolver {
        private LoadEntityResolver() {
        }

        @Override
        public @Nullable InputSource resolveEntity(@Nullable String publicId, String systemId) throws SAXException {
            if (publicId != null && publicId.startsWith("-//PageSeeder//DTD::Upload Request 1.0")) {
                return new InputSource(LoadingThreadFactory.class.getResourceAsStream("/com/pageseeder/upload/upload-request-1.0.dtd"));
            }
            if (publicId != null && publicId.startsWith("-//PageSeeder//DTD::Upload Request 2.0")) {
                return new InputSource(LoadingThreadFactory.class.getResourceAsStream("/com/pageseeder/upload/upload-request-2.0.dtd"));
            }
            if (publicId != null && publicId.startsWith("-//PageSeeder//DTD::Upload Request 3.0")) {
                return new InputSource(LoadingThreadFactory.class.getResourceAsStream("/com/pageseeder/upload/upload-request-3.0.dtd"));
            }
            return null;
        }
    }
}

