/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Host;
import com.pageseeder.host.Hosts;
import com.pageseeder.mail.MailHosts;
import java.io.IOException;

@Requires(parameters={"name"})
@Output(types={OutputType.JSON, OutputType.XML})
public class EditHost
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        String hostName = req.getParameter((Parameter)StandardParameters.name);
        String newHostName = req.getParameter((Parameter)StandardParameters.new_name);
        String external = req.getParameter((Parameter)StandardParameters.external);
        String virtual = req.getParameter((Parameter)StandardParameters.virtual);
        assert (hostName != null);
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostName = hostName.toLowerCase()));
        if (host == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Host " + hostName + " was not found.");
            return;
        }
        if ("true".equals(external)) {
            host.setExternal(Boolean.TRUE);
        } else if ("false".equals(external)) {
            host.setExternal(Boolean.FALSE);
        }
        if ("true".equals(virtual)) {
            host.setVirtual(Boolean.TRUE);
        } else if ("false".equals(virtual)) {
            host.setVirtual(Boolean.FALSE);
        }
        if (newHostName != null) {
            if (!Hosts.checkHostName(newHostName = newHostName.toLowerCase(), res)) {
                return;
            }
            if (DatabaseQuery.getHostByName((Database)db, (String)newHostName) != null || DatabaseQuery.getHostAliasByName((Database)db, (String)newHostName) != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, "The host name is already in use.");
                return;
            }
            host.setName(newHostName);
            MailHosts.clearInternalHosts();
        }
        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Host {} ({}) was modified", (Object[])new Object[]{hostName, host.getId()});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("host-modification");
        out.writeHost(host);
        out.endObject();
        out.flush();
    }
}

