/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.groupfolder.GroupFolderErrorID;
import com.pageseeder.groupfolder.GroupFolders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@Requires(database=true, member=true, group=true, parameters={"id", "groups"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class DeleteGroupFolder
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ConfigureProjectCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        Long id = req.getParameter("id", -1L);
        String tgroups = req.getParameter((Parameter)StandardParameters.groups);
        assert (tgroups != null);
        GroupURI guri = DatabaseQuery.getGroupURIById((Database)db, (Long)id);
        if (guri == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)GroupFolderErrorID.INVALID_ID);
            return;
        }
        UserDetailsManager userManager = new UserDetailsManager();
        UserDetails userdetails = userManager.get(db, member.getId());
        Long memberid = member.getId();
        Collection currentGroups = guri.getGroupsCol();
        Group owner = GroupURIRule.getDefaultGroup((Database)db, (GroupURI)guri);
        Collection<Group> grpc = GroupFolders.checkGroups(res, db, tgroups, owner, currentGroups, true, memberid, userdetails);
        if (grpc == null) {
            return;
        }
        if (!group.equals((Object)owner) && !tgroups.equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupFolderErrorID.GROUP_FOLDER_NOT_OWNED, "Group folder not owned by or shared to group " + group.getName());
            return;
        }
        for (Group grp : grpc) {
            grp.removeGroupURIs(guri);
        }
        req.getTransaction().commitAndStart();
        if (!grpc.isEmpty()) {
            ChangesManager changes = ChangesManager.getInstance();
            ChangesBatch batch = new ChangesBatch("Unsharing group folder " + guri.getPath());
            changes.startBatch(db, batch);
            ArrayList<Group> modified = new ArrayList<Group>();
            modified.addAll(guri.getGroupsCol());
            if (!modified.contains(owner)) {
                modified.add(owner);
            }
            changes.modifyGroupfolder(db, batch, guri, modified);
            changes.deleteGroupfolder(db, guri.getId(), guri.getPath(), grpc);
            Collection uris = DatabaseQuery.getURIsByGroupURI((Database)db, (GroupURI)guri);
            for (URI uri : uris) {
                if (URIRule.isFolder((URI)uri)) {
                    changes.deleteFolder(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), grpc);
                    continue;
                }
                changes.deleteDocument(db, batch, uri.getId(), uri.getDocID(), uri.getPath(), grpc);
            }
            changes.completeBatch(db, batch);
        }
        SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.DELETION, (String)"Group folder {} was deleted", (Object[])new Object[]{guri.getPath()});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("groupfolder-delete");
        out.writeGroupFolder(guri, false, db);
        out.writeGroupFolderSharingDetails(guri, userdetails, db);
        out.endObject();
        out.endObject();
        out.flush();
    }
}

