/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForGroup;
import java.io.IOException;

@Requires(group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListSupergroups
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMembersCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group = req.getGroup();
        assert (group != null);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("supergroups");
        out.startCollection("supergroups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (GroupForGroup supergroup : DatabaseQuery.getGroupForGroupsBySubGroup((Database)req.getDatabase(), (Long)group.getId())) {
            out.writeSupergroup(supergroup);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

