/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.DeleteGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.group.GroupErrorID;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

@Requires(database=true, group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class DeleteGroup
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DeleteGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException, CommitTransactionException {
        File webapp;
        Template template;
        File templateDir;
        Collection groups;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        assert (group != null);
        boolean isProject = GroupRule.isProject((Group)group);
        if (isProject && !(groups = DatabaseQuery.getGroupsByNameStartsWith((Database)db, (String)(group.getName() + "-"))).isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Project's groups/subprojects must be deleted or archived before deleting the project.");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("group-delete");
        out.writeGroup(group);
        out.endObject();
        Long groupId = group.getId();
        String groupName = group.getName();
        try {
            GroupRule.deleteGroup((Database)db, (Group)group);
            SecurityLog.error((SecurityLog.EventType)SecurityLog.EventType.DELETION, (String)"{} {} was deleted", (Object[])new Object[]{isProject ? "Project" : "Group", groupName});
        }
        catch (DatabaseException e) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to delete the group from the database: " + e.getMessage());
            return;
        }
        catch (FoundationException e) {
            res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)GroupErrorID.FAILED_DELETE_GROUPURI, "Failed to delete group folder: " + e.getMessage());
            return;
        }
        if (isProject && (templateDir = TemplateFiles.getTemplateDirectory((Template)(template = new Template(groupName)), (File)(webapp = new File(Settings.getContextPath())))).exists()) {
            try {
                URIRule.deleteDir((File)templateDir);
            }
            catch (DatabaseException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to delete project template: " + ex.getMessage());
                return;
            }
        }
        UserDetailsManager userManager = new UserDetailsManager();
        userManager.removeAll();
        req.getTransaction().commit();
        if (isProject) {
            ChangesManager.getInstance().deleteProject(db, groupId, groupName);
        } else {
            ChangesManager.getInstance().deleteGroup(db, groupId, groupName);
        }
        out.flush();
    }
}

