/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class URIToProcess {
    private final Long uriid;
    private boolean loaded = false;
    private boolean foldersLoaded = false;
    private boolean forwardLoaded = false;
    private boolean reverseLoaded = false;
    private boolean imagesResolved = false;
    private final Map<Long, Boolean> forwardURIsToLoad = new HashMap<Long, Boolean>();
    private final List<Long> reverseURIsToLoad = new ArrayList<Long>();
    private final List<Long> reverseXrefs = new ArrayList<Long>();
    private List<Long> parentURIs = new ArrayList<Long>();
    private @Nullable Long releaseID = null;
    private @Nullable Date releaseDate = null;
    private boolean loadOriginalRelease = false;
    private @Nullable Long compareID = null;
    private boolean compareOriginalRelease = false;
    private boolean fromExport = true;

    public URIToProcess(Long uriid) {
        this.uriid = uriid;
    }

    public Long getURIID() {
        return this.uriid;
    }

    public void foldersLoaded() {
        this.foldersLoaded = true;
    }

    public void setFromExport(boolean fromExport) {
        this.fromExport = fromExport;
    }

    public boolean isFromExport() {
        return this.fromExport;
    }

    public void forwardXRefsLoaded() {
        this.forwardLoaded = true;
    }

    public boolean areFoldersLoaded() {
        return this.foldersLoaded;
    }

    public void reverseXRefsLoaded() {
        this.reverseLoaded = true;
    }

    public boolean areForwardXRefsResolved() {
        return this.forwardLoaded;
    }

    public boolean areReverseXRefsResolved() {
        return this.reverseLoaded;
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void imagesResolved() {
        this.imagesResolved = true;
    }

    public boolean areImagesResolved() {
        return this.imagesResolved;
    }

    public void addReverseXRef(Long xlinkid) {
        this.reverseXrefs.add(xlinkid);
    }

    public void setCompareID(Long id) {
        this.compareID = id;
    }

    public void setRelease(XLink release) {
        this.releaseID = release.getId();
        this.releaseDate = release.getDate();
    }

    public void loadOriginalRelease() {
        this.loadOriginalRelease = true;
    }

    public void compareWithOriginalRelease() {
        this.compareOriginalRelease = true;
    }

    public boolean hasCompare() {
        return this.compareID != null || this.compareOriginalRelease;
    }

    public @Nullable Long getCompareID() {
        return this.compareOriginalRelease ? Long.valueOf(0L) : this.compareID;
    }

    public boolean hasRelease() {
        return this.releaseID != null || this.loadOriginalRelease;
    }

    public Long getReleaseID() {
        return this.releaseID == null ? Long.valueOf(0L) : this.releaseID;
    }

    public @Nullable Date getReleaseDate() {
        return this.releaseDate;
    }

    public void addForwardURI(URI uri, boolean increaseDepth) {
        if (!this.forwardURIsToLoad.containsKey(uri.getId())) {
            this.forwardURIsToLoad.put(uri.getId(), increaseDepth);
        }
    }

    public void addReverseURI(URI uri) {
        if (!this.reverseURIsToLoad.contains(uri.getId())) {
            this.reverseURIsToLoad.add(uri.getId());
        }
    }

    public Collection<Long> getForwardURIsToLoad() {
        return this.forwardURIsToLoad.keySet();
    }

    public boolean forwardURIIncreaseDepth(Long uriid) {
        return this.forwardURIsToLoad.get(uriid);
    }

    public List<Long> getReverseURIsToLoad() {
        return this.reverseURIsToLoad;
    }

    public List<Long> getReverseXRefs() {
        return this.reverseXrefs;
    }

    public void setParent(@Nullable URIToProcess parent) {
        if (parent == null) {
            return;
        }
        this.parentURIs = new ArrayList<Long>();
        if (parent.parentURIs != null) {
            this.parentURIs.addAll(parent.parentURIs);
        }
        this.parentURIs.add(parent.uriid);
    }

    public boolean isURIAParent(Long uriid) {
        return this.parentURIs != null && this.parentURIs.contains(uriid);
    }
}

