/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.io.CharsetDetector;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.ResourceCompressor;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.developer.DevUtils;
import com.pageseeder.group.GroupErrorID;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.Nullable;

public final class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = -8465811785504841727L;
    private static final int WRITE_BUFFER = 2048;
    private File webapp = null;

    public void destroy() {
        this.webapp = null;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            ServletContext context = config.getServletContext();
            this.webapp = new File(context.getRealPath("/"));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.getResource(request, response, true);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) {
        this.getResource(request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResource(HttpServletRequest req, HttpServletResponse res, boolean content) {
        long contentLength;
        File file;
        Template template;
        AccessEvent.Permission accessPermission;
        WebRequest wr = new WebRequest(req, res);
        wr.ensureUtf8Request();
        long start = System.currentTimeMillis();
        boolean includeContent = content;
        boolean isPublishSessionFile = false;
        boolean isConfigFile = false;
        String groupNameOrId = req.getParameter("group");
        Object location = wr.getParameter("location");
        AccessEvent.Permission permission = accessPermission = groupNameOrId != null ? AccessEvent.Permission.PROJECT_MANAGER : AccessEvent.Permission.ADMINISTRATOR;
        if (location == null) {
            String servlet = req.getServletPath();
            if ("/publish/session".equals(servlet)) {
                location = "/WEB-INF/state" + servlet + req.getPathInfo();
                isPublishSessionFile = true;
                accessPermission = AccessEvent.Permission.MEMBER;
            } else {
                location = wr.getParameter("location", true);
            }
        } else {
            boolean bl = isConfigFile = groupNameOrId == null && (((String)location).startsWith("/WEB-INF/sysconfig/") || ((String)location).startsWith("/WEB-INF/config/"));
        }
        if (wr.hasError()) {
            return;
        }
        if (location != null && (((String)location).contains("../") || ((String)location).contains("..\\"))) {
            wr.sendError(400, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)400, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        Template template2 = template = isPublishSessionFile ? null : TemplateFactory.forLocation((String)location);
        if (!isPublishSessionFile && !isConfigFile && template == null) {
            wr.sendError(403, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)403, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        if (!isPublishSessionFile) {
            boolean allowed = false;
            Database db = wr.getDatabase();
            if (db == null) {
                return;
            }
            Transaction tr = null;
            try {
                Collection<Object> projects;
                tr = new Transaction(db);
                tr.begin();
                Permissions perm = new Permissions();
                if (groupNameOrId != null) {
                    Group group = GroupRule.getGroup((Database)db, (String)groupNameOrId);
                    if (group == null) {
                        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
                        tr.abort();
                        return;
                    }
                    projects = Collections.singletonList(GroupRule.isProject((Group)group) ? group : GroupRule.getTemplateProject((Database)db, (Group)group));
                    if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new ConfigureProjectCheck(group))) {
                        tr.abort();
                        return;
                    }
                } else {
                    if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new DevelopCheck())) {
                        tr.abort();
                        return;
                    }
                    projects = isConfigFile ? null : DatabaseQuery.getAllProjects((Database)db);
                }
                allowed = isConfigFile || DevUtils.allowViewing((String)location, projects);
                tr.commit();
            }
            catch (StartTransactionException ex) {
                wr.sendError((Exception)((Object)ex));
                WebUtilities.logAccess((HttpServletRequest)req, (int)res.getStatus(), (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
                return;
            }
            catch (Exception ex) {
                tr.abort();
                wr.sendError(ex);
                WebUtilities.logAccess((HttpServletRequest)req, (int)res.getStatus(), (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            }
            finally {
                db.close();
                db = null;
            }
            if (!allowed) {
                wr.sendError(403, "location is invalid");
                return;
            }
        }
        try {
            file = Files.descendantFile((File)this.webapp, (String)location);
        }
        catch (IOException ex) {
            wr.sendError((Exception)ex);
            return;
        }
        if (!file.exists()) {
            wr.sendError(404, "location is invalid");
            WebUtilities.logAccess((HttpServletRequest)req, (int)404, (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
            return;
        }
        String mediaType = Medias.getMediaType((File)file);
        if (mediaType != null) {
            res.setContentType(mediaType);
        }
        if (req.getHeader("Range") != null) {
            res.setHeader("Accept-Ranges", "none");
        }
        if ((contentLength = file.length()) == 0L) {
            includeContent = false;
        }
        HttpRequests.setContentLength((HttpServletResponse)res, (long)contentLength);
        res.setDateHeader("Last-Modified", file.lastModified());
        res.setHeader("Cache-Control", "no-cache");
        if (includeContent) {
            try {
                this.writeContent(req, res, file, mediaType);
            }
            catch (IOException ex) {
                wr.sendError((Exception)ex);
            }
        }
        if (req.getAttribute("com.pageseeder.layout") != Boolean.TRUE) {
            WebUtilities.logAccess((HttpServletRequest)req, (int)wr.getStatus(), (String)"resource", (long)start, (AccessEvent.Permission)accessPermission);
        }
    }

    private void writeContent(HttpServletRequest req, HttpServletResponse res, File file, @Nullable String mediaType) throws IOException {
        if ("true".equals(req.getParameter("download"))) {
            res.setHeader("Content-Disposition", HttpRequests.toSafeHeader((String)("attachment; filename=" + file.getName())));
        }
        res.setCharacterEncoding("utf-8");
        if (Medias.isText((String)mediaType)) {
            res.setBufferSize(2048);
        }
        if (HttpRequests.isCompressible((String)mediaType)) {
            res.setHeader("Vary", "Accept-Encoding");
            if (HttpRequests.acceptsGZipCompression((HttpServletRequest)req)) {
                byte[] compressed = this.loadCompressed(file, mediaType);
                res.setIntHeader("Content-Length", compressed.length);
                res.setHeader("Content-Encoding", "gzip");
                try (ServletOutputStream out = res.getOutputStream();){
                    out.write(compressed);
                    out.flush();
                }
                return;
            }
        }
        if (Medias.isText((String)mediaType)) {
            CharBuffer c = CharsetDetector.decode((File)file);
            try (PrintWriter writer = res.getWriter();){
                writer.print(Objects.toString(c, ""));
                writer.flush();
            }
        }
        try (ServletOutputStream out = res.getOutputStream();){
            Files.copy((File)file, (OutputStream)out);
            out.flush();
        }
    }

    private byte[] loadCompressed(File file, @Nullable String mediaType) throws IOException {
        if (Medias.isText((String)mediaType)) {
            CharBuffer c = CharsetDetector.decode((File)file);
            return ResourceCompressor.compress((byte[])Objects.toString(c, "").getBytes(StandardCharsets.UTF_8));
        }
        byte[] c = FileUtils.readFileToByteArray((File)file);
        return ResourceCompressor.compress((byte[])c);
    }
}

