/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.psml.PSMLConfigValidator;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.validation.AntScriptValidator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.LoggerFactory;

@Requires(database=true, group=true, parameters={"location"})
public final class PutProjectFile
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String owner = GroupRule.getTemplate((Group)group);
        String location = req.getParameter((Parameter)StandardParameters.location);
        assert (location != null);
        Template template = TemplateFactory.forLocation((String)location);
        if (template == null || template.isDefault() || !template.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        TemplateFiles kr = new TemplateFiles(template);
        File f = new File(kr.getWebApp(), location);
        TemplateFiles.Zone zone = TemplateFiles.getZone((Template)template, (String)location);
        try {
            if (zone == null || !Files.isDescendantOf((File)kr.get((TemplateZone)zone), (File)f)) {
                return new ForbiddenCheck();
            }
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(PutProjectFile.class).error("Failed to compute permissions", (Throwable)ex);
            return new ForbiddenCheck();
        }
        if (this.managerCanEdit(location)) {
            return new ConfigureProjectCheck(group);
        }
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        Group group = req.getGroup();
        Database db = req.getDatabase();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        String owner = GroupRule.getTemplate((Group)group);
        if (owner != null) {
            String location = req.getParameter((Parameter)StandardParameters.location);
            assert (location != null);
            Template template = TemplateFactory.forLocation((String)location);
            TemplateFiles kr = new TemplateFiles(template);
            File f = new File(kr.getWebApp(), location);
            String type = req.getParameter((Parameter)StandardParameters.type);
            boolean isFolder = type != null ? "folder".equals(type) : FilenameUtils.getExtension((String)location).isEmpty();
            boolean isIndexFields = f.getAbsolutePath().substring(kr.getTemplateDirectory().getAbsolutePath().length()).equals(File.separatorChar + "index" + File.separatorChar + "fields.xml");
            TemplateFiles.Zone zone = TemplateFiles.getZone((Template)template, (String)location);
            boolean overwrite = "true".equals(req.getParameter((Parameter)StandardParameters.overwrite));
            String content = req.getParameter((Parameter)StandardParameters.content);
            boolean exists = f.exists();
            boolean created = false;
            xml.openElement("file");
            xml.attribute("name", f.getName());
            xml.attribute("path", location);
            if (exists && !overwrite) {
                res.setError(GeneratorStatus.BAD_REQUEST, "File already exist");
            } else if (exists && isFolder) {
                res.setError(GeneratorStatus.BAD_REQUEST, "Folder already exist");
            } else if (isFolder) {
                xml.attribute("type", "folder");
                created = f.mkdirs();
                if (created) {
                    xml.attribute("status", "created");
                }
            } else {
                xml.attribute("type", "file");
                String media = Medias.getMediaType((File)f);
                byte[] data = new byte[]{};
                if (content == null) {
                    if (Medias.isText((String)media)) {
                        content = req.getContent();
                    } else {
                        data = req.getData();
                    }
                }
                if (media != null) {
                    xml.attribute("mediatype", media);
                }
                List<String> errors = null;
                if (content != null) {
                    errors = this.validateContent(location, content);
                }
                if (errors != null && !errors.isEmpty()) {
                    StringBuilder allErrors = new StringBuilder();
                    for (String error : errors) {
                        allErrors.append(error).append('\n');
                    }
                    res.setError(GeneratorStatus.BAD_REQUEST, allErrors.toString());
                    return;
                }
                if (!exists) {
                    File dir = f.getParentFile();
                    if (!dir.exists()) {
                        FileUtils.forceMkdir((File)dir);
                    }
                    if (created = f.createNewFile()) {
                        xml.attribute("status", "created");
                        res.setStatus(GeneratorStatus.CREATED);
                    } else {
                        res.setError(GeneratorStatus.SERVER_ERROR, "Unable to create resource");
                    }
                } else {
                    xml.attribute("status", content != null ? "modified" : "not-modified");
                }
                if (content != null) {
                    FileUtils.writeStringToFile((File)f, (String)content, (Charset)StandardCharsets.UTF_8);
                    xml.writeText(content);
                    if (isIndexFields) {
                        IndexAnalyzers.clearCachedAnalyzer((String)owner);
                        IndexMaster.getInstance().updateTemplateIndexes(owner, db);
                    }
                } else {
                    FileUtils.writeByteArrayToFile((File)f, (byte[])data);
                }
                TemplateHistory history = new TemplateHistory(kr);
                history.backup((TemplateZone)zone, "/" + Files.path((File)kr.get((TemplateZone)zone), (File)f));
            }
            xml.closeElement();
            if (location.endsWith("/config/project.properties")) {
                GroupProperties.clearCache((Database)db, (String)owner);
            }
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }

    private List<String> validateContent(String location, String content) {
        if (location.toLowerCase().endsWith("/build.xml")) {
            AntScriptValidator validator = new AntScriptValidator();
            validator.validateScript(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
            return validator.getErrors();
        }
        PSMLConfigValidator validator = new PSMLConfigValidator();
        try {
            validator.validateConfigFile(location, content);
            return validator.getErrors();
        }
        catch (URIException ex) {
            return Collections.singletonList(ex.getMessage());
        }
    }

    private boolean managerCanEdit(String location) {
        int i = location.lastIndexOf(47);
        if (i == -1) {
            return false;
        }
        String filename = location.substring(i + 1).toLowerCase();
        String folder = location.substring(0, i).toLowerCase();
        return "document-template.psml".equals(filename) || "document-config.xml".equals(filename) || "publish-config.xml".equals(filename) || "xref-config.xml".equals(filename) || "publication-config.xml".equals(filename) || "editor-config.xml".equals(filename) || "document.css".equals(filename) || "media-template.psml".equals(filename) || "pdf-export-config.xml".equals(filename) || "word-export-config.xml".equals(filename) || "word-import-config.xml".equals(filename) || "psml-split-config.xml".equals(filename) || "project.properties".equals(filename) || filename.endsWith(".sch") || folder.endsWith("/member") && filename.endsWith(".xml");
    }
}

