/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.content;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.GeneralLogViewer;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.text.ParseException;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetGeneralLog
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String date = req.getParameter((Parameter)StandardParameters.date);
        String page = req.getParameter((Parameter)StandardParameters.page);
        GeneralLogViewer viewer = new GeneralLogViewer();
        try {
            if (date != null) {
                viewer.setDate(ISO8601.parseAuto((String)date));
            }
            if (page != null) {
                viewer.setPage(Integer.parseInt(page));
            }
            viewer.build();
            XMLWriter xml = res.getXMLWriter();
            viewer.toXML(xml);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid ISO8601 date");
        }
        catch (NumberFormatException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Not a valid page number");
        }
    }
}

