/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.AddXLinksCheck;
import com.pageseeder.base.permission.EditXLinkCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkChanges;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.util.HTMLSanitizer;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadFactory;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Requires(member=true, parameters={"xlink"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class EditComment
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditComment.class);
    private static final String STATUS_CHANGE = "-status";

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        EditXLinkCheck check;
        Database db = req.getDatabase();
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (xlink == null) {
            return new ForbiddenCheck();
        }
        String url = req.getParameter((Parameter)StandardParameters.url);
        if (url != null) {
            check = new EditXLinkCheck(url, xlink);
        } else {
            TargetContext target = this.getTargetContext(req, null);
            URI uri = target != null && target.uri != null ? target.uri : URIRule.getURIByXLink((XLink)xlink);
            check = new EditXLinkCheck(uri, xlink);
        }
        if (req.getParameter((Parameter)StandardParameters.authorname) != null || req.getParameter((Parameter)StandardParameters.authoremail) != null) {
            check.setChangeAuthor(true);
        }
        if (req.getParameter((Parameter)StandardParameters.created) != null) {
            check.setChangeCreated(true);
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Iterator conti;
        boolean currentIsLast;
        Map newProperties;
        Member moderator;
        Database db = req.getDatabase();
        String title = req.getParameter((Parameter)StandardParameters.title);
        String content = req.getParameter((Parameter)StandardParameters.content);
        String groups = req.getParameter((Parameter)StandardParameters.groups);
        String moderated = req.getParameter((Parameter)StandardParameters.moderated);
        String contenttype = req.getParameter((Parameter)StandardParameters.contenttype);
        String properties = req.getParameter((Parameter)StandardParameters.properties);
        String type = req.getParameter((Parameter)StandardParameters.type);
        String labels = req.getParameter((Parameter)StandardParameters.labels);
        String created = req.getParameter((Parameter)StandardParameters.created);
        String authorname = req.getParameter((Parameter)StandardParameters.authorname);
        String authoremail = req.getParameter((Parameter)StandardParameters.authoremail);
        String status = req.getParameter((Parameter)StandardParameters.status);
        String priority = req.getParameter((Parameter)StandardParameters.priority);
        String due = req.getParameter((Parameter)StandardParameters.due);
        String assignedto = req.getParameter((Parameter)StandardParameters.assignedto);
        String urls = req.getParameter((Parameter)StandardParameters.urls);
        String uris = req.getParameter((Parameter)StandardParameters.uris);
        String draft = req.getParameter((Parameter)StandardParameters.draft);
        String attgroup = req.getParameter((Parameter)StandardParameters.attachmentgroup);
        String notifyParam = req.getParameter((Parameter)StandardParameters.notify, "silent");
        if (!Comments.checkLabels(res, labels)) {
            return;
        }
        if (!Comments.checkStatus(res, status)) {
            return;
        }
        if (!Comments.checkPriority(res, priority)) {
            return;
        }
        Notify notify = Notify.fromString((String)notifyParam);
        if (notify == Notify.UNKNOWN) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The notify parameter is invalid.");
            return;
        }
        XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (XLinks.isArchived((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_ARCHIVED);
            return;
        }
        if (!XLinks.isComment((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_COMMENT);
            return;
        }
        boolean workflow = XLinks.isWorkflow((XLink)xl);
        if (workflow) {
            if (title != null || groups != null || properties != null || type != null || created != null || authoremail != null || authorname != null || urls != null || uris != null || !XLinks.isDraft((XLink)xl) && (draft != null || status != null || priority != null || due != null || assignedto != null)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.WORKFLOW_EDIT_NOT_ALLOWED);
                return;
            }
            if (contenttype != null && !contenttype.equals("text/plain") && !contenttype.equals("application/xhtml+xml")) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, "The only workflow content types allowed are: text/plain, application/xhtml+xml");
                return;
            }
        }
        if (authoremail != null && !"".equals(authoremail) && !Emails.isAddress((String)authoremail)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
            return;
        }
        Collection<Group> oldGroups = XLinkRule.getGroups((XLink)xl);
        oldGroups = GroupRule.removeAdminGroup((Collection)oldGroups);
        XLink oldParentTask = XLinkRule.isTask((XLink)xl) && xl.getReplyTos().hasNext() ? (XLink)xl.getReplyTos().next() : null;
        TargetContext target = this.getTargetContext(req, res);
        if (target == null) {
            return;
        }
        URI uri = target.uri != null ? target.uri : URIRule.getURIByXLink((XLink)xl);
        boolean movingTaskRoot = XLinkRule.isTask((XLink)xl) && oldParentTask == null && target.replyto != null;
        XLink replytoRoot = null;
        if (target.replyto != null && (replytoRoot = XLinks.getThreadRoot((XLink)target.replyto)) != null && xl.getId().equals(replytoRoot.getId())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.REPLY_TO_ITSELF);
            return;
        }
        Member member = req.getMember();
        UserDetailsManager userManager = new UserDetailsManager();
        UserDetails userdetails = userManager.get(db, member.getId());
        Long memberid = req.getMember().getId();
        XLink threadRoot = XLinks.getThreadRoot((XLink)xl);
        XLink taskRoot = target.replyto != null ? replytoRoot : threadRoot;
        boolean external = URIs.isExternal((URI)uri);
        Collection<Group> grpc = new ArrayList();
        if (target.replyto != null) {
            grpc = XLinkRule.getGroups((XLink)replytoRoot);
        } else if (groups != null && (xl.equals((Object)threadRoot) || target.uri != null && target.fragment != null)) {
            try {
                grpc = GroupRule.getGroupsByNames((Database)db, Arrays.asList(groups.split(",")));
            }
            catch (DatabaseException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, ex.getMessage());
                return;
            }
            if (grpc.isEmpty()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "groups can't be empty.");
                return;
            }
        }
        try {
            ArrayList<Group> uriGroups = new ArrayList();
            if (target.replyto != null) {
                uriGroups = null;
            } else if (!external) {
                uriGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            }
            grpc = GroupRule.removeAdminGroup(grpc);
            moderator = this.checkGroups(db, grpc, uri, memberid, userdetails, uriGroups);
        }
        catch (GeneratorException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, ex.getMessage());
            return;
        }
        boolean contributor = !grpc.isEmpty() ? MemberRule.isContributorForGroups((UserDetails)userdetails, grpc) : MemberRule.isContributorForGroups((UserDetails)userdetails, (Collection)oldGroups);
        Member ed = req.getMember();
        boolean movereplies = req.getParameter((Parameter)StandardParameters.movereplies, true);
        if (!xl.getAuthorOnly().booleanValue() && !workflow) {
            XLink archiveXl = !grpc.isEmpty() ? XLinkRule.copyXLinkWithGroups((Database)db, (XLink)xl, grpc) : XLinkRule.copyXLink((Database)db, (XLink)xl);
            XLinkRule.archiveXLink((XLink)archiveXl);
            archiveXl.setModifiedBy(ed);
            archiveXl.setModifiedDate(new Date());
            archiveXl = archiveXl.insert(db);
            threadRoot.addReplies(archiveXl);
        }
        URI targetUri = target.uri;
        Locator loc = LocatorRule.getLocatorByXLink((Database)db, (XLink)threadRoot);
        if (targetUri == null && target.fragment != null && uri != null && loc != null && !target.fragment.equals(loc.getFragment())) {
            targetUri = uri;
        }
        if (target.fragment != null && targetUri != null && URIRule.isInvalidFragment((URI)uri, (Group)req.getGroup(), (String)target.fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID already exists with a different case");
            return;
        }
        Object changeType = "modified";
        if (moderated != null) {
            if (!xl.getAccepted().booleanValue() && !"true".equals(moderated)) {
                if (taskRoot.getThreadEnd() == null || xl.getId().compareTo(taskRoot.getThreadEnd().getId()) > 0) {
                    taskRoot.setThreadEnd(xl);
                }
                changeType = "added";
            }
            xl.setAccepted(Boolean.valueOf(!"true".equals(moderated)));
        }
        Map currentProperties = ObjectProperties.toMap((String)xl.getProperties());
        Map map = newProperties = properties != null ? ObjectProperties.toMap((String)properties) : currentProperties;
        if (labels != null) {
            if (labels.isEmpty()) {
                newProperties.remove("label");
            } else {
                newProperties.put("label", Arrays.asList(labels.split(",")));
            }
        } else if (properties != null) {
            newProperties.put("label", (List)currentProperties.get("label"));
        }
        xl.setProperties(ObjectProperties.toString((Map)newProperties));
        Member assignee = null;
        if (assignedto != null && !assignedto.isEmpty() && (assignee = DatabaseQuery.getMemberById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.assignedto, -1L))) == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.ASSIGNEDTO_INVALID);
            return;
        }
        Date dueDate = null;
        if (due != null && !due.isEmpty()) {
            try {
                dueDate = XLinkRule.parseDueDate((String)due);
            }
            catch (ParseException e) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DUEDATE_INVALID);
                return;
            }
        }
        XLink lastone = taskRoot.getThreadEnd() != null ? taskRoot.getThreadEnd() : taskRoot;
        boolean bl = currentIsLast = lastone == null || lastone.getId() <= xl.getId();
        if (target.replyto != null && lastone != null) {
            if (status == null) {
                status = lastone.getStatus() == null ? "" : lastone.getStatus();
            } else {
                changeType = (String)changeType + STATUS_CHANGE;
            }
            if (priority == null) {
                priority = lastone.getPriority() == null ? "" : lastone.getPriority();
            } else {
                changeType = (String)changeType + STATUS_CHANGE;
            }
            if (assignedto == null) {
                assignedto = "";
                assignee = lastone.getAssignedTo();
            } else {
                changeType = (String)changeType + STATUS_CHANGE;
            }
            if (due == null) {
                due = "";
                dueDate = lastone.getDueDate() == null ? null : new Date(lastone.getDueDate().getTime());
            } else {
                changeType = (String)changeType + STATUS_CHANGE;
            }
        }
        Collection<XLink> moveReplies = this.moveXLink(db, xl, targetUri, target.fragment, target.replyto, movereplies ? grpc : null, userdetails, member, status, priority, assignee, dueDate, title);
        if (status != null) {
            if (status.isEmpty() && (!Strings.isEmpty((String)xl.getStatus()) && target.replyto == null || currentIsLast && lastone != null && !Strings.isEmpty((String)lastone.getStatus()))) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.STATUS_INVALID, "Once status is set on a task, it cannot be cleared.");
                return;
            }
            if (!this.compareParam(status, xl.getStatus())) {
                if (!currentIsLast && !status.isEmpty() && lastone != null && Strings.isEmpty((String)lastone.getStatus())) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.STATUS_INVALID, "Status can only be set on the last comment in a discussion.");
                    return;
                }
                xl.setStatus(status);
                xl.setStatusChangedDate(new Date());
                xl.setStatusChangedBy(ed);
                if (currentIsLast) {
                    changeType = (String)changeType + STATUS_CHANGE;
                }
            }
        }
        if (xl.getStatus() == null) {
            xl.setAssignedTo(null);
            xl.setPriority(null);
            xl.setDueDate(null);
        } else {
            if (priority != null && !this.compareParam(priority, xl.getPriority())) {
                xl.setPriority(priority);
                if (currentIsLast) {
                    changeType = (String)changeType + STATUS_CHANGE;
                }
            }
            if (assignedto != null && !this.compare(assignee, xl.getAssignedTo())) {
                xl.setAssignedTo(assignee);
                xl.setAssignedDate(new Date());
                if (currentIsLast) {
                    changeType = (String)changeType + STATUS_CHANGE;
                }
            }
            if (due != null && !this.compare(dueDate, xl.getDueDate())) {
                xl.setDueDate(dueDate);
                if (currentIsLast) {
                    changeType = (String)changeType + STATUS_CHANGE;
                }
            }
        }
        if (title != null) {
            xl.setContentTitle(title);
        }
        if (type != null) {
            xl.setType(type);
        }
        if (created != null) {
            try {
                xl.setDate(ISO8601.DATETIME.parse(created));
            }
            catch (ParseException e) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.DATE_INVALID, "The created date is invalid.");
                return;
            }
        }
        Member mem = xl.getMember();
        if (!(authoremail == null || authoremail.isEmpty() || mem != null && authoremail.equals(mem.getEmail()))) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)authoremail);
        } else if ("".equals(authoremail) && mem != null && !"No Email".equals(mem.getEmail())) {
            mem = null;
        }
        if (mem != null) {
            xl.setMember(mem);
            xl.setAuthorName(null);
            xl.setAuthorEmail(null);
        } else {
            if (authorname != null) {
                xl.setAuthorName(authorname);
            } else {
                xl.setAuthorName(XLinkRule.getAuthorName((XLink)xl));
            }
            if (authoremail != null) {
                xl.setAuthorEmail(authoremail.isEmpty() ? "No Email" : authoremail);
            }
            xl.setMember(null);
        }
        xl.setModifiedDate(new Date());
        xl.setModifiedBy(ed);
        boolean isPublic = XLinkRule.isPublic((XLink)xl);
        if (!grpc.isEmpty()) {
            isPublic = XLinkRule.modifyGroups((Database)db, (XLink)xl, grpc);
            for (XLink reply : xl.getRepliesCol()) {
                if (moveReplies.contains(reply)) continue;
                XLinkRule.modifyGroups((Database)db, (XLink)reply, grpc);
            }
        }
        if ((conti = xl.getContents()).hasNext()) {
            Content cont = (Content)conti.next();
            if (contenttype != null) {
                cont.setType(contenttype.toLowerCase());
            }
            if (content != null) {
                cont.setData(cont.getType().equals("application/xhtml+xml") ? HTMLSanitizer.sanitizeForComments((String)content) : content);
            }
            if ((contenttype != null || content != null) && cont.getType() != null && (cont.getType().endsWith("/xml") || cont.getType().endsWith("+xml"))) {
                try {
                    List errors;
                    Object validate = cont.getData();
                    if (cont.getType().equals("application/xhtml+xml")) {
                        if (cont.getData() == null && !Strings.isEmpty((String)content) || content == null && cont.getData() != null && !cont.getData().equals(HTMLSanitizer.sanitizeForComments((String)cont.getData()))) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, "The XHTML content contains elements, attributes or entities that are not supported.");
                            return;
                        }
                        validate = "<content>" + cont.getData() + "</content>";
                    }
                    if (!(errors = XMLHelpers.validateWellFormednessReturnErrors((String)validate)).isEmpty()) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, "The content was invalid: " + String.join((CharSequence)", ", errors));
                        return;
                    }
                }
                catch (IOException | SAXException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTENT_INVALID, "The content was invalid: " + ex.getMessage());
                    return;
                }
            }
        }
        Collection<Object> attachUris = new ArrayList();
        if (urls != null || uris != null) {
            xl.setContentRole(urls == null || urls.isEmpty() ? "Comment" : "File Attachment");
            XLinkRule.removeAttachments((Database)db, (XLink)xl);
            Collection<URI> attachUrls = Comments.attachURLs(db, xl, urls, res);
            if (attachUrls == null) {
                return;
            }
            attachUris = Comments.attachURIs(db, xl, uris, res);
            if (attachUris == null) {
                return;
            }
            attachUris.addAll(attachUrls);
        }
        boolean originalAuthorOnly = xl.getAuthorOnly();
        String error = null;
        if (draft != null) {
            if (xl.getAuthorOnly().booleanValue() && !"true".equals(draft)) {
                Long xlinkid = xl.getId();
                if (threadRoot != xl || workflow && !xl.getRepliesCol().isEmpty()) {
                    XLink cloneXl = XLinkRule.copyXLink((Database)db, (XLink)xl);
                    XLinkRule.moveAttachments((XLink)xl, (XLink)cloneXl);
                    if (threadRoot == xl) {
                        taskRoot = threadRoot = XLinkRule.moveReplies((Database)db, (XLink)xl, (Locator)loc);
                    }
                    threadRoot.addReplies(cloneXl);
                    XLinkRule.deleteXLink((Database)db, (XLink)xl);
                    xl = cloneXl;
                }
                if (grpc.isEmpty()) {
                    moderator = this.checkGroups(db, oldGroups, uri, memberid, userdetails, null);
                }
                changeType = this.simulateNewComment(xl, moderator, lastone, taskRoot);
                if (workflow) {
                    uri.setLastModified(new Date(xl.getDate().getTime()));
                    req.getTransaction().commitAndStart();
                    Collection uriGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
                    ChangesManager.getInstance().modifyURI(db, uri, uriGroups);
                    ChangesManager.getInstance().createWorkflow(db, xl, uriGroups);
                }
                if (attgroup != null) {
                    req.getTransaction().commitAndStart();
                    error = this.handleAttachments(xl, attgroup, xlinkid, db, req);
                }
            } else if (!xl.getAuthorOnly().booleanValue() && "true".equals(draft)) {
                xl.setAccepted(Boolean.valueOf(false));
                xl.setAuthorOnly(Boolean.valueOf(true));
            }
        } else if (workflow) {
            req.getTransaction().commitAndStart();
            Collection uriGroups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            ChangesManager.getInstance().createWorkflow(db, xl, uriGroups);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comment-modification");
        if (error != null) {
            out.field("error", error);
        }
        if (!xl.getAuthorOnly().booleanValue()) {
            if (workflow) {
                this.sendNotification(req, res, db, (OutputPrinter)out, xl, uri, contributor, (String)changeType, notify);
            } else {
                Collection modifyGroups;
                Collection<Group> addGroups;
                Date modified = new Date();
                for (Group grp : oldGroups) {
                    GroupStateManager.singleton().setCommentsModified(grp, modified);
                }
                for (Group grp : grpc) {
                    GroupStateManager.singleton().setCommentsModified(grp, modified);
                }
                req.getTransaction().commitAndStart();
                this.sendNotification(req, res, db, (OutputPrinter)out, xl, uri, contributor, (String)changeType, notify);
                ChangesManager changes = ChangesManager.getInstance();
                Collection removeGroups = new ArrayList();
                Collection<Group> currentGroups = oldGroups;
                if (!grpc.isEmpty()) {
                    removeGroups = GroupRule.removeAdminOtherGroups((Collection)oldGroups, grpc);
                    currentGroups = grpc;
                }
                if (!removeGroups.isEmpty() && !originalAuthorOnly) {
                    changes.deleteComment(db, xl.getId(), removeGroups);
                    for (XLink reply : moveReplies) {
                        if (XLinks.isArchived((XLink)reply)) continue;
                        changes.deleteComment(db, reply.getId(), removeGroups);
                    }
                    if (xl.getStatus() != null && oldParentTask == null) {
                        changes.taskUpdated(db, null, xl.getId(), removeGroups);
                    }
                }
                Collection<Object> collection = addGroups = originalAuthorOnly ? currentGroups : GroupRule.removeAdminOtherGroups(currentGroups, oldGroups);
                if (!addGroups.isEmpty()) {
                    changes.createComment(db, xl, addGroups);
                    for (XLink reply : moveReplies) {
                        if (XLinks.isArchived((XLink)reply)) continue;
                        changes.createComment(db, reply, addGroups);
                    }
                }
                if (!(modifyGroups = GroupRule.removeAdminOtherGroups(currentGroups, addGroups)).isEmpty()) {
                    if (movingTaskRoot) {
                        changes.taskUpdated(db, null, xl.getId(), modifyGroups);
                    }
                    changes.modifyComment(db, xl, modifyGroups);
                }
                if (oldParentTask != null) {
                    changes.modifyComment(db, oldParentTask, XLinkRule.getGroups((XLink)oldParentTask));
                }
                if (URIs.canBeIndexedAsURL((URI)uri)) {
                    IndexMaster.getInstance().indexURL(uri.getId(), false, null, new PSRequester("Editing comment " + xl.getId()));
                }
            }
        }
        if (isPublic) {
            out.field("public", true);
        }
        Collection<Group> returngroups = Comments.getReturnGroups(req);
        out.writeComment(xl, db, null, returngroups, true, true, true, false);
        out.endObject();
        out.flush();
    }

    private @Nullable String handleAttachments(@Nullable XLink xl, @Nullable String attgroup, @Nullable Long xlinkid, Database db, GeneratorRequest req) throws DatabaseException {
        if (xl == null || xl.getMember() == null || attgroup == null || xlinkid == null) {
            return null;
        }
        Group gp = GroupRule.getGroup((Database)db, (String)attgroup);
        if (gp == null) {
            LOGGER.error("The attachmentgroup {} was not found", (Object)attgroup);
            return "The attachmentgroup was not found";
        }
        LoadingZone zone = new LoadingZone(attgroup, gp.getOwnerDirectory(), xl.getMember().getId(), LoadingZone.buildUploadID(xlinkid));
        zone.loadExistingFiles();
        if (!zone.isEmpty()) {
            URL destination;
            LoadingThread thread = LoadingThreadFactory.createDefault(xl.getMember().getUsername(), true, gp, zone);
            thread.setRemoveLoadingZone(true);
            thread.setCreateXRefs(false);
            thread.setOverwrite(LoadingThread.OverwriteBehavior.RENAME);
            thread.setCreateManifest(false);
            thread.setNotificationSender(null);
            thread.setMalwareScan(SecurityUtils.isMalwareScan((HttpServletRequest)req.getHttpServletRequest()));
            GroupURI def = GroupURIRule.getDefaultGroupURI((Group)gp);
            if (def == null) {
                LOGGER.debug("Failed to find attachment folder when there is no default Group URI");
                return "Failed to find attachment folder";
            }
            Object path = GroupURIs.truncatePath((String)def.getPath());
            String subdir = GlobalSettings.getString((String)"attachmentSubDir", (String)"attachments");
            if (!subdir.isEmpty()) {
                path = (String)path + "/" + subdir;
            }
            Calendar now = Calendar.getInstance();
            now.setTimeInMillis(System.currentTimeMillis());
            int month = now.get(2) + 1;
            path = (String)path + "/" + now.get(1) + "/" + (month < 10 ? "0" : "") + month;
            try {
                destination = new URL(def.getScheme(), def.getHost().getName(), def.getPort(), (String)path);
            }
            catch (MalformedURLException ex) {
                LOGGER.error("Failed to build attachment folder URL: {}", (Object)ex.getMessage());
                return "Invalid attachment folder URL";
            }
            thread.setDestination(destination);
            thread.run();
            ProcessStage stage = thread.getCurrentStatus();
            if (stage.getStatus() != ProcessStage.Status.COMPLETED) {
                LOGGER.error(stage.getMessage());
                return "Failed to upload files: " + stage.getMessage();
            }
            for (IncomingFile ifile : zone.getIncomingFiles()) {
                URI attachmentURI;
                Long uriid = ifile.getUriID();
                if (uriid == null || (attachmentURI = DatabaseQuery.getURIById((Database)db, (Long)uriid)) == null) continue;
                LocatorRule.addXLinkToLocator((Database)db, (XLink)xl, (URI)attachmentURI, (String)"default", (String)"page-link", (String)"file-attachment", null);
                xl.setContentRole("File Attachment");
            }
        } else {
            LoadingThread.deleteFile(zone.baseDirectory());
        }
        return null;
    }

    private String simulateNewComment(XLink xl, Member moderator, XLink lastone, XLink root) {
        String changeType = "added";
        Date currentDate = new Date();
        if (lastone != null && xl.getId() > lastone.getId()) {
            if (!(this.compare(xl.getStatus(), lastone.getStatus()) && this.compare(xl.getPriority(), lastone.getPriority()) && this.compare(xl.getAssignedTo(), lastone.getAssignedTo()) && this.compare(xl.getDueDate(), lastone.getDueDate()))) {
                changeType = "status-added";
            }
            if (xl.getAssignedTo() != null) {
                if (!xl.getAssignedTo().equals((Object)lastone.getAssignedTo())) {
                    xl.setAssignedDate(currentDate);
                } else if (lastone.getAssignedDate() != null) {
                    xl.setAssignedDate(new Date(lastone.getAssignedDate().getTime()));
                }
            }
        } else if (lastone == null && xl.getStatus() != null) {
            changeType = "status-added";
            if (xl.getAssignedTo() != null) {
                xl.setAssignedDate(currentDate);
            }
        }
        if (moderator != null) {
            xl.setAccepted(Boolean.valueOf(false));
            xl.setModifiedBy(moderator);
            changeType = "moderated";
        } else {
            xl.setAccepted(Boolean.valueOf(true));
            xl.setModifiedBy(null);
            root.setThreadEnd(xl);
        }
        xl.setAuthorOnly(Boolean.valueOf(false));
        xl.setDate(currentDate);
        xl.setModifiedDate(null);
        xl.setStatusChangedDate(null);
        xl.setStatusChangedBy(null);
        return changeType;
    }

    private Member checkGroups(Database db, Collection<Group> grpc, URI uri, Long memberid, UserDetails userdetails, @Nullable Collection<Group> uriGroups) throws GeneratorException, DatabaseException {
        boolean external = URIs.isExternal((URI)uri);
        Permissions perm = new Permissions();
        Member moderator = null;
        for (Group grp : grpc) {
            MemberForGroup mod;
            boolean access = PermissionManager.check((Long)memberid, (UserDetails)userdetails, (Database)db, (Permissions)perm, (PermissionCheck)new AddXLinksCheck(grp));
            if (uriGroups != null && !access) {
                throw new GeneratorException("Not allowed to add comments to group: " + grp.getName());
            }
            if (!(perm.getSetGroups() && !GroupRule.moderationRequired((Group)grp) || (mod = DatabaseQuery.getModeratorByGroupId((Database)db, (Long)grp.getId())) == null || mod.getMember().getId().equals(memberid))) {
                moderator = mod.getMember();
            }
            if (uriGroups == null || external || uriGroups.contains(grp) || GroupRule.isSubGroup(uriGroups, (Group)grp) || memberid != null && grpc.size() == 1 && grp.getName().trim().equalsIgnoreCase(GroupRule.getMemberPersonalGroupName((Long)memberid)) && PermissionManager.check((Long)memberid, (UserDetails)userdetails, (Database)db, (Permissions)perm, (PermissionCheck)new ViewURICheck(uri))) continue;
            throw new GeneratorException("Internal URI " + uri.getId() + " is not accessible to group: " + grp.getName());
        }
        return moderator;
    }

    private @Nullable TargetContext getTargetContext(GeneratorRequest req, GeneratorResponse res) throws DatabaseException {
        Database db = req.getDatabase();
        URI turi = null;
        String movegroup = req.getParameter((Parameter)StandardParameters.group);
        Long replytoid = req.getParameter((Parameter)StandardParameters.reply, -1L);
        Long uriid = req.getParameter((Parameter)StandardParameters.uri, -1L);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String url = req.getParameter((Parameter)StandardParameters.url);
        Group group = null;
        XLink replyto = null;
        int contexts = 0;
        if (movegroup != null) {
            group = DatabaseQuery.getGroupByName((Database)db, (String)movegroup);
            if (group == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.GROUP_INVALID, "Move to group not found: " + movegroup);
                }
                return null;
            }
            turi = URIRule.getURIForGeneralDiscussion((Database)db, null, (Group)group);
            if (turi == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)CommentErrorID.NO_GENERAL_DISCUSSION, "No general discussion for move group: " + movegroup);
                }
                return null;
            }
            fragment = "default";
            ++contexts;
        }
        if (replytoid != -1L) {
            replyto = DatabaseQuery.getXLinkById((Database)req.getDatabase(), (Long)replytoid);
            if (replyto == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_NOT_FOUND, "Comment not found for reply ID: " + replytoid);
                }
                return null;
            }
            turi = URIRule.getURIByXLink((XLink)replyto);
            if (turi == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)CommentErrorID.NO_CONTEXT_URI, "No context URI for comment with reply ID: " + replytoid);
                }
                return null;
            }
            fragment = null;
            ++contexts;
        }
        if (uriid != -1L) {
            turi = DatabaseQuery.getURIById((Database)db, (Long)uriid);
            if (turi == null) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URI_NOT_FOUND);
                }
                return null;
            }
            ++contexts;
            if (fragment == null) {
                fragment = "default";
            }
        }
        if (url != null) {
            try {
                URL urlObj = RuleUtils.urlEncodeNormalize((String)url);
                if (URIRule.isExternal((URL)urlObj, (Database)db)) {
                    turi = URIRule.createURIForURLDocidBehaviorDescUserTitleType((Database)db, (Transaction)req.getTransaction(), (URL)urlObj, null, null, null, null, null);
                } else {
                    turi = URIRule.getURIByURL((Database)db, (URL)urlObj);
                    if (turi == null) {
                        if (res != null) {
                            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_NOT_FOUND, "The URL is internal and not found.");
                        }
                        return null;
                    }
                }
                fragment = urlObj.getRef();
                if (fragment == null) {
                    fragment = "default";
                }
            }
            catch (MalformedURLException ex) {
                if (res != null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_INVALID, "URL is invalid: " + url);
                }
                return null;
            }
            ++contexts;
        }
        if (contexts > 1) {
            if (res != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Only one of uri, url, group or replyto can be specified.");
            }
            return null;
        }
        return new TargetContext(turi, fragment, replyto);
    }

    private boolean compareParam(String param, Object value) {
        return param != null && param.equals(value) || "".equals(param) && value == null;
    }

    private boolean compare(Object value1, Object value2) {
        return value1 != null && value1.equals(value2) || value1 == null && value2 == null;
    }

    private Collection<XLink> moveXLink(Database db, XLink xl, URI uri, String fragment, XLink replyto, Collection<Group> grpc, UserDetails userdetails, Member member, String status, String priority, Member assignee, Date dueDate, String title) throws DatabaseException {
        ArrayList<XLink> movedReplies = new ArrayList<XLink>();
        ArrayList<XLink> otherReplies = new ArrayList<XLink>();
        if (uri != null && fragment != null || replyto != null) {
            XLink newThreadRoot;
            Locator loc = LocatorRule.getLocatorByXLink((Database)db, (XLink)xl);
            XLink threadRoot = XLinks.getThreadRoot((XLink)xl);
            XLinkRule.removeXLink((Database)db, (XLink)xl, (boolean)false);
            XLinkRule.addXLink((Database)db, (XLink)xl, (URI)uri, (String)fragment, (Long)(replyto != null ? replyto.getId() : null));
            XLink xLink = newThreadRoot = replyto != null ? XLinks.getThreadRoot((XLink)replyto) : null;
            if (replyto != null) {
                xl.setContentTitle(title != null ? title : replyto.getContentTitle());
            }
            if (grpc == null) {
                XLinkRule.moveReplies((Database)db, (XLink)xl, (Locator)loc);
            } else {
                ArrayList<XLink> allComments = new ArrayList<XLink>();
                allComments.add(threadRoot);
                allComments.addAll(threadRoot.getRepliesCol());
                for (XLink reply : allComments) {
                    if (reply.equals((Object)xl)) {
                        if (replyto == null) continue;
                        reply.setContentTitle(title != null ? title : replyto.getContentTitle());
                        continue;
                    }
                    if (!reply.getDate().before(xl.getDate()) && this.isManagerOrAuthorContributor(reply, userdetails, member)) {
                        if (!grpc.isEmpty()) {
                            XLinkRule.modifyGroups((Database)db, (XLink)reply, grpc);
                        }
                        if (newThreadRoot != null) {
                            XLinkRule.removeXLink((Database)db, (XLink)reply, (boolean)false);
                            newThreadRoot.addReplies(reply);
                        } else if (!xl.equals((Object)threadRoot)) {
                            XLinkRule.removeXLink((Database)db, (XLink)reply, (boolean)false);
                            xl.addReplies(reply);
                        }
                        if (replyto != null) {
                            reply.setStatus(status);
                            reply.setPriority(priority);
                            reply.setAssignedTo(assignee);
                            reply.setDueDate(dueDate);
                            reply.setContentTitle(title != null ? title : replyto.getContentTitle());
                        }
                        movedReplies.add(reply);
                        continue;
                    }
                    otherReplies.add(reply);
                }
                if (!otherReplies.isEmpty() && !otherReplies.contains(threadRoot)) {
                    Iterator otheri = otherReplies.iterator();
                    XLink otherThreadRoot = (XLink)otheri.next();
                    XLinkRule.removeXLink((Database)db, (XLink)otherThreadRoot, (boolean)false);
                    LocatorRule.addXLinkToLocator((Database)db, (XLink)otherThreadRoot, (Locator)loc);
                    while (otheri.hasNext()) {
                        XLink other = (XLink)otheri.next();
                        XLinkRule.removeXLink((Database)db, (XLink)other, (boolean)false);
                        otherThreadRoot.addReplies(other);
                    }
                }
            }
            XLinkRule.updateThreadEnd((XLink)threadRoot);
            if (newThreadRoot != null) {
                XLinkRule.updateThreadEnd((XLink)newThreadRoot);
                xl.setThreadEnd(null);
            } else {
                XLinkRule.updateThreadEnd((XLink)xl);
            }
        }
        return movedReplies;
    }

    private boolean isManagerOrAuthorContributor(XLink xl, UserDetails userdetails, Member member) {
        Collection groups = XLinkRule.getGroups((XLink)xl);
        for (Group group : groups) {
            if (!MemberRule.isManagerForGroup((UserDetails)userdetails, (String)group.getName()) && (!MemberRule.isContributorForGroup((UserDetails)userdetails, (String)group.getName()) || !member.equals((Object)xl.getMember()))) continue;
            return true;
        }
        return false;
    }

    private void sendNotification(GeneratorRequest req, GeneratorResponse res, Database db, OutputPrinter out, XLink xl, URI uri, boolean contributor, String changeType, Notify notify) {
        if (!contributor && req.getAuthenticatedMember() != null) {
            UserDetails userdetails = new UserDetailsManager().get(db, req.getAuthenticatedMember().getId());
            contributor = MemberRule.isAdministrator((Map)userdetails.flags());
        }
        boolean accepted = xl.getAccepted();
        XLinkChanges xlchange = new XLinkChanges(uri, Boolean.valueOf(Emails.getNotifyAsyncParameter((GeneratorRequest)req)));
        if (!contributor && notify != Notify.NORMAL) {
            notify = Notify.NORMAL;
            out.field("notify-param-ignored", true);
        }
        if (!accepted && !"moderated".equals(changeType) && notify != Notify.SILENT) {
            notify = Notify.SILENT;
            out.field("notify-param-ignored", true);
        }
        xlchange.addXLinkChange(xl, changeType, notify);
        boolean error = false;
        try {
            xlchange.process(req.getDatabase());
            if (xlchange.getStatus() != XLinkChanges.ChangeStatus.SUCCESS) {
                LOGGER.warn("Comment could not be submitted! XLinkChanges Status: {} Message: {}", (Object)xlchange.getStatus(), (Object)xlchange.getStatusMessage());
                error = true;
            } else if (xlchange.getStatusMessage() != null && accepted) {
                out.field("notification-email-delayed", true);
            }
        }
        catch (EmailException ex) {
            error = true;
        }
        catch (DatabaseException ex) {
            LOGGER.error("Database error when processing comment edit", (Throwable)ex);
            error = true;
        }
        if (error) {
            if (!accepted) {
                out.field("moderator-email-failed", true);
            } else {
                out.field("notification-email-failed", true);
            }
        }
    }

    private static final class TargetContext {
        private final URI uri;
        private final String fragment;
        private final XLink replyto;

        public TargetContext(URI u, String f, XLink r) {
            this.uri = u;
            this.fragment = f;
            this.replyto = r;
        }
    }
}

