/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.cache;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.eclipse.jdt.annotation.Nullable;

@Requires(parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetCacheInfo
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String name = req.getParameter((Parameter)StandardParameters.name);
        CacheManager manager = CacheManager.getInstance();
        Ehcache cache = manager.getEhcache(name);
        if (cache == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Cache not found with specified 'name'.");
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        GetCacheInfo.print(cache, (OutputPrinter)out);
        out.flush();
    }

    private static void print(@Nullable Ehcache cache, OutputPrinter out) {
        if (cache == null) {
            return;
        }
        Status status = cache.getStatus();
        out.startObject("cache");
        out.field("name", cache.getName());
        out.field("guid", cache.getGuid());
        out.field("status", status.toString());
        out.field("disabled", cache.isDisabled());
        if (status == Status.STATUS_ALIVE) {
            out.startObject("info");
            out.field("size", (long)cache.getSize());
            out.endObject();
        }
        GetCacheInfo.print(cache.getCacheConfiguration(), out);
        out.endObject();
    }

    private static void print(CacheConfiguration config, OutputPrinter out) {
        out.startObject("configuration");
        out.field("disk-spool-buffer-size-mb", (long)config.getDiskSpoolBufferSizeMB());
        out.field("disk-expiry-thread-interval-seconds", config.getDiskExpiryThreadIntervalSeconds());
        out.field("max-entries-local-disk", config.getMaxEntriesLocalDisk());
        out.field("max-entries-local-heap", config.getMaxEntriesLocalHeap());
        out.field("max-bytes-local-disk", config.getMaxBytesLocalDisk());
        out.field("max-bytes-local-disk-percentage-set", config.isMaxBytesLocalDiskPercentageSet());
        out.field("max-bytes-local-heap", config.getMaxBytesLocalHeap());
        out.field("max-bytes-local-heap-percentage-set", config.isMaxBytesLocalHeapPercentageSet());
        out.field("eternal", config.isEternal());
        out.field("clear-on-flush", config.isClearOnFlush());
        out.field("copy-on-read", config.isCopyOnRead());
        out.field("copy-on-write", config.isCopyOnWrite());
        out.field("count-based-tuned", config.isCountBasedTuned());
        if (config.isMaxBytesLocalDiskPercentageSet()) {
            out.field("max-bytes-local-disk-percentage", (long)config.getMaxBytesLocalDiskPercentage().intValue());
        }
        if (config.isMaxBytesLocalHeapPercentageSet()) {
            out.field("max-bytes-local-disk-percentage", (long)config.getMaxBytesLocalHeapPercentage().intValue());
        }
        MemoryStoreEvictionPolicy policy = config.getMemoryStoreEvictionPolicy();
        out.field("memory-store-eviction-policy", policy.toString());
        out.endObject();
    }
}

