/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai;

import com.pageseeder.ai.core.AIRequest;
import com.pageseeder.ai.core.IntelligenceProvider;
import com.pageseeder.ai.core.Prompts;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import net.pageseeder.ai.prompt.Prompt;
import net.pageseeder.ai.prompt.PromptTemplate;

@Requires(uri=true, group=true, member=true, parameters={"prompt"})
public final class PreviewPrompt
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        URI uri = req.getURI();
        Group group = req.getGroup();
        assert (uri != null && group != null);
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(group, uri));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        IntelligenceProvider provider = IntelligenceProvider.getGlobal();
        if (provider == IntelligenceProvider.NONE) {
            res.setError(GeneratorStatus.NOT_IMPLEMENTED, "AI not supported");
            return;
        }
        AIRequest ai = new AIRequest(req);
        PromptTemplate template = ai.buildTemplate(res);
        if (template == null) {
            return;
        }
        Prompt prompt = template.toPrompt(ai.getParameters());
        UniversalPrinter out = res.getUniversalWriter();
        Prompts.printPrompt((OutputPrinter)out, prompt);
        out.flush();
    }
}

