/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder;

import com.pageseeder.Initialize;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class DBMonitor
extends HttpServlet {
    private static final long serialVersionUID = -6319472320189593256L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        UniversalPrinter out = WebUtilities.getUniversalPrinter((HttpServletRequest)req, (HttpServletResponse)res);
        if (!Initialize.initThread.isFinished()) {
            out.startObject("monitor");
            Initialize.initThread.print((OutputPrinter)out);
            out.endObject();
            out.flush();
            return;
        }
        Database db = wr.getDatabase();
        if (db == null) {
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            Group grp = DatabaseQuery.getGroupByName((Database)db, (String)"admin");
            if (grp == null) {
                res.sendError(502, "Group admin not found.");
            } else {
                out.startObject("monitor");
                out.field("message", "Connected to database and accessed a group OK");
                out.endObject();
                out.flush();
            }
            tr.commit();
        }
        catch (StartTransactionException ex) {
            wr.sendError(502, ex.getMessage());
        }
        catch (DatabaseException ex) {
            wr.sendError(502, ex.getMessage());
            tr.abort();
        }
        catch (Exception ex) {
            wr.sendError(500, ex.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
    }

    public String getServletInfo() {
        return "Try's to connect to the database";
    }
}

