/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import com.pageseeder.common.util.CollectedError;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ErrorCollector<T extends Exception> {
    private final List<CollectedError<T>> collected = new ArrayList<CollectedError<T>>();
    private CollectedError.Level exceptionLevel = CollectedError.Level.FATAL;
    private CollectedError.Level flagLevel = CollectedError.Level.ERROR;
    private boolean hasError = false;

    public final void setException(CollectedError.Level threshold) {
        this.exceptionLevel = Objects.requireNonNull(threshold, "Specified threshold is null");
    }

    public final void setErrorFlag(CollectedError.Level threshold) {
        this.flagLevel = Objects.requireNonNull(threshold, "Specified threshold is null");
    }

    public final void collect(CollectedError.Level level, T exception) throws T {
        this.collected.add(new CollectedError<T>(level, exception));
        if (this.flagLevel.compareTo(level) <= 0) {
            this.hasError = true;
        }
        if (this.exceptionLevel.compareTo(level) <= 0) {
            throw exception;
        }
    }

    public final void collectQuietly(CollectedError.Level level, T exception) {
        this.collected.add(new CollectedError<T>(level, exception));
        if (this.flagLevel.compareTo(level) <= 0) {
            this.hasError = true;
        }
    }

    public final List<CollectedError<T>> getErrors() {
        return this.collected;
    }

    public final boolean hasError() {
        return this.hasError;
    }
}

