/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Locations;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateHistory;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.ISO8601;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplatePacker {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplatePacker.class);
    private static final Pattern TEMPLATE_FILE_PATH = Pattern.compile("WEB-INF\\/template\\/([^\\/]+)\\/([^\\/]+)\\/(.+)");
    private static final Pattern DOCUMENT_STYLE_PATH = Pattern.compile("woconfig\\/([^\\/]+)\\/psml\\/([^\\/]+)\\/(.+)");
    private static final Pattern ORGANIZATION_STYLE_PATH = Pattern.compile("woconfig\\/([^\\/]+)\\/organization\\/(.+)");
    private static final String TEMPLATE_FOLDER = "WEB-INF/config/template/";
    private static final int MAX_ENTRIES = 1000;
    private static final long MAX_UNCOMPRESSED_SIZE = 100000000L;
    private static final long MAX_RATIO = 100L;
    private static final FileFilter FILTER = f -> {
        File parent = f.getParentFile();
        if ("member".equals(parent.getParentFile().getName())) {
            try {
                Long.parseLong(parent.getName());
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return !f.getName().startsWith(".") && f.canRead() && !f.isHidden();
    };
    private final File webapp;

    public TemplatePacker(File webapp) {
        this.webapp = webapp;
    }

    public void pack(Template kit, File pack, String username) throws IOException {
        if (kit.isDefault()) {
            throw new IllegalArgumentException("Cannot pack default template");
        }
        File template = TemplateFiles.getTemplateDirectory(kit, this.webapp).getCanonicalFile();
        ArrayList<File> files = new ArrayList<File>();
        TemplatePacker.collect(template, files);
        if (!files.isEmpty()) {
            try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(pack));){
                zip.setMethod(8);
                for (File f : files) {
                    String location = Files.path(template, f);
                    ZipEntry entry = new ZipEntry(location);
                    zip.putNextEntry(entry);
                    Files.copy(f, zip);
                }
                zip.setComment(TemplatePacker.getComment(kit, username));
                zip.finish();
            }
            LOGGER.info("Packed {} files for {}", (Object)files.size(), (Object)kit);
        }
    }

    public void unpack(Template template, File pack) throws IOException {
        if (template.isDefault()) {
            throw new IllegalArgumentException("Cannot unpack in default template");
        }
        int count = 0;
        long compressedSize = pack.length();
        long uncompressedSize = 0L;
        try (ZipFile zip = new ZipFile(pack);){
            if (zip.size() > 1000) {
                throw new IOException("ZIP file contain too many entries");
            }
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String path;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                long size = entry.getSize();
                if (size != -1L) {
                    uncompressedSize += size;
                }
                this.checkRatio(compressedSize, uncompressedSize);
                if (entryName.startsWith("__MACOSX") || entryName.startsWith("META-INF") || (path = this.toPath(entry, template.name())) == null) continue;
                String folder = Locations.getFolder(path);
                String name = Locations.getFilename(path);
                if (name.indexOf(46) == 0) continue;
                File dir = Files.descendantFile(this.webapp, folder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = Files.descendantFile(dir, name);
                if (entry.isDirectory()) {
                    file.mkdir();
                    continue;
                }
                try (InputStream in = zip.getInputStream(entry);){
                    java.nio.file.Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                TemplateHistory history = new TemplateHistory(template, this.webapp);
                history.backup("/" + Files.path(this.webapp, file));
                ++count;
            }
        }
        LOGGER.info("Unpacked {} files into {}", (Object)count, (Object)template);
    }

    private @Nullable String toPath(ZipEntry entry, String template) {
        boolean isLegacy = entry.getName().contains("/{KIT}/");
        if (isLegacy) {
            return this.adjustPathForNewStructure(entry.getName().replace("/{KIT}/", "/" + template + "/"));
        }
        return TEMPLATE_FOLDER + template + "/" + entry.getName();
    }

    private @Nullable String adjustPathForNewStructure(String path) {
        Matcher m = TEMPLATE_FILE_PATH.matcher((CharSequence)path);
        Matcher m1 = DOCUMENT_STYLE_PATH.matcher((CharSequence)path);
        Matcher m2 = ORGANIZATION_STYLE_PATH.matcher((CharSequence)path);
        path = m.matches() ? TEMPLATE_FOLDER + m.group(1) + "/" + m.group(2).toLowerCase() + "/" + m.group(3) : (m1.matches() ? TEMPLATE_FOLDER + m1.group(1) + "/psml/" + m1.group(2) + "/style/" + m1.group(3) : (m2.matches() ? TEMPLATE_FOLDER + m2.group(1) + "/organization/style/" + m2.group(2) : null));
        return path;
    }

    public PackCheck checkUnpack(Template template, File pack) throws IOException {
        if (template.isDefault()) {
            throw new IllegalArgumentException("Cannot check unpack in default kit");
        }
        PackCheck check = new PackCheck();
        long compressedSize = pack.length();
        long uncompressedSize = 0L;
        try (ZipFile zip = new ZipFile(pack);){
            if (zip.size() > 1000) {
                throw new ZipException("ZIP file contain too many entries");
            }
            String comment = zip.getComment();
            if (comment != null && comment.startsWith("{ \"pageseeder\":")) {
                check.isPageseeder = true;
            }
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String path;
                String name;
                long size;
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith("WEB-INF/template/{KIT}/")) {
                    check.isPageseeder = true;
                }
                if ((size = entry.getSize()) != -1L) {
                    uncompressedSize += size;
                }
                this.checkRatio(compressedSize, uncompressedSize);
                if (entry.isDirectory() || entry.getName().startsWith("META-INF") || entry.getName().startsWith("__MACOSX") || (name = Locations.getFilename(entry.getName())).indexOf(46) == 0 || (path = this.toPath(entry, template.name())) == null) continue;
                check.files.add(new File(this.webapp, path));
            }
        }
        return check;
    }

    public static boolean isTemplatePack(File pack) {
        boolean bl;
        ZipFile zip = new ZipFile(pack);
        try {
            zip.getComment();
            bl = zip.size() <= 1000;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.warn("Invalid pack '" + pack.getName() + "'", (Throwable)ex);
                return false;
            }
        }
        zip.close();
        return bl;
    }

    private void checkRatio(long compressedSize, long uncompressedSize) throws ZipException {
        if (uncompressedSize > 100000000L) {
            throw new ZipException("Uncompressed data exceeds maximum size allowed");
        }
        if (uncompressedSize / compressedSize > 100L) {
            throw new ZipException("Uncompressed data exceeds maximum ratio allowed");
        }
    }

    private static String getComment(Template template, String username) {
        return "{ \"pageseeder\": \"" + Settings.getPageSeederVersion() + "\", \"user\": \"" + username + "\", \"template\": \"" + template.name() + "\", \"created\": \"" + ISO8601.now() + "\" }";
    }

    private static void collect(File file, List<File> results) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(FILTER);
            if (files != null) {
                for (File f : files) {
                    TemplatePacker.collect(f, results);
                }
            }
        } else if (file.isFile()) {
            results.add(file);
        }
    }

    public static class PackCheck {
        private boolean isPageseeder = false;
        private final List<File> files = new ArrayList<File>();

        public boolean isPageseeder() {
            return this.isPageseeder;
        }

        public List<File> getFiles() {
            return this.files;
        }
    }
}

