/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import com.pageseeder.common.io.Locations;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.Settings;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class TemplateFiles {
    private static final String FORMAT_PREFIX = "format-";
    private static final String PSML_FORMAT_FOLDER = "psml";
    private static final FileFilter NAME_FILTER = f -> f.isDirectory() && !f.isHidden() && Template.isValidName(f.getName());
    private final Template template;
    private final File webapp;
    private final TemplateZone[] zones;

    public TemplateFiles(String template) {
        this.template = Template.isDefault(template) ? Template.DEFAULT : new Template(template);
        this.webapp = new File(Settings.getContextPath());
        this.zones = Zone.values();
    }

    public TemplateFiles(Template template) {
        this.template = Objects.requireNonNull(template);
        this.webapp = new File(Settings.getContextPath());
        this.zones = Zone.values();
    }

    public TemplateFiles(Template template, File webapp) {
        this.template = Objects.requireNonNull(template);
        this.webapp = Objects.requireNonNull(webapp);
        this.zones = Zone.values();
    }

    public Template template() {
        return this.template;
    }

    public File getWebApp() {
        return this.webapp;
    }

    public File get(TemplateZone zone) {
        return new File(this.webapp, zone.folder(this.template));
    }

    public @Nullable File get(String location) {
        Zone zone = TemplateFiles.getZone(this.template, location);
        if (zone != null) {
            return new File(this.webapp, location);
        }
        return null;
    }

    public @Nullable File get(TemplateZone zone, String location) {
        return Locations.toFile(this.get(zone), location);
    }

    public @Nullable File find(String location) {
        Zone zone = TemplateFiles.getZone(this.template, location);
        if (zone == null) {
            return null;
        }
        String relative = location.substring(zone.folder(this.template).length());
        return this.find(zone, relative);
    }

    public boolean overridesDefault(String location) {
        Zone zone = TemplateFiles.getZone(this.template, location);
        if (zone == null) {
            return false;
        }
        String relative = location.substring(zone.folder(this.template).length());
        return this.overridesDefault(zone, relative);
    }

    public @Nullable File find(TemplateZone zone, String location) {
        List<Template> templates = TemplateFactory.getChain(this.template);
        for (Template t : templates) {
            File f = TemplateFiles.get(t, zone, this.webapp, location);
            if (f == null || !f.exists()) continue;
            return f;
        }
        return null;
    }

    public boolean overridesDefault(TemplateZone zone, String location) {
        List<Template> templates = TemplateFactory.getChain(this.template);
        for (Template t : templates) {
            File f;
            if (!this.template.isDefault() || (f = TemplateFiles.get(t, zone, this.webapp, location)) == null || !f.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean exists(String location) {
        File f = Locations.toFile(this.webapp, location);
        return f != null && f.exists();
    }

    public static @Nullable Template forLocation(@Nullable String location) {
        Pattern[] patterns;
        if (location == null) {
            return null;
        }
        for (Pattern p : patterns = new Pattern[]{Pattern.compile("/?WEB-INF/template/([^/]+)/.*"), Pattern.compile("/?woconfig/([^/]+)/.*")}) {
            Template template = TemplateFiles.forLocation(location, p);
            if (template == null) continue;
            return template;
        }
        return null;
    }

    public @Nullable TemplateZone getZone(String location) {
        for (TemplateZone z : this.zones) {
            if (!location.startsWith(z.folder(this.template))) continue;
            return z;
        }
        return null;
    }

    public File getTemplateDirectory() {
        return this.get(Zone.TEMPLATE);
    }

    public @Nullable File getFile(String location) {
        return this.get(Zone.TEMPLATE, location);
    }

    public @Nullable File findFile(String location) {
        List<Template> templates = TemplateFactory.getChain(this.template);
        for (Template t : templates) {
            File f = TemplateFiles.getFile(t, this.webapp, location);
            if (f == null || !f.exists()) continue;
            return f;
        }
        return null;
    }

    public File getWebDirectory() {
        return this.get(Zone.WEB);
    }

    public static @Nullable Zone getZone(Template template, String location) {
        for (Zone zone : Zone.values()) {
            if (!location.startsWith(zone.folder(template))) continue;
            return zone;
        }
        return null;
    }

    public static @Nullable File get(Template template, TemplateZone zone, File webapp, String location) {
        return Locations.toFile(TemplateFiles.getDirectory(template, zone, webapp), location);
    }

    public static @Nullable File find(Template template, TemplateZone zone, File webapp, String location) {
        List<Template> templates = TemplateFactory.getChain(template);
        for (Template t : templates) {
            File f = TemplateFiles.get(t, zone, webapp, location);
            if (f == null || !f.exists()) continue;
            return f;
        }
        return null;
    }

    public static File getDirectory(Template template, TemplateZone zone, File webapp) {
        return new File(webapp, zone.folder(template));
    }

    public static File getWebDirectory(Template template, File webapp) {
        return TemplateFiles.getDirectory(template, Zone.WEB, webapp);
    }

    public static File getTemplateDirectory(Template template, File webapp) {
        return TemplateFiles.getDirectory(template, Zone.TEMPLATE, webapp);
    }

    public static @Nullable File getFile(Template template, File webapp, String location) {
        return Locations.toFile(TemplateFiles.getTemplateDirectory(template, webapp), location);
    }

    public static @Nullable File getFile(Template template, File webapp, String location, @Nullable String format) {
        if (format != null) {
            if (TemplateFiles.isPSML(format)) {
                return Locations.toFile(TemplateFiles.getTemplateDirectory(template, webapp), PSML_FORMAT_FOLDER + File.separator + location);
            }
            return Locations.toFile(TemplateFiles.getTemplateDirectory(template, webapp), FORMAT_PREFIX + format + File.separator + location);
        }
        return new File(TemplateFiles.getTemplateDirectory(template, webapp), location);
    }

    public static @Nullable File findFile(Template template, File webapp, String location) {
        List<Template> templates = TemplateFactory.getChain(template);
        for (Template t : templates) {
            File f = TemplateFiles.getFile(t, webapp, location);
            if (f == null || !f.exists()) continue;
            return f;
        }
        return null;
    }

    static Set<String> available(File webapp) {
        HashSet<String> templates = new HashSet<String>();
        File templateFolder = new File(webapp, Zone.TEMPLATE.folder());
        File[] folders = templateFolder.listFiles(NAME_FILTER);
        if (folders != null) {
            for (File f : folders) {
                templates.add(f.getName());
            }
        }
        return templates;
    }

    private static @Nullable Template forLocation(String location, Pattern p) {
        Matcher m = p.matcher(location);
        if (m.matches()) {
            if (m.groupCount() == 0) {
                return Template.DEFAULT;
            }
            String template = m.group(1);
            return new Template(template);
        }
        return null;
    }

    private static boolean isPSML(String format) {
        return PSML_FORMAT_FOLDER.equals(format);
    }

    public static enum Zone implements TemplateZone
    {
        TEMPLATE{

            @Override
            public String folder() {
                return "/WEB-INF/config/template";
            }

            @Override
            public String folder(Template template) {
                return template.isDefault() ? "/WEB-INF/template/" + template.name() : "/WEB-INF/config/template/" + template.name();
            }
        }
        ,
        WEB{

            @Override
            public String folder() {
                return "/woconfig";
            }

            @Override
            public String folder(Template template) {
                return template.isDefault() ? "/weborganic" : "/woconfig/" + template.name();
            }
        };

    }
}

