/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;

public final class CharsetDetector {
    private static final int MAX_FILE_SIZE = 0xFFFFFF;
    private static final String XML_DECLARATION = "<?xml";
    private static final String XML_ENCODING = "ncoding=";
    private static final int MAX_BOM_SIZE = 4;
    private static final Charset[] DECODE_CHARSETS = new Charset[]{StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE};

    private CharsetDetector() {
    }

    public static @Nullable Charset getFromBOM(File f) throws IOException {
        byte[] bom = new byte[4];
        try (FileInputStream in = new FileInputStream(f);){
            int read = in.read(bom);
            if (read < 2) {
                Charset charset = null;
                return charset;
            }
            for (ByteOrderMark b : ByteOrderMark.values()) {
                if (!b.matches(bom)) continue;
                Charset charset = b.charset();
                return charset;
            }
        }
        return null;
    }

    public static @Nullable Charset getFromBOM(ByteBuffer in) {
        try {
            for (ByteOrderMark b : ByteOrderMark.values()) {
                byte[] bom = new byte[b.mark().length];
                in.get(bom);
                if (b.matches(bom)) {
                    return b.charset();
                }
                CharsetDetector.coerce(in).rewind();
            }
        }
        catch (BufferUnderflowException ex) {
            CharsetDetector.coerce(in).rewind();
            return null;
        }
        CharsetDetector.coerce(in).rewind();
        return null;
    }

    public static @Nullable Charset getFromXMLDeclaration(ByteBuffer in) {
        int start = CharsetDetector.coerce(in).position();
        try {
            byte[] source = new byte[XML_DECLARATION.length()];
            in.get(source);
            if (CharsetDetector.matches(source, XML_DECLARATION)) {
                byte b = CharsetDetector.findEncodingOrEnd(in);
                if (b == 101) {
                    source = new byte[XML_ENCODING.length()];
                    in.get(source);
                    Object encoding = "";
                    if (CharsetDetector.matches(source, XML_ENCODING)) {
                        b = in.get();
                        b = in.get();
                        while (b != 39 && b != 34) {
                            encoding = (String)encoding + (char)b;
                            b = in.get();
                        }
                    }
                    b = CharsetDetector.findEncodingOrEnd(in);
                    b = in.get();
                    if (b == 62) {
                        return Charset.forName((String)encoding);
                    }
                }
            } else {
                byte b;
                boolean be;
                CharsetDetector.coerce(in).position(start);
                source = new byte[XML_DECLARATION.length() * 2];
                in.get(source);
                boolean bl = be = source[0] == 0;
                if (CharsetDetector.matches(source, XML_DECLARATION) && (b = CharsetDetector.findEncodingOrEnd(in)) == 101) {
                    source = new byte[XML_ENCODING.length() * 2];
                    in.get(source);
                    Object encoding = "";
                    if (CharsetDetector.matches(source, XML_ENCODING)) {
                        b = in.get();
                        b = in.get();
                        b = in.get();
                        while (b != 39 && b != 34) {
                            if (b != 0) {
                                encoding = (String)encoding + (char)b;
                            }
                            b = in.get();
                        }
                    }
                    b = CharsetDetector.findEncodingOrEnd(in);
                    b = in.get();
                    b = in.get();
                    if (b == 62) {
                        if (!be) {
                            in.get();
                        }
                        return Charset.forName((String)encoding);
                    }
                }
            }
        }
        catch (BufferUnderflowException ex) {
            CharsetDetector.coerce(in).position(start);
            return null;
        }
        CharsetDetector.coerce(in).position(start);
        return null;
    }

    private static byte findEncodingOrEnd(ByteBuffer in) throws BufferUnderflowException {
        byte b = in.get();
        boolean inwhite = true;
        while (inwhite || b != 101 && b != 63) {
            if (inwhite) {
                while (CharsetDetector.isWhitespace(b) || b == 0) {
                    b = in.get();
                }
                inwhite = false;
                continue;
            }
            while (!(CharsetDetector.isWhitespace(b) && b != 0 || b == 63)) {
                b = in.get();
            }
            inwhite = true;
        }
        return b;
    }

    private static boolean matches(byte[] source, String text) {
        byte[] target = text.getBytes(StandardCharsets.UTF_8);
        if (target.length != source.length && target.length * 2 != source.length) {
            return false;
        }
        int j = 0;
        for (byte element : source) {
            if (element == 0) continue;
            if (element != target[j]) {
                return false;
            }
            ++j;
        }
        return j == target.length;
    }

    private static boolean isWhitespace(byte b) {
        return b == 32 || b == 9 || b == 13 || b == 10;
    }

    public static Charset getFromContent(File f) throws IOException {
        Charset cs = StandardCharsets.US_ASCII;
        try (FileInputStream fis = new FileInputStream(f);
             FileChannel fc = fis.getChannel();){
            int upto = fc.size() > 0xFFFFFFL ? 0xFFFFFF : (int)fc.size();
            MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, upto);
            for (Charset charset : DECODE_CHARSETS) {
                CharsetDecoder decoder = charset.newDecoder();
                decoder.onMalformedInput(CodingErrorAction.REPORT);
                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                CharsetDetector.coerce(buffer).rewind();
                int size = Math.round((float)upto * decoder.maxCharsPerByte());
                CharBuffer out = CharBuffer.allocate(size);
                CoderResult result = decoder.decode(buffer, out, true);
                if (result.isError()) continue;
                Charset charset2 = charset;
                return charset2;
            }
        }
        return cs;
    }

    public static CharBuffer decodeXML(File f) throws IOException {
        int upto = f.length() > 0xFFFFFFL ? 0xFFFFFF : (int)f.length();
        ByteBuffer buffer = CharsetDetector.getFileContent(f, upto);
        return CharsetDetector.decodeXML(buffer);
    }

    public static CharBuffer decodeXML(ByteBuffer buffer) throws IOException {
        Charset cs = StandardCharsets.UTF_8;
        Charset fromBOM = CharsetDetector.getFromBOM(buffer);
        Charset fromDec = CharsetDetector.getFromXMLDeclaration(buffer);
        if (!(fromBOM == null || fromDec == null || fromBOM.equals(fromDec) || fromDec == StandardCharsets.UTF_16 && fromBOM.displayName().startsWith("UTF-16"))) {
            throw new IOException("Byte order mark " + fromBOM.displayName() + " does not match XML declaration enconding " + fromDec.displayName());
        }
        if (fromBOM != null) {
            cs = fromBOM;
        } else if (fromDec != null) {
            cs = fromDec;
        }
        CharsetDecoder decoder = cs.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        int size = Math.round((float)buffer.capacity() * decoder.averageCharsPerByte());
        CharBuffer out = CharBuffer.allocate(size);
        CoderResult result = decoder.decode(buffer, out, true);
        if (result.isError()) {
            throw new IOException("Not encoded correctly as " + cs.displayName());
        }
        CharsetDetector.coerce(out).limit(CharsetDetector.coerce(out).position());
        CharsetDetector.coerce(out).rewind();
        return out;
    }

    public static @Nullable CharBuffer decode(File f) throws IOException {
        int upto = f.length() > 0xFFFFFFL ? 0xFFFFFF : (int)f.length();
        ByteBuffer buffer = CharsetDetector.getFileContent(f, upto);
        Charset cs = CharsetDetector.getFromBOM(buffer);
        for (Charset charset : DECODE_CHARSETS) {
            if (cs != null && !charset.equals(cs)) continue;
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            int size = Math.round((float)upto * decoder.averageCharsPerByte());
            CharBuffer out = CharBuffer.allocate(size);
            CoderResult result = decoder.decode(buffer, out, true);
            if (!result.isError()) {
                CharsetDetector.coerce(out).limit(CharsetDetector.coerce(out).position());
                CharsetDetector.coerce(out).rewind();
                return out;
            }
            CharsetDetector.coerce(buffer).rewind();
        }
        return null;
    }

    private static ByteBuffer getFileContent(File f, int upto) throws IOException {
        FileChannel fc = null;
        ByteBuffer buffer = null;
        try (FileInputStream in = new FileInputStream(f);){
            fc = in.getChannel();
            buffer = ByteBuffer.allocate(upto);
            fc.read(buffer);
            fc.close();
            CharsetDetector.coerce(buffer).rewind();
        }
        return buffer;
    }

    private static Buffer coerce(ByteBuffer buffer) {
        return buffer;
    }

    private static Buffer coerce(CharBuffer buffer) {
        return buffer;
    }

    public static enum ByteOrderMark {
        UTF8(new byte[]{-17, -69, -65}, "UTF-8"),
        UTF16LE(new byte[]{-1, -2}, "UTF-16LE"),
        UTF16BE(new byte[]{-2, -1}, "UTF-16BE");

        private final byte[] bom;
        private final Charset cs;

        private ByteOrderMark(byte[] bom, String cs) {
            this.bom = bom;
            this.cs = Charset.forName(cs);
        }

        public boolean matches(byte[] bom) {
            if (bom.length < this.bom.length) {
                return false;
            }
            for (int i = 0; i < this.bom.length; ++i) {
                if (this.bom[i] == bom[i]) continue;
                return false;
            }
            return true;
        }

        public Charset charset() {
            return this.cs;
        }

        public byte[] mark() {
            return this.bom;
        }
    }
}

