/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.core;

import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.publisher.ant.AntLogMessage;
import com.pageseeder.publisher.ant.AntMessageListener;
import com.pageseeder.publisher.ant.AntRunner;
import com.pageseeder.publisher.exceptions.BuildCancelledException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PublishThread.class.getName());
    private final String id;
    private int logLevel = -1;
    private boolean downloadWorking = false;
    private final File script;
    private final Map<String, String> properties;
    private final String target;
    private final Collection<AntLogMessage> messages = new ConcurrentLinkedQueue<AntLogMessage>();
    private boolean cancel = false;
    private AntLogMessage.MessageType status;

    public PublishThread(String id, File script, String target, Map<String, String> properties) {
        this.id = id;
        this.script = script;
        this.target = target;
        this.properties = new HashMap<String, String>(properties);
        this.status = AntLogMessage.MessageType.INPROGRESS;
        this.messages.add(new AntLogMessage(AntLogMessage.MessageType.INPROGRESS, "Publish Job started", "0", "starting", false));
    }

    public void setDownloadWorking(boolean download) {
        this.downloadWorking = download;
    }

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public void setLogLevel(@Nullable String level) {
        if (level == null) {
            this.logLevel = -1;
        } else if ("info".equalsIgnoreCase(level)) {
            this.logLevel = 2;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.logLevel = 4;
        } else if ("verbose".equalsIgnoreCase(level)) {
            this.logLevel = 3;
        } else if ("warn".equalsIgnoreCase(level)) {
            this.logLevel = 1;
        } else if ("error".equalsIgnoreCase(level)) {
            this.logLevel = 0;
        }
    }

    public boolean isFinished() {
        return AntLogMessage.MessageType.COMPLETE == this.status || AntLogMessage.MessageType.CANCEL == this.status || AntLogMessage.MessageType.ERROR == this.status;
    }

    public void cancel() {
        this.cancel = true;
    }

    public boolean wasCancelled() {
        return this.cancel;
    }

    @Override
    public void run() {
        AntRunner runner = new AntRunner();
        runner.addListener(new AntMessageListener(this, this.getLogLevel()));
        runner.addListener(new CancelListener(this));
        try {
            runner.setProperties(this.properties, false);
            runner.init(this.script.getCanonicalPath(), null, null);
            runner.runTarget(this.target);
            this.downloadWorking();
            if (this.cancel) {
                this.writeCancel();
            } else {
                this.writeComplete();
            }
        }
        catch (BuildCancelledException e) {
            this.downloadWorking();
            this.writeCancel();
        }
        catch (Throwable e) {
            this.downloadWorking();
            if (this.cancel) {
                this.writeCancel();
            } else {
                this.writeFail("An error occurred while running the Ant script: " + e.getMessage());
            }
            LOGGER.warn("Publish script failed", e);
        }
        finally {
            runner.destroy();
            runner = null;
        }
    }

    private int getLogLevel() {
        if (this.logLevel >= 0) {
            return this.logLevel;
        }
        String level = GlobalSettings.get((String)"logging.level");
        if (level != null) {
            if ("debug".equalsIgnoreCase(level)) {
                return 4;
            }
            if ("verbose".equalsIgnoreCase(level)) {
                return 3;
            }
            if ("info".equalsIgnoreCase(level)) {
                return 2;
            }
            if ("warn".equalsIgnoreCase(level)) {
                return 1;
            }
            if ("error".equalsIgnoreCase(level)) {
                return 0;
            }
        }
        return 2;
    }

    public void pushAntLogMessage(AntLogMessage message) {
        if (message.isEmpty() || this.isFinished()) {
            return;
        }
        if (message.isType(AntLogMessage.MessageType.INPROGRESS)) {
            ArrayList<AntLogMessage> toRemove = new ArrayList<AntLogMessage>();
            for (AntLogMessage logMessage : this.messages) {
                if (!logMessage.isType(AntLogMessage.MessageType.INPROGRESS)) continue;
                toRemove.add(logMessage);
            }
            this.messages.removeAll(toRemove);
        }
        this.messages.add(message);
    }

    private void downloadWorking() {
        if (this.downloadWorking) {
            final Path working = new File(this.properties.get("ps-working")).toPath();
            String sessionPath = this.properties.get("ps-sessionfolder") + this.properties.get("ps-groupFolderNoPrefix") + "/ps-working.zip";
            File session = new File(Settings.getContextPath(), "/WEB-INF/state/publish/session/" + sessionPath);
            try (final ZipOutputStream zout = new ZipOutputStream(FileUtils.openOutputStream((File)session));){
                Files.walkFileTree(working, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        zout.putNextEntry(new ZipEntry(working.relativize(file).toString()));
                        Files.copy(file, zout);
                        zout.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                this.messages.add(new AntLogMessage(AntLogMessage.MessageType.ERROR, "Unable to zip working folder: " + ex.getMessage()));
                return;
            }
            this.messages.add(new AntLogMessage(AntLogMessage.MessageType.INFO, "<downloadWorkingLink>" + this.properties.get("ps-engineUrl") + "/session/" + sessionPath + "</downloadWorkingLink>", null, null, true));
        }
    }

    private void writeComplete() {
        this.status = AntLogMessage.MessageType.COMPLETE;
        this.messages.add(new AntLogMessage(AntLogMessage.MessageType.COMPLETE, "Publishing Complete"));
    }

    private void writeCancel() {
        this.status = AntLogMessage.MessageType.CANCEL;
        this.messages.add(new AntLogMessage(AntLogMessage.MessageType.CANCEL, "Publishing Cancelled"));
    }

    private void writeFail(String error) {
        this.status = AntLogMessage.MessageType.ERROR;
        this.messages.add(new AntLogMessage(AntLogMessage.MessageType.ERROR, error));
        this.messages.add(new AntLogMessage(AntLogMessage.MessageType.FAIL, "Publishing Failed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMessages(XMLWriter xml, boolean peek) throws IOException {
        xml.openElement("publish", true);
        xml.attribute("id", this.id);
        xml.openElement("parameters");
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            xml.openElement("param");
            xml.attribute("name", property.getKey());
            xml.attribute("value", property.getValue());
            xml.closeElement();
        }
        xml.closeElement();
        xml.element("status", this.status.toString());
        Collection<AntLogMessage> collection = this.messages;
        synchronized (collection) {
            if (!this.messages.isEmpty()) {
                ArrayList<AntLogMessage> toRemove = new ArrayList<AntLogMessage>();
                Iterator<AntLogMessage> msgs = this.messages.iterator();
                while (msgs.hasNext()) {
                    AntLogMessage msg = msgs.next();
                    msg.toXML(xml);
                    if (peek) continue;
                    if (msgs.hasNext()) {
                        toRemove.add(msg);
                        continue;
                    }
                    msg.setLogged(true);
                }
                this.messages.removeAll(toRemove);
            }
        }
        xml.closeElement();
    }

    public String getMessages(boolean peek) {
        XMLStringWriter xsw = new XMLStringWriter(XML.NamespaceAware.No);
        try {
            this.getMessages((XMLWriter)xsw, peek);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to write log messages as XML", (Throwable)ex);
            throw new UnforeseenException((Throwable)ex);
        }
        return xsw.toString();
    }

    private static final class CancelListener
    implements BuildListener {
        private final PublishThread parent;

        public CancelListener(PublishThread dad) {
            this.parent = dad;
        }

        public void buildFinished(BuildEvent event) {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (this.parent.wasCancelled()) {
                throw new BuildCancelledException();
            }
        }

        public void targetFinished(BuildEvent event) {
            if (this.parent.wasCancelled()) {
                throw new BuildCancelledException();
            }
        }

        public void targetStarted(BuildEvent event) {
            if (this.parent.wasCancelled()) {
                throw new BuildCancelledException();
            }
        }

        public void taskFinished(BuildEvent event) {
            if (this.parent.wasCancelled()) {
                throw new BuildCancelledException();
            }
        }

        public void taskStarted(BuildEvent event) {
            if (this.parent.wasCancelled()) {
                throw new BuildCancelledException();
            }
        }
    }
}

