/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.queries;

import com.pageseeder.common.util.Strings;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.DateTools;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.LuceneUtils;
import org.pageseeder.flint.lucene.facet.DateIntervalFacet;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.facet.NumericIntervalFacet;
import org.pageseeder.flint.lucene.facet.StringIntervalFacet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Intervals {
    private static final Logger LOGGER = LoggerFactory.getLogger(Intervals.class);
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(.+):(\\[|\\{)(.{1,500})(\\]|\\})");
    private static final String NUMBER_PATTERN = "\\d+";
    private static final String FLOAT_PATTERN = "\\d+\\.\\d+";

    private Intervals() {
    }

    public static boolean isInterval(String string) {
        return Intervals.isInterval(string, null);
    }

    public static boolean isInterval(String string, @Nullable Catalog catalog) {
        return Intervals.createInterval(string, catalog) != null;
    }

    public static @Nullable Interval createInterval(@Nullable String string, @Nullable Catalog catalog) {
        String end;
        if (string == null) {
            return null;
        }
        Matcher matcher = INTERVAL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String field = matcher.group(1);
        boolean includeMin = "[".equals(matcher.group(2));
        boolean includeMax = "]".equals(matcher.group(4));
        String[] split1 = Strings.split((String)matcher.group(3), (char)'|', (char)'\\', (boolean)false);
        if (split1 == null || split1.length != 2) {
            return null;
        }
        String interval = split1[1];
        if (interval.isEmpty() || interval.equals("0") || interval.charAt(0) == '-') {
            return null;
        }
        String[] split2 = Strings.split((String)split1[0], (char)';', (char)'\\');
        if (split2 == null || split2.length < 1 || split2.length > 2) {
            return null;
        }
        String start = split2[0];
        String string2 = end = split2.length == 2 ? split2[1] : null;
        if (start.isEmpty() && end == null) {
            return null;
        }
        if (start.equals(end)) {
            return null;
        }
        if (catalog != null) {
            return Intervals.createCatalogInterval(catalog, field, start, end, interval, includeMin, includeMax);
        }
        return Intervals.createFallbackInterval(field, start, end, interval, includeMin, includeMax);
    }

    private static @Nullable Interval createCatalogInterval(Catalog catalog, String field, String start, String end, String interval, boolean includeMin, boolean includeMax) {
        FlintField.NumericType num = catalog.getNumericType(field);
        if (num != null) {
            return Intervals.createNumberInterval(field, start, end, interval, includeMin, includeMax, num);
        }
        DateTools.Resolution res = LuceneUtils.toResolution((FlintField.Resolution)catalog.getResolution(field));
        if (res != null) {
            return Intervals.createDateInterval(field, start, end, interval, includeMin, includeMax, res);
        }
        return Intervals.createFallbackInterval(field, start, end, interval, includeMin, includeMax);
    }

    private static @Nullable Interval createFallbackInterval(String field, String start, @Nullable String end, String interval, boolean includeMin, boolean includeMax) {
        DateInterval dateInterval = Intervals.createDateInterval(field, start, end, interval, includeMin, includeMax, null);
        if (dateInterval != null) {
            return dateInterval;
        }
        NumberInterval numberInterval = Intervals.createNumberInterval(field, start, end, interval, includeMin, includeMax, null);
        if (numberInterval != null) {
            return numberInterval;
        }
        if (end != null && start.compareTo(end) >= 0) {
            return null;
        }
        try {
            int length = Integer.parseInt(interval);
            return new StringInterval(field, start, end, length, includeMin, includeMax);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Invalid interval length {}", (Object)interval);
            return null;
        }
    }

    private static @Nullable DateInterval createDateInterval(String field, String start, @Nullable String end, String interval, boolean includeMin, boolean includeMax, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable DateTools.Resolution resolution) {
        Duration duration;
        OffsetDateTime startDate;
        OffsetDateTime endDate = null;
        try {
            startDate = OffsetDateTime.parse(start);
            if (end != null) {
                endDate = OffsetDateTime.parse(end);
            }
        }
        catch (DateTimeParseException ex) {
            return null;
        }
        Period period = null;
        try {
            duration = Duration.parse("P" + interval.toUpperCase());
        }
        catch (DateTimeParseException ex) {
            duration = null;
        }
        if (duration == null) {
            try {
                period = Period.parse("P" + interval.toUpperCase());
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
        return new DateInterval(field, startDate, endDate, period, duration, includeMin, includeMax, resolution == null ? DateTools.Resolution.SECOND : resolution);
    }

    private static @Nullable NumberInterval createNumberInterval(String field, @Nullable String start, @Nullable String end, @Nullable String interval, boolean includeMin, boolean includeMax, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FlintField.NumericType num) {
        if (start == null || start.isEmpty() || end == null || end.isEmpty() || interval == null || interval.isEmpty()) {
            return null;
        }
        Float from = null;
        Float to = null;
        Float length = null;
        if (start.matches(FLOAT_PATTERN)) {
            from = Float.valueOf(Float.parseFloat(start));
        }
        if (end.matches(FLOAT_PATTERN)) {
            to = Float.valueOf(Float.parseFloat(end));
        }
        if (interval.matches(FLOAT_PATTERN)) {
            length = Float.valueOf(Float.parseFloat(interval));
        }
        if (from != null || to != null || length != null) {
            if (num != FlintField.NumericType.FLOAT && num != FlintField.NumericType.DOUBLE) {
                LOGGER.warn("Wrong numeric type float for interval");
                return null;
            }
            if (from == null && start.matches(NUMBER_PATTERN)) {
                from = Float.valueOf(Float.parseFloat(start));
            }
            if (to == null && end.matches(NUMBER_PATTERN)) {
                to = Float.valueOf(Float.parseFloat(end));
            }
            if (length == null && interval.matches(NUMBER_PATTERN)) {
                length = Float.valueOf(Float.parseFloat(interval));
            }
            if (from == null || to == null || length == null || from.floatValue() >= to.floatValue()) {
                return null;
            }
            return new NumberInterval(field, from, to, length, includeMin, includeMax, num);
        }
        Long fromLong = null;
        Long toLong = null;
        Long lengthLong = null;
        if (start.matches(NUMBER_PATTERN)) {
            fromLong = Long.parseLong(start);
        }
        if (end.matches(NUMBER_PATTERN)) {
            toLong = Long.parseLong(end);
        }
        if (interval.matches(NUMBER_PATTERN)) {
            lengthLong = Long.parseLong(interval);
        }
        if (fromLong == null || toLong == null || lengthLong == null || fromLong >= toLong) {
            return null;
        }
        return new NumberInterval(field, fromLong, toLong, lengthLong, includeMin, includeMax, num == null ? FlintField.NumericType.LONG : num);
    }

    public static class NumberInterval
    extends Interval {
        private final Number start;
        private final @Nullable Number end;
        private final Number length;
        private final boolean withMin;
        private final boolean withMax;
        private final FlintField.NumericType num;

        public NumberInterval(String field, Number start, @Nullable Number end, Number length, boolean includeMin, boolean includeMax, FlintField.NumericType num) {
            super(field);
            this.start = start;
            this.end = end;
            this.length = length;
            this.withMin = includeMin;
            this.withMax = includeMax;
            this.num = num;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new NumericIntervalFacet.Builder().name(this.field).includeLastMax(this.withMax).includeMin(this.withMin).start(this.start).end(this.end).intervalLength(this.length).numeric(this.num).build();
        }

        public String toString() {
            return this.field + ":" + (this.withMin ? "[" : "{") + String.valueOf(this.start) + (String)(this.end != null ? ";" + String.valueOf(this.end) : "") + "|" + String.valueOf(this.length) + (this.withMax ? (char)']' : '}');
        }
    }

    public static class DateInterval
    extends Interval {
        private final OffsetDateTime start;
        private final @Nullable OffsetDateTime end;
        private final @Nullable Period period;
        private final @Nullable Duration duration;
        private final boolean withMin;
        private final boolean withMax;
        private final DateTools.Resolution resolution;

        public DateInterval(String field, OffsetDateTime start, @Nullable OffsetDateTime end, @Nullable Period period, @Nullable Duration dur, boolean includeMin, boolean includeMax, DateTools.Resolution res) {
            super(field);
            this.start = start;
            this.end = end;
            this.period = period;
            this.duration = dur;
            this.withMin = includeMin;
            this.withMax = includeMax;
            this.resolution = res;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new DateIntervalFacet.Builder().name(this.field).includeLastMax(this.withMax).includeMin(this.withMin).resolution(this.resolution).start(this.start).end(this.end).intervalDate(this.period).intervalTime(this.duration).build();
        }

        public String toString() {
            return this.field + ":" + (this.withMin ? "[" : "{") + String.valueOf(this.start) + (String)(this.end != null ? ";" + String.valueOf(this.end) : "") + "|" + String.valueOf(this.period == null ? "" : this.period) + "-" + String.valueOf(this.duration == null ? "" : this.duration) + (this.withMax ? (char)']' : '}');
        }
    }

    public static class StringInterval
    extends Interval {
        private final String start;
        private final @Nullable String end;
        private final int length;
        private final boolean withMin;
        private final boolean withMax;

        public StringInterval(String field, String start, @Nullable String end, int length, boolean includeStart, boolean includeEnd) {
            super(field);
            this.start = start;
            this.end = end;
            this.length = length;
            this.withMin = includeStart;
            this.withMax = includeEnd;
        }

        @Override
        public FlexibleIntervalFacet toFacet() {
            return new StringIntervalFacet.Builder().name(this.field).start(this.start).end(this.end).intervalLength(this.length).includeLastMax(this.withMax).includeMin(this.withMin).build();
        }

        public String toString() {
            return this.field + ":" + (this.withMin ? (char)'[' : '{') + this.start + (String)(this.end != null ? ";" + this.end : "") + "|" + this.length + (this.withMax ? (char)']' : '}');
        }
    }

    public static abstract class Interval {
        protected final String field;

        protected Interval(String field) {
            this.field = field;
        }

        public abstract FlexibleIntervalFacet toFacet();
    }
}

