/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search.flint;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesListener;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.flint.BatchIndexJob;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.IndexUtils;
import com.pageseeder.search.flint.PSContentType;
import com.pageseeder.search.flint.PSRequester;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexChangesListener
implements ChangesListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexChangesListener.class);
    private final Map<ChangesBatch, BatchIndexJob> batches = new HashMap<ChangesBatch, BatchIndexJob>();
    private final IndexMaster master;

    public IndexChangesListener(IndexMaster master) {
        this.master = master;
    }

    private @Nullable BatchIndexJob batch(@Nullable ChangesBatch batch) {
        return batch == null ? null : this.batches.get(batch);
    }

    public void startBatch(Database db, ChangesBatch batch) {
        this.batches.put(batch, new BatchIndexJob(batch.getBatchName()));
    }

    public void completeBatch(Database db, ChangesBatch name) {
        BatchIndexJob batch = this.batches.remove(name);
        if (batch != null) {
            batch.complete(db);
        }
    }

    public void deleteGroup(Database db, @Nullable ChangesBatch batch, Long groupid, String name) {
        this.master.removeIndex(groupid);
    }

    public void createGroup(Database db, @Nullable ChangesBatch batch, Group group) {
        this.master.getIndex(db, group);
    }

    public void modifyGroup(Database db, @Nullable ChangesBatch batch, Group group) {
    }

    public void modifyGroupProperties(Database db, @Nullable ChangesBatch batch, Group group) {
        this.master.reloadGroupProperties(group, db);
    }

    public void archiveGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        this.master.clearIndex(group.getId(), name, new PSRequester("Archiving group " + name));
    }

    public void renameGroup(Database db, @Nullable ChangesBatch batch, Group group, String name) {
        this.master.updateIndex(group, db);
    }

    public void createProject(Database db, @Nullable ChangesBatch batch, Group project) {
    }

    public void deleteProject(Database db, @Nullable ChangesBatch batch, Long projectid, String name) {
        this.master.removeIndex(projectid);
    }

    public void modifyProject(Database db, @Nullable ChangesBatch batch, Group project) {
    }

    public void archiveProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
        this.master.removeIndex(project.getId());
    }

    public void renameProject(Database db, @Nullable ChangesBatch batch, Group project, String name) {
    }

    public void createVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, uri, groups.iterator());
            b.index(db, uri, version.getId(), groups.iterator());
        } else {
            b = new BatchIndexJob("Adding version on document " + uri.getDecodedPath());
            b.index(db, uri, groups.iterator());
            b.index(db, uri, version.getId(), groups.iterator());
            b.complete(db);
        }
    }

    public void archiveVersion(Database db, @Nullable ChangesBatch batch, URI uri, XLink version, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, uri, groups.iterator());
            b.index(db, uri, version.getId(), groups.iterator());
        } else {
            b = new BatchIndexJob("Archiving version on document " + uri.getDecodedPath());
            b.index(db, uri, groups.iterator());
            b.index(db, uri, version.getId(), groups.iterator());
            b.complete(db);
        }
    }

    public void createWorkflow(Database db, @Nullable ChangesBatch batch, XLink workflow, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, workflow, groups.iterator());
        } else {
            this.master.indexUrgent(db, workflow, groups.iterator(), new PSRequester("Creating workflow " + workflow.getId()));
        }
    }

    public void deleteWorkflow(Database db, @Nullable ChangesBatch batch, Long workflow, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildCommentContentID(workflow, true), PSContentType.TASK, groups.iterator());
        } else {
            this.master.deleteUrgent(db, workflow, groups.iterator(), new PSRequester("Deleting workflow " + workflow));
        }
    }

    public void createComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, comment, groups.iterator());
        } else {
            this.master.indexUrgent(db, comment, groups.iterator(), new PSRequester("Creating comment " + comment.getId()));
        }
    }

    public void modifyComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, comment, groups.iterator());
        } else {
            this.master.indexUrgent(db, comment, groups.iterator(), new PSRequester("Editing comment " + comment.getId()));
        }
    }

    public void archiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        this.master.indexUrgent(db, comment, groups.iterator(), new PSRequester("Archiving comment " + comment.getId()));
    }

    public void unarchiveComment(Database db, @Nullable ChangesBatch batch, XLink comment, Collection<Group> groups) {
        this.master.indexUrgent(db, comment, groups.iterator(), new PSRequester("Unarchiving comment " + comment.getId()));
    }

    public void deleteComment(Database db, @Nullable ChangesBatch batch, Long commentid, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildCommentContentID(commentid, true), PSContentType.COMMENT, groups.iterator());
        } else {
            this.master.deleteUrgent(db, commentid, groups.iterator(), new PSRequester("Deleting comment " + commentid));
        }
    }

    public void taskUpdated(Database db, @Nullable ChangesBatch batch, Long rootxlinkid, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildCommentContentID(rootxlinkid, true), PSContentType.COMMENT, groups.iterator());
        } else {
            this.master.deleteUrgent(db, rootxlinkid, groups.iterator(), new PSRequester("Deleting task " + rootxlinkid));
        }
    }

    public void createURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, uri, groups.iterator());
        } else if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this.master.indexURL(uri.getId(), false, null, new PSRequester("Creating uri " + uri.getId()));
            }
        } else {
            this.master.indexUrgent(db, uri, groups.iterator(), new PSRequester("Creating uri " + uri.getId()));
        }
    }

    public void modifyURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, uri, groups.iterator());
        } else if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this.master.indexURL(uri.getId(), uri.isArchived(), null, new PSRequester("Editing uri " + uri.getId()));
            }
        } else {
            this.master.indexUrgent(db, uri, groups.iterator(), new PSRequester("Editing uri " + uri.getId()));
        }
    }

    public void archiveURI(Database db, @Nullable ChangesBatch batch, URI uri, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.index(db, uri, groups.iterator());
        } else if (URIs.isExternal((URI)uri)) {
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                this.master.indexURL(uri.getId(), true, null, new PSRequester("Archiving uri " + uri.getId()));
            }
        } else {
            this.master.indexUrgent(db, uri, groups.iterator(), new PSRequester("Archiving uri " + uri.getId()));
        }
    }

    public void deleteDocument(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildURIContentID(uriid, true), PSContentType.DOCUMENT, groups.iterator());
        } else {
            this.master.deleteDocument(db, uriid, groups.iterator(), new PSRequester("Deleting document " + uriid));
        }
    }

    public void deleteFolder(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildURIContentID(uriid, true), PSContentType.FOLDER, groups.iterator());
        } else {
            this.master.deleteFolder(db, uriid, groups.iterator(), new PSRequester("Deleting folder " + uriid));
        }
    }

    public void deleteURL(Database db, @Nullable ChangesBatch batch, Long uriid, @Nullable String docid, String path, Collection<Group> groups) {
        BatchIndexJob b = this.batch(batch);
        if (b != null) {
            b.delete(db, IndexUtils.buildURIContentID(uriid, true), PSContentType.URL, Collections.emptyIterator());
        } else {
            this.master.indexURL(uriid, true, null, new PSRequester("Deleting URL " + uriid));
        }
    }

    public void createPublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> added) {
        BatchIndexJob b = this.batch(batch);
        try {
            if (b != null) {
                this.indexObjectsForURIs(db, b, added);
            } else {
                b = new BatchIndexJob("Creation of publication " + pub.getId());
                this.indexObjectsForURIs(db, b, added);
                b.complete(db);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to index changes for publication creation {}", (Object)pub.getId(), (Object)ex);
        }
    }

    public void modifyPublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> added, Collection<URI> modified, Collection<URI> removed, Collection<Long> deletedUriids) {
        HashSet<URI> uris = new HashSet<URI>();
        uris.addAll(added);
        uris.addAll(removed);
        BatchIndexJob b = this.batch(batch);
        try {
            if (b != null) {
                this.indexObjectsForURIs(db, b, uris);
            } else {
                b = new BatchIndexJob("Updates to publication " + pub.getId());
                this.indexObjectsForURIs(db, b, uris);
                b.complete(db);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to index changes for publication modification {}", (Object)pub.getId(), (Object)ex);
        }
    }

    public void deletePublication(Database db, @Nullable ChangesBatch batch, Publication pub, Collection<URI> removed) {
        BatchIndexJob b = this.batch(batch);
        try {
            if (b != null) {
                this.indexObjectsForURIs(db, b, removed);
            } else {
                b = new BatchIndexJob("Deletion of publication " + pub.getId());
                this.indexObjectsForURIs(db, b, removed);
                b.complete(db);
            }
        }
        catch (DatabaseException ex) {
            LOGGER.error("Failed to index changes for publication deletion {}", (Object)pub.getId(), (Object)ex);
        }
    }

    private void indexObjectsForURIs(Database db, BatchIndexJob b, Collection<URI> uris) throws QueryFailedException {
        for (URI uri : uris) {
            Collection groups = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            b.index(db, uri, groups.iterator());
            List xlinks = DatabaseQuery.getCommentsByURIGroups((Database)db, (int)1, (int)-1, (Collection)GroupRule.getGroupNames((Collection)groups), (Long)uri.getId());
            List workflows = DatabaseQuery.getXLinksByURIRootWorkflowAllGroups((Database)db, (URI)uri);
            xlinks.addAll(workflows);
            for (XLink xlink : xlinks) {
                Collection cgroups = XLinkRule.getGroups((XLink)xlink);
                b.index(db, xlink, cgroups.iterator());
            }
        }
    }
}

