/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.OverallSummaryBuilder;
import com.pageseeder.base.logback.XLogException;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.log.PSIndexListener;
import java.io.IOException;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;

@Requires(database=true)
@Output(types={OutputType.XML})
public final class ViewSummaryLogs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.ignore_group, false)) {
            return new AdminSystemCheck(req.getHttpServletRequest());
        }
        return new EditURICheck(req.getGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        boolean allgroups = req.getParameter((Parameter)StandardParameters.ignore_group, false);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("indexing");
        Logger logger = req.getLogger((Object)this);
        try {
            IndexMaster master = IndexMaster.getInstance();
            IndexListener listener = master.getListener();
            if (!(listener instanceof PSIndexListener)) {
                return;
            }
            PSIndexListener indexLogger = (PSIndexListener)listener;
            OverallSummaryBuilder summary = new OverallSummaryBuilder((XLoggerAdaptor)indexLogger);
            if (!allgroups && req.getGroup() != null) {
                summary.setGroup(req.getGroup().getId());
            }
            summary.build();
            summary.toXML(xml);
        }
        catch (XLogException ex) {
            logger.error("unable to generate log summary", (Throwable)ex);
        }
        catch (IOException ex) {
            if (allgroups) {
                logger.error("Failed to load all logs", (Throwable)ex);
            } else {
                logger.error("Failed to load logs for {}", (Object)req.getGroup(), (Object)ex);
            }
        }
        finally {
            xml.closeElement();
        }
        xml.flush();
    }
}

