/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Member;
import com.pageseeder.search.ServerIndexingThread;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@Requires(database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ServerIndexing
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member member = req.getMember();
        assert (member != null);
        String prefix = req.getParameter((Parameter)StandardParameters.prefix, "");
        String types = req.getParameter((Parameter)StandardParameters.include, "personal,projects,urls,help");
        List<String> groupTypes = Arrays.asList(types.split(","));
        ServerIndexingThread sthread = ServerIndexingThread.newInstance(member.getUsername());
        sthread.setGroupNamePrefix(prefix);
        sthread.setGroupsToIndex(groupTypes.contains("help"), groupTypes.contains("urls"), groupTypes.contains("personal"), groupTypes.contains("projects"));
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)sthread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("server-indexing");
        sthread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

