/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Group;
import com.pageseeder.search.flint.IndexMaster;
import java.io.IOException;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class IndexStatus
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.ignore_group, false)) {
            return new AdminSystemCheck(req.getHttpServletRequest());
        }
        return new EditURICheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getParameter((Parameter)StandardParameters.ignore_group, false) ? null : req.getGroup();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("indexing");
        IndexMaster.getInstance().writeIndexStatus(req.getDatabase(), group, out);
        out.endObject();
        out.flush();
    }
}

