/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.search;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.search.flint.IndexAnalyzers;
import com.pageseeder.search.flint.IndexErrorID;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.queries.AutoSuggestQuery;
import com.pageseeder.search.utils.Results;
import com.pageseeder.search.utils.SearchUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.lucene.LuceneIndex;
import org.pageseeder.flint.lucene.query.SearchPaging;
import org.pageseeder.flint.lucene.query.SearchQuery;
import org.pageseeder.flint.lucene.query.SearchResults;
import org.pageseeder.flint.lucene.search.StringTermFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Output(types={OutputType.XML, OutputType.JSON})
@Requires(database=true)
public final class AutoSuggest
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSuggest.class);
    private static final int DEFAULT_MAX_RESULTS = 10;

    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member member = req.getMember();
        Group group = req.getGroup();
        if (member != null && group != null) {
            return new ViewMemberCheck(member, (PermissionCheck)new ViewGroupCheck(group));
        }
        if (member == null) {
            return new ViewGroupCheck(group);
        }
        return new ViewMemberCheck(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Query filters;
        Analyzer analyser;
        Group group;
        Catalog catalog;
        Map<Group, Boolean> groups = SearchUtils.loadGroupsToSearch(req, res);
        List<LuceneIndex> indexes = SearchUtils.loadIndexes(req, res, groups);
        if (indexes == null) {
            return;
        }
        if (indexes.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.MISSING_INDEX);
            return;
        }
        String input = req.getParameter((Parameter)StandardParameters.term, "");
        String fieldsList = req.getParameter((Parameter)StandardParameters.fields, "pstitle,psfilename,psdocid,psid");
        String predicate = req.getParameter((Parameter)StandardParameters.predicate);
        int maxResults = (int)req.getParameter((Parameter)StandardParameters.results, 10L);
        if (input.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Empty search term");
            return;
        }
        int max = GlobalSettings.getInt((String)"maxPageSize", (int)10000);
        if (maxResults > max) {
            maxResults = max;
        }
        List<String> fields = Arrays.asList(fieldsList.trim().split(","));
        if (req.getGroup() == null) {
            for (String field : fields) {
                if (!SearchUtils.disallowedGeneralField(field)) continue;
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, "Cannot use filter " + field + " in global autosuggest");
                return;
            }
        }
        if ((catalog = SearchUtils.loadCatalog(indexes, group = req.getGroup())) == null) {
            catalog = SearchUtils.getGlobalCatalog();
        }
        if ((analyser = SearchUtils.loadAnalyzer(indexes, group)) == null) {
            try {
                analyser = IndexAnalyzers.getAnalyzer(null);
            }
            catch (IOException | SAXException ex) {
                LOGGER.error("Failed to create global analyser", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create global analyser: " + ex.getMessage());
                return;
            }
        }
        try {
            filters = SearchUtils.loadFiltersAsQuery(req, catalog);
        }
        catch (IndexException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)IndexErrorID.INVALID_SEARCH_FIELD, ex.getMessage());
            return;
        }
        if (group != null && !groups.isEmpty() && indexes.contains((Object)IndexMaster.getInstance().getURLsIndex())) {
            StringTermFilter.Builder filter = new StringTermFilter.Builder().name("psgroupname");
            for (Group gp : groups.keySet()) {
                filter.addTerm(gp.getName(), BooleanClause.Occur.SHOULD);
            }
            filters = filter.build().filterQuery(filters);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("autosuggest");
        out.field("indexes", SearchUtils.indexesToString(indexes));
        out.field("fields", String.join((CharSequence)",", fields));
        out.field("term", input);
        SearchResults results = null;
        try {
            results = IndexMaster.getInstance().getSuggestions(new ArrayList<LuceneIndex>(indexes), fields, input, maxResults, true, true, filters, predicate);
        }
        catch (IndexException ex) {
            LOGGER.debug("Failed to run autosuggest", (Throwable)ex);
            out.field("error", ex.getMessage());
        }
        if (results != null) {
            try {
                SearchQuery q = results.query();
                out.startObject("query");
                out.field("empty", Boolean.toString(q.isEmpty()));
                if (!q.isEmpty()) {
                    out.field("predicate", q.toQuery().toString());
                }
                if (q instanceof AutoSuggestQuery && ((AutoSuggestQuery)q).isIncomplete()) {
                    out.field("incomplete", "true");
                }
                out.endObject();
                Results.print(results, new SearchPaging(1, maxResults), fields, 1000, catalog, analyser, groups.keySet(), (OutputPrinter)out);
            }
            finally {
                results.terminate();
            }
        }
        out.endObject();
        out.flush();
    }
}

