/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;

public class TermFilter<T> {
    protected final String _name;
    protected final Map<T, BooleanClause.Occur> _terms = new HashMap<T, BooleanClause.Occur>();

    TermFilter(String name, Map<T, BooleanClause.Occur> terms) {
        this._name = name;
        this._terms.putAll(terms);
    }

    public String name() {
        return this._name;
    }

    public Map<T, BooleanClause.Occur> terms() {
        return Collections.unmodifiableMap(this._terms);
    }

    static String occurToString(BooleanClause.Occur occur) {
        if (occur == BooleanClause.Occur.MUST) {
            return "must";
        }
        if (occur == BooleanClause.Occur.MUST_NOT) {
            return "must_not";
        }
        if (occur == BooleanClause.Occur.SHOULD) {
            return "should";
        }
        return "unknown";
    }
}

