/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.search;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

public final class FieldDocumentCounter
extends SimpleCollector {
    private int count = 0;
    private final String field;
    private LeafReaderContext context = null;

    public FieldDocumentCounter(String fieldname) {
        this.field = fieldname;
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    protected void doSetNextReader(LeafReaderContext ctxt) {
        this.context = ctxt;
    }

    public void collect(int doc) {
        if (this.context != null) {
            Document d;
            try (LeafReader reader = this.context.reader();){
                d = reader.storedFields().document(doc, Collections.singleton(this.field));
            }
            catch (IOException ex) {
                return;
            }
            if (d != null && d.getField(this.field) != null) {
                ++this.count;
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }
}

