/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.sax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.pageseeder.xmlwriter.IllegalCloseElementException;
import org.pageseeder.xmlwriter.UnclosedElementException;
import org.pageseeder.xmlwriter.UndeclaredNamespaceException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class XMLWriterSAX
implements XMLWriter {
    private static final PrefixMapping DEFAULT_NS = new PrefixMapping("", "");
    private static final Element ROOT;
    private static final char[] NEW_LINE;
    private final ContentHandler _handler;
    private boolean indent;
    private char[] indentChars;
    private transient int depth;
    private transient boolean isNude;
    private transient Hashtable<String, String> prefixMapping = new Hashtable();
    private transient List<PrefixMapping> tempMapping;
    private transient List<Element> elements = new ArrayList<Element>();
    private transient AttributesImpl attributes = new AttributesImpl();

    public XMLWriterSAX(ContentHandler handler) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException("XMLWriter cannot use a null content handler.");
        }
        this._handler = handler;
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
    }

    @Override
    public void xmlDecl() {
    }

    @Override
    public void setIndentChars(String spaces) throws IllegalStateException, IllegalArgumentException {
        if (this.depth != 0) {
            throw new IllegalStateException("To late to set the indentation characters!");
        }
        if (spaces != null) {
            for (int i = 0; i < spaces.length(); ++i) {
                if (Character.isSpaceChar(spaces.charAt(i))) continue;
                throw new IllegalArgumentException("Not a valid indentation string.");
            }
            this.indentChars = spaces.toCharArray();
        }
        this.indent = spaces != null;
    }

    @Override
    public void writeText(String text) throws IOException {
        if (text == null) {
            return;
        }
        try {
            this.deNude();
            this._handler.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    @Override
    public void writeText(char[] text, int off, int len) throws IOException {
        try {
            this.deNude();
            this._handler.characters(text, off, len);
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    @Override
    public void writeText(char c) throws IOException {
        try {
            this.deNude();
            this._handler.characters(new char[]{c}, 0, 1);
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    public void writeText(Object o) throws IOException {
        if (o != null) {
            this.writeText(o.toString());
        }
    }

    @Override
    public void writeCDATA(String data) throws IOException {
        if (data == null) {
            return;
        }
        try {
            this.deNude();
            this._handler.characters(data.toCharArray(), 0, data.length());
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    @Override
    public void writeXML(String text) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot run unparsed XML as SAX events");
    }

    @Override
    public void writeXML(char[] text, int off, int len) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot run unparsed XML as SAX events");
    }

    @Override
    public void writeComment(String comment) {
    }

    @Override
    public void writePI(String target, String data) throws IOException {
        try {
            this.deNude();
            this._handler.processingInstruction(target, data);
            if (this.indent) {
                this.newLine();
            }
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    @Override
    public void attribute(String name, String value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.attributes.addAttribute(name, value);
    }

    @Override
    public void attribute(String name, int value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.attributes.addAttribute(name, Integer.toString(value));
    }

    @Override
    public void attribute(String uri, String name, String value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.attributes.addAttribute(uri, name, value);
    }

    @Override
    public void attribute(String uri, String name, int value) throws IOException {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        this.attributes.addAttribute(uri, name, Integer.toString(value));
    }

    private void deNude() throws SAXException {
        if (this.isNude) {
            this.indent();
            Element elt = this.peekElement();
            if (elt.mappings != null) {
                for (int i = 0; i < elt.mappings.size(); ++i) {
                    PrefixMapping pm = (PrefixMapping)elt.mappings.get(i);
                    this._handler.startPrefixMapping(pm.prefix, pm.uri);
                }
            }
            this._handler.startElement(elt.uri, elt.name, this.getQName(elt.uri, elt.name), this.attributes);
            this.attributes = new AttributesImpl();
            if (this.indent && elt.hasChildren) {
                this.newLine();
            }
            this.isNude = false;
        }
    }

    @Override
    public void openElement(String name) throws IOException {
        this.openElement("", name, false);
    }

    public void openElement(String uri, String name) throws IOException {
        this.openElement(uri, name, false);
    }

    @Override
    public void openElement(String name, boolean hasChildren) throws IOException {
        this.openElement("", name, hasChildren);
    }

    @Override
    public void openElement(String uri, String name, boolean hasChildren) throws IOException {
        try {
            this.deNude();
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
        this.elements.add(new Element(uri, name, hasChildren, this.tempMapping));
        this.tempMapping = null;
        this.isNude = true;
        ++this.depth;
    }

    @Override
    public void element(String name, String text) throws IOException {
        this.openElement(name);
        this.writeText(text);
        this.closeElement();
    }

    @Override
    public void flush() {
    }

    private void indent() throws SAXException {
        if (this.indent) {
            char[] ch = new char[this.depth * this.indentChars.length];
            for (int i = 0; i < this.depth; ++i) {
                for (int j = 0; j < this.indentChars.length; ++j) {
                    ch[i * this.indentChars.length + j] = this.indentChars[j];
                }
            }
            this._handler.ignorableWhitespace(ch, 0, ch.length);
        }
    }

    @Override
    public void closeElement() throws IOException {
        --this.depth;
        try {
            Element parent;
            Element elt;
            if (this.isNude) {
                this.deNude();
            }
            if ((elt = this.popElement()) == ROOT) {
                throw new IllegalCloseElementException();
            }
            if (elt.hasChildren) {
                this.indent();
            }
            this._handler.endElement(elt.uri, elt.name, this.getQName(elt.uri, elt.name));
            if (elt.mappings != null) {
                for (int i = 0; i < elt.mappings.size(); ++i) {
                    PrefixMapping pm = (PrefixMapping)elt.mappings.get(i);
                    this._handler.endPrefixMapping(pm.prefix);
                }
            }
            this.restorePrefixMapping(elt);
            if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
                this.newLine();
            }
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    @Override
    public void emptyElement(String element) throws IOException {
        this.emptyElement(null, element);
    }

    @Override
    public void emptyElement(String uri, String element) throws IOException {
        try {
            this.deNude();
            this.indent();
            this._handler.startElement(uri, element, "", new AttributesImpl());
            this._handler.endElement(uri, element, "");
            this.tempMapping = null;
            this.newLine();
        }
        catch (SAXException ex) {
            this.handleEx(ex);
        }
    }

    private Element peekElement() {
        return this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return this.elements.remove(this.elements.size() - 1);
    }

    @Override
    public void setPrefixMapping(String uri, String prefix) throws NullPointerException {
        if (!prefix.equals(this.prefixMapping.get(uri))) {
            this.removeIfNeeded(prefix);
            PrefixMapping pm = new PrefixMapping(prefix, uri);
            this.prefixMapping.put(pm.uri, pm.prefix);
            if (this.tempMapping == null) {
                this.tempMapping = new ArrayList<PrefixMapping>();
            }
            this.tempMapping.add(pm);
        }
    }

    private String getQName(String uri, String name) throws UndeclaredNamespaceException {
        String prefix = this.prefixMapping.get(uri != null ? uri : "");
        if (prefix != null) {
            if (!"".equals(prefix)) {
                return this.prefixMapping.get(uri) + ":" + name;
            }
            return name;
        }
        throw new UndeclaredNamespaceException(uri);
    }

    private void restorePrefixMapping(Element elt) {
        if (elt.mappings != null) {
            for (int i = 0; i < elt.mappings.size(); ++i) {
                PrefixMapping mpi = (PrefixMapping)elt.mappings.get(i);
                block1: for (int j = this.elements.size() - 1; j > 0; --j) {
                    if (this.elements.get(j).mappings == null) continue;
                    List mps = this.elements.get(j).mappings;
                    for (int k = 0; k < mps.size(); ++k) {
                        PrefixMapping mpk = (PrefixMapping)mps.get(k);
                        if (!mpk.prefix.equals(mpi.prefix)) continue;
                        this.removeIfNeeded(mpk.prefix);
                        this.prefixMapping.put(mpk.uri, mpk.prefix);
                        j = 0;
                        continue block1;
                    }
                }
            }
        }
    }

    private void removeIfNeeded(String prefix) {
        if (this.prefixMapping.containsValue(prefix)) {
            String key = null;
            Enumeration<String> e = this.prefixMapping.keys();
            while (e.hasMoreElements() && !this.prefixMapping.get(key = e.nextElement()).equals(prefix)) {
            }
            this.prefixMapping.remove(key);
        }
    }

    @Override
    public void close() throws IOException, UnclosedElementException {
        Element open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open.name);
        }
    }

    private void newLine() throws SAXException {
        this._handler.characters(NEW_LINE, 0, 1);
    }

    private void handleEx(SAXException ex) throws IOException {
        throw new IOException("Exception thrown by the wrapped content handler:\n" + ex.getMessage());
    }

    static {
        ArrayList<PrefixMapping> mps = new ArrayList<PrefixMapping>();
        mps.add(DEFAULT_NS);
        ROOT = new Element("", "", true, mps);
        NEW_LINE = new char[]{'\n'};
    }

    private static final class AttributesImpl
    implements Attributes {
        private static final String CDATA = "CDATA";
        private final List<String> uris = new ArrayList<String>();
        private final List<String> names = new ArrayList<String>();
        private final List<String> values = new ArrayList<String>();

        public void addAttribute(String name, String value) {
            this.uris.add("");
            this.names.add(name);
            this.values.add(value);
        }

        public void addAttribute(String uri, String name, String value) {
            this.uris.add("");
            this.names.add(name);
            this.values.add(value);
        }

        @Override
        public int getLength() {
            return this.names.size();
        }

        @Override
        public String getQName(int i) {
            if (i < 0) {
                return null;
            }
            try {
                return this.getLocalName(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String getLocalName(int i) {
            if (i < 0) {
                return null;
            }
            try {
                return this.names.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String getType(int i) {
            if (i < 0) {
                return null;
            }
            try {
                return CDATA;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String getValue(int i) {
            if (i < 0) {
                return null;
            }
            try {
                return this.values.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String getURI(int i) {
            if (i < 0) {
                return null;
            }
            try {
                return this.uris.get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String name) {
            return null;
        }

        @Override
        public String getType(String uri, String name) {
            return this.getType(this.getIndex(uri, name));
        }

        @Override
        public String getValue(String uri, String name) {
            return this.getValue(this.getIndex(uri, name));
        }

        @Override
        public int getIndex(String uri, String localName) {
            int index = this.names.indexOf(localName);
            if (index == -1) {
                return index;
            }
            if (this.uris.get(index).equals(uri)) {
                return index;
            }
            for (int i = 0; i < this.names.size(); ++i) {
                if (!this.names.get(i).equals(localName) || !this.uris.get(i).equals(uri)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            return this.getIndex("", qName);
        }
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String uri;

        public PrefixMapping(String prefix, String uri) {
            this.prefix = prefix != null ? prefix : "";
            this.uri = uri != null ? uri : "";
        }
    }

    private static final class Element {
        private final String uri;
        private final String name;
        private final List<PrefixMapping> mappings;
        private final boolean hasChildren;

        public Element(String uri, String name, boolean hasChildren, List<PrefixMapping> mappings) {
            this.uri = uri;
            this.name = name;
            this.hasChildren = hasChildren;
            this.mappings = mappings;
        }
    }
}

