/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.xmlwriter.esc;

import java.io.IOException;
import java.io.Writer;
import org.pageseeder.xmlwriter.esc.XMLEscapeWriter;

abstract class XMLEscapeWriterBase
implements XMLEscapeWriter {
    private final String encoding;
    final Writer w;

    XMLEscapeWriterBase(Writer writer, String encoding) {
        if (writer == null) {
            throw new NullPointerException("Cannot construct XML escape for null writer.");
        }
        this.w = writer;
        this.encoding = encoding;
    }

    @Override
    public final void writeAttValue(String value) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        this.writeAttValue(value.toCharArray(), 0, value.length());
    }

    @Override
    public final void writeText(String value) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        this.writeText(value.toCharArray(), 0, value.length());
    }

    @Override
    public final String getEncoding() {
        return this.encoding;
    }
}

