/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class ZonedDateTimeTimestampConverter
implements TypeConverter<ZonedDateTime, Timestamp> {
    private static final long serialVersionUID = 1020419574496380608L;

    @Override
    public ZonedDateTime toMemberType(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
    }

    @Override
    public Timestamp toDatastoreType(ZonedDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        return new Timestamp(Date.from(datetime.toInstant()).getTime());
    }
}

