/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateDateConverter
implements TypeConverter<LocalDate, Date> {
    private static final long serialVersionUID = -7505431105592812715L;

    @Override
    public LocalDate toMemberType(Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public Date toDatastoreType(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

