/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.xml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class Namespace {
    public static final Namespace NO_NAMESPACE = new Namespace("", "");
    public static final Namespace XML_NAMESPACE = new Namespace("http://www.w3.org/XML/1998/namespace", "xml");
    public static final Namespace XMLNS_ATTRIBUTE = new Namespace("http://www.w3.org/2000/xmlns/", "xmlns");
    private final String uri;
    private final String prefix;
    private static final Map<String, Namespace> COMMON_NAMESPACES = new HashMap<String, Namespace>();

    public Namespace(String uri, String prefix) {
        this.uri = Objects.requireNonNull(uri);
        this.prefix = Objects.requireNonNull(prefix);
    }

    @NotNull
    public String getUri() {
        return this.uri;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return this.getUri().equals(namespace.getUri()) && this.getPrefix().equals(namespace.getPrefix());
    }

    public int hashCode() {
        return Objects.hash(this.getUri(), this.getPrefix());
    }

    public String toString() {
        return "{" + this.uri + "}=" + this.prefix;
    }

    public static boolean isDeclarable(Namespace namespace) {
        return !XML_NAMESPACE.equals(namespace) && !XMLNS_ATTRIBUTE.equals(namespace) && !NO_NAMESPACE.equals(namespace);
    }

    public static Namespace getCommon(String uri) {
        if (COMMON_NAMESPACES.isEmpty()) {
            Namespace.loadCommonNamespaces();
        }
        return COMMON_NAMESPACES.get(uri);
    }

    private static synchronized void loadCommonNamespaces() {
        try {
            String resourceName = "namespaces.properties";
            Properties props = new Properties();
            try (InputStream resourceStream = Namespace.class.getResourceAsStream(resourceName);){
                props.load(resourceStream);
            }
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(prefix, uri) -> COMMON_NAMESPACES.put(uri.toString(), new Namespace(uri.toString(), prefix.toString()))));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

