/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.similarity;

import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.similarity.Similarity;
import org.pageseeder.diffx.similarity.StreamSimilarity;
import org.pageseeder.diffx.token.ElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;

public class ElementSimilarity
implements Similarity<XMLToken> {
    private final StreamSimilarity<String> similarity;
    private final double k;

    public ElementSimilarity(@NotNull StreamSimilarity<String> similarity, double k) {
        this.similarity = Objects.requireNonNull(similarity);
        this.k = k;
    }

    @Override
    public final float score(@NotNull XMLToken a, @NotNull XMLToken b) {
        if (a.getType() == XMLTokenType.ELEMENT && b.getType() == XMLTokenType.ELEMENT) {
            return this.scoreForElement((ElementToken)a, (ElementToken)b);
        }
        return a.equals(b) ? 1.0f : 0.0f;
    }

    private float scoreForElement(ElementToken a, ElementToken b) {
        boolean sameElementName = a.getStart().equals(b.getStart());
        if (!sameElementName) {
            return 0.0f;
        }
        if (a.getContent().isEmpty() && b.getContent().isEmpty()) {
            return 1.0f;
        }
        float score = this.similarity.score(this.toTextStream(a), this.toTextStream(b));
        if (this.k <= 0.0) {
            return score;
        }
        int length = Math.min(a.getContent().size(), b.getContent().size());
        return this.lengthBoostedSimilarity(score, length);
    }

    protected float lengthBoostedSimilarity(float score, int length) {
        return (float)Math.pow(score, 1.0 / Math.pow(length, this.k));
    }

    private Stream<String> toTextStream(ElementToken element) {
        return element.getContent().stream().filter(t -> t.getType() == XMLTokenType.TEXT).map(t -> t.getValue().trim());
    }
}

